/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink;

import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ENewError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.cache.TEVBMOCache;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLinkMOPO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;

public final class TEE2EVBLinkUtil {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EVBLinkUtil() {
    }

    protected static boolean isVbLinkExist(QAsnEthXCInfo asnVBLink, TEEtherBridgeMOPO vbMO) {
        boolean isExist = false;
        Set moVBLinkSet = vbMO.getLinkList();
        Iterator iter = moVBLinkSet.iterator();
        TEEtherVBLinkMOPO moVBLink = null;
        while (iter.hasNext()) {
            moVBLink = (TEEtherVBLinkMOPO)iter.next();
            if (!TEE2EVBLinkUtil.isMOEqualsAsn(moVBLink, asnVBLink)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    protected static int saveVBLinkToDB(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrList, TEEtherBridgeMOPO vbMO) {
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        int xcID = ethXCInfo.xcIndex.xcID;
        if (null == vbMO) {
            TEE2EVBLinkUtil.logVBMONullError(neID, slotID, vbID, xcID);
            retCode = 1090598181;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID, xcID}));
            return retCode;
        }
        TEEtherVBLinkMOPO vblinkMO = TEE2EVBUtil.asn2moEthXC(ethXCInfo);
        vbMO.getLinkList().add(vblinkMO);
        vbMO.setPortNum(vbMO.getPortNum() + 1);
        retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            TEE2EVBLinkUtil.logUpdateVBMOToDBFailError(neID, slotID);
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID, xcID}));
            return retCode;
        }
        return retCode;
    }

    public static TEEtherVBLinkMOPO getVBLinkFromCache(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrList, TEVBMOCache vbMOCache) {
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        TEEtherBridgeMOPO vbMO = vbMOCache.getMO(neID, slotID, vbID);
        if (null == vbMO) {
            TEE2EVBLinkUtil.logVBMONullError(neID, slotID);
            retCode = 1090598181;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            return null;
        }
        boolean isFound = false;
        TEEtherVBLinkMOPO vbLinkMO2 = null;
        Set vbLinkMOSet = vbMO.getLinkList();
        for (TEEtherVBLinkMOPO vbLinkMO2 : vbLinkMOSet) {
            if (!TEE2EVBLinkUtil.isMOEqualsAsn(vbLinkMO2, ethXCInfo)) continue;
            return vbLinkMO2;
        }
        if (!isFound) {
            TEE2EVBLinkUtil.logVblinkMOError(neID, slotID);
            retCode = 1090598186;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            return null;
        }
        return null;
    }

    protected static int saveVBLinkToDB(int neID, int slotID, int vbID, TEEtherVBLinkMOPO vbLinkMO, QAsnErrInfoList rspErrList) {
        int retCode = 0;
        TEEtherBridgeMOPO vbMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        if (null == vbMO) {
            TEE2EVBLinkUtil.logSaveVBLinkToDBNullVBMOError(neID, slotID);
            retCode = 1090598181;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            return retCode;
        }
        Set vbLinkMOSet = vbMO.getLinkList();
        vbLinkMOSet.add(vbLinkMO);
        retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            TEE2EVBLinkUtil.logUpdateVBMOToDBFailError(neID, slotID);
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            return retCode;
        }
        return retCode;
    }

    public static boolean isMOEqualsAsn(TEEtherVBLinkMOPO vblinkMO, QAsnEthXCInfo ethXCInfo) {
        int moSrcPortID = vblinkMO.getPhyPortID();
        short moSrcPortType = vblinkMO.getPhyPortType();
        int moSrcVlanID = vblinkMO.getCVLanID();
        int moSrcSVlanID = vblinkMO.getSVLanID();
        int moSnkPortID = vblinkMO.getVBPortID();
        int moSnkPortType = 3;
        ArrayList<Integer> moAttrList = new ArrayList<Integer>();
        moAttrList.add(moSrcPortID);
        moAttrList.add(Integer.valueOf(moSrcPortType));
        moAttrList.add(moSrcVlanID);
        moAttrList.add(moSrcSVlanID);
        moAttrList.add(moSnkPortID);
        moAttrList.add(moSnkPortType);
        TEEtherVBLinkMOPO asnVBLinkMO = TEE2EVBUtil.asn2moEthXC(ethXCInfo);
        int asnSrcPortID = asnVBLinkMO.getPhyPortID();
        short asnSrcPortType = asnVBLinkMO.getPhyPortType();
        int asnSrcVlanID = asnVBLinkMO.getCVLanID();
        int asnSrcSVlanID = asnVBLinkMO.getSVLanID();
        int asnSnkPortID = asnVBLinkMO.getVBPortID();
        int asnSnkPortType = 3;
        ArrayList<Integer> asnAttrList = new ArrayList<Integer>();
        asnAttrList.add(asnSrcPortID);
        asnAttrList.add(Integer.valueOf(asnSrcPortType));
        asnAttrList.add(asnSrcVlanID);
        asnAttrList.add(asnSrcSVlanID);
        asnAttrList.add(asnSnkPortID);
        asnAttrList.add(asnSnkPortType);
        int len = moAttrList.size();
        for (int i = 0; i < len; ++i) {
            if (((Integer)moAttrList.get(i)).intValue() == ((Integer)asnAttrList.get(i)).intValue()) continue;
            return false;
        }
        return true;
    }

    private static void logUpdateVBMOToDBFailError(int neID, int slotID) {
        String tipStr = "saveVBLinkToDB: save vb mo to db fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        e2eLogger.error(tipStr);
    }

    private static void logVBMONullError(int neID, int slotID, int vbID, int xcID) {
        String tipStr = "saveVBLinkToDB: The vbMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d,slotID:%d,vbID:%d,xcID:%d]", neID, slotID, vbID, xcID);
        e2eLogger.error(tipStr);
    }

    private static void logVblinkMOError(int neID, int slotID) {
        String tipStr = "delVBLinkFromDB: The vblinkMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        e2eLogger.error(tipStr);
    }

    private static void logVBMONullError(int neID, int slotID) {
        String tipStr = "delVBLinkFromDB: The vbMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        e2eLogger.error(tipStr);
    }

    private static void logSaveVBLinkToDBNullVBMOError(int neID, int slotID) {
        String tipStr = "saveVBLinkToDB: The vbMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        e2eLogger.error(tipStr);
    }
}

