/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink;

import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ENewError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.cache.TEVBMOCache;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink.TEE2ECreateVBLink;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink.TEE2EVBLinkUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLinkMOPO;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public final class TEE2EDelVBLink {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EDelVBLink() {
    }

    public static int delVBLink(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrList, List<QAsnEthXCInfo> delXCInfoList) {
        String FUNC_NAME = "TEE2EDelVBLink.delVBLink";
        TEEthE2ELog.logFuncBegin("TEE2EDelVBLink.delVBLink");
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        int retCode = 0;
        TEVBMOCache vbMOCache = new TEVBMOCache();
        vbMOCache.initMOFromDB(neID, slotID, vbID);
        TEEtherBridgeMOPO vbMO = vbMOCache.getMO(neID, slotID, vbID);
        if (null == vbMO) {
            TEE2EDelVBLink.logVBNotExistError(neID, slotID, vbID);
            retCode = 1090598181;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            TEEthE2ELog.logFuncEnd("TEE2EDelVBLink.delVBLink");
            return retCode;
        }
        if (0 != retCode) {
            TEE2EDelVBLink.logGetVBFromNEFail(neID, slotID, vbID);
            TEEthE2ELog.logFuncEnd("TEE2EDelVBLink.delVBLink");
            return retCode;
        }
        TEEtherVBLinkMOPO vblinkMO = TEE2EVBLinkUtil.getVBLinkFromCache(ethXCInfo, rspErrList, vbMOCache);
        if (null == vblinkMO) {
            TEE2EDelVBLink.logGetVBLinkFromNEFail(neID, slotID, vbID);
            return 1090598186;
        }
        ethXCInfo.xcIndex.xcID = vblinkMO.getIDOnNE();
        if (1 == ethXCInfo.xcAttr.isActive && 0 != (retCode = TEE2EDelVBLink.delVBLinkFromNESaveDB(ethXCInfo, rspErrList))) {
            TEE2EDelVBLink.logDelVBLinkFromNEFailError(neID, slotID, vbID);
            TEEthE2ELog.logFuncEnd("TEE2EDelVBLink.delVBLink");
            return retCode;
        }
        retCode = TEE2EDelVBLink.delVBLinkFromDB(ethXCInfo, rspErrList, vbMOCache);
        if (0 == retCode) {
            delXCInfoList.add(ethXCInfo);
        }
        TEEthE2ELog.logFuncEnd("TEE2EDelVBLink.delVBLink");
        return retCode;
    }

    protected static int delVBLinkFromNESaveDB(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrList) {
        String FUNC_NAME = "TEE2EDelVBLink.delVBLinkFromNESaveDB";
        TEEthE2ELog.logFuncBegin("TEE2EDelVBLink.delVBLinkFromNESaveDB");
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        int serviceType = ethXCInfo.xcIndex.xcType;
        int sfid = TEE2ECreateVBLink.getSfid(serviceType);
        TENEMgrInterface bean = TEE2ECreateVBLink.getCreateDelVBLinkBeanSaveDB(neID, serviceType, false);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, sfid);
        Datainterface inputData = TEE2ECreateVBLink.getCreateDelInput(ethXCInfo, serviceType, false);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TEE2EDelVBLink.logOutputDataNullError(neID, slotID, vbID);
            retCode = 1090646019;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            TEEthE2ELog.logFuncEnd("TEE2EDelVBLink.delVBLinkFromNESaveDB");
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EDelVBLink.logDelVBLinkFromNEFail(retCode, neID, slotID);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, rspErrList);
        }
        TEEthE2ELog.logFuncEnd("TEE2EDelVBLink.delVBLinkFromNESaveDB");
        return retCode;
    }

    protected static int delVBLinkFromDB(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrList, TEVBMOCache vbMOCache) {
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        TEEtherBridgeMOPO vbMO = vbMOCache.getMO(neID, slotID, vbID);
        if (null == vbMO) {
            TEE2EDelVBLink.logVBMONotExist(neID, slotID, vbID);
            retCode = 1090598181;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            return retCode;
        }
        boolean isFound = false;
        TEEtherVBLinkMOPO vbLinkMO = null;
        Set vbLinkMOSet = vbMO.getLinkList();
        Iterator iter = vbLinkMOSet.iterator();
        while (iter.hasNext()) {
            vbLinkMO = (TEEtherVBLinkMOPO)iter.next();
            if (!TEE2EVBLinkUtil.isMOEqualsAsn(vbLinkMO, ethXCInfo)) continue;
            iter.remove();
            vbMO.setPortNum(vbMO.getPortNum() - 1);
            isFound = true;
            break;
        }
        if (!isFound) {
            TEE2EDelVBLink.logVBLinkMONotExistError(neID, slotID, vbID);
            retCode = 1090598186;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            return retCode;
        }
        retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            TEE2EDelVBLink.logUpdateVBMOToDBError(retCode, neID, slotID, vbID);
            return retCode;
        }
        return 0;
    }

    private static void logUpdateVBMOToDBError(int retCode, int neID, int slotID, int vbID) {
        String tipStr = "delVBLinkFromDB: save vb mo to db fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, retCode:%d]", neID, slotID, vbID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logVBLinkMONotExistError(int neID, int slotID, int vbID) {
        String tipStr = "delVBLinkFromDB: The vblinkMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
    }

    private static void logVBMONotExist(int neID, int slotID, int vbID) {
        String tipStr = "delVBLinkFromDB: The vbMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
    }

    private static void logDelVBLinkFromNEFailError(int neID, int slotID, int vbID) {
        String tipStr = "delVBLink: del vb link to ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
    }

    private static void logGetVBLinkFromNEFail(int neID, int slotID, int vbID) {
        String tipStr = "delVBLink: Get vb link from ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
    }

    private static void logGetVBFromNEFail(int neID, int slotID, int vbID) {
        String tipStr = "delVBLink: Get vb from ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
    }

    private static void logVBNotExistError(int neID, int slotID, int vbID) {
        String tipStr = "delVBLink: The vbMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
    }

    private static void logDelVBLinkFromNEFail(int retCode, int neID, int slotID) {
        String tipStr = "delVBLinkFromNE: del vblink from ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logOutputDataNullError(int neID, int slotID, int vbID) {
        String tipStr = "delVBLinkFromNE: del vblink from ne fail! outputData is null!";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
    }
}

