/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink;

import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECreateError4VBLink;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ENewError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.cache.TEVBMOCache;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink.TEE2EVBLinkUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.TEEthInfUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid.TEObjTypeIDCreator;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBMgrWriteLogSuperBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TECfgPBMountPortBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TECfgVBMountPortBean;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TELinkIDGenerator;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.List;
import org.slf4j.Logger;

public final class TEE2ECreateVBLink {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final String C_AWARE = "5";

    private TEE2ECreateVBLink() {
    }

    public static int createVBLink(QAsnEthXCInfo asnVBLink, QAsnErrInfoList rspErrList, List<QAsnEthXCInfo> createdXCInfoList, TELinkIDGenerator linkIDGenerator) {
        int xcID;
        String FUNC_NAME = "TEE2ECreateVBLink.createVBLink";
        TEEthE2ELog.logFuncBegin("TEE2ECreateVBLink.createVBLink");
        int neID = asnVBLink.xcIndex.neID;
        int slotID = asnVBLink.xcIndex.slotID;
        int vbID = asnVBLink.xcAttr.vbID;
        int retCode = 0;
        TEVBMOCache vbMOCache = new TEVBMOCache();
        vbMOCache.initMOFromDB(neID, slotID, vbID);
        TEEtherBridgeMOPO vbMO = vbMOCache.getMO(neID, slotID, vbID);
        if (null == vbMO) {
            TEE2ECreateVBLink.logVBMONullError(neID, slotID, vbID);
            retCode = 1090598181;
            rspErrList.addAll(TEEthE2ECreateError4VBLink.createQAsnErrInfo(retCode, asnVBLink));
            TEEthE2ELog.logFuncEnd("TEE2ECreateVBLink.createVBLink");
            return retCode;
        }
        if (TEE2EVBLinkUtil.isVbLinkExist(asnVBLink, vbMO)) {
            retCode = 1090598185;
            rspErrList.addAll(TEEthE2ECreateError4VBLink.createQAsnErrInfo(retCode, asnVBLink));
            TEEthE2ELog.logFuncEnd("TEE2ECreateVBLink.createVBLink");
            return retCode;
        }
        if (linkIDGenerator.getGeneratedLinkIDList().size() >= 65535) {
            retCode = 1090650122;
            rspErrList.add((Object)TEEthE2ECreateError4VBLink.createQAsnErrInfo(40005, new int[]{neID, slotID, vbID}));
            return retCode;
        }
        asnVBLink.xcIndex.xcID = xcID = linkIDGenerator.generateLinkID();
        if (1 == asnVBLink.xcAttr.isActive && 0 != (retCode = TEE2ECreateVBLink.createVBLinkToNENoDB(asnVBLink, rspErrList, false))) {
            TEE2ECreateVBLink.logCreateVBLinkToNENoDBError(neID, slotID, vbID, xcID);
            rspErrList.addAll(TEEthE2ECreateError4VBLink.createQAsnErrInfo(retCode, asnVBLink));
            TEEthE2ELog.logFuncEnd("TEE2ECreateVBLink.createVBLink");
            return retCode;
        }
        retCode = TEE2EVBLinkUtil.saveVBLinkToDB(asnVBLink, rspErrList, vbMO);
        if (0 != retCode) {
            TEE2ECreateVBLink.logSaveVBLinkToDBError(neID, slotID, vbID, xcID);
            TEEthE2ELog.logFuncEnd("TEE2ECreateVBLink.createVBLink");
            return retCode;
        }
        createdXCInfoList.add(asnVBLink);
        TEEthE2ELog.logFuncEnd("TEE2ECreateVBLink.createVBLink");
        return retCode;
    }

    protected static int createVBLinkToNENoDB(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrList, boolean isNotify) {
        int xcID;
        String FUNC_NAME = "TEE2ECreateVBLink.createVBLinkToNENoDB";
        TEEthE2ELog.logFuncBegin("TEE2ECreateVBLink.createVBLinkToNENoDB");
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        int serviceType = ethXCInfo.xcIndex.xcType;
        TELinkIDGenerator linkIDGenerator = new TELinkIDGenerator();
        linkIDGenerator.init(neID, slotID);
        ethXCInfo.xcIndex.xcID = xcID = linkIDGenerator.generateLinkID();
        int sfid = TEE2ECreateVBLink.getSfid(serviceType);
        TENEMgrInterface bean = TEE2ECreateVBLink.getCreateDelVBLinkBeanSaveDB(neID, serviceType, isNotify);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, sfid);
        Datainterface inputData = TEE2ECreateVBLink.getCreateDelInput(ethXCInfo, serviceType, true);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            String tipStr = "createVBLinkToNESaveDB: create vblink to ne fail! outputData is null!";
            tipStr = tipStr + String.format("[neID:%d,slotID:%d,vbID:%d,xcID:%d,retCode:%d]", neID, slotID, vbID, xcID, retCode);
            e2eLogger.error(tipStr);
            retCode = 1090646019;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            TEEthE2ELog.logFuncEnd("TEE2ECreateVBLink.createVBLinkToNENoDB");
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            String tipStr = "createVBLinkToNESaveDB: create vblink to ne fail! ";
            tipStr = tipStr + String.format("[neID:%d,slotID:%d,vbID:%d,xcID:%d,retCode:%d]", neID, slotID, vbID, xcID, retCode);
            e2eLogger.error(tipStr);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, rspErrList);
        }
        TEEthE2ELog.logFuncEnd("TEE2ECreateVBLink.createVBLinkToNENoDB");
        return retCode;
    }

    protected static int getSfid(int serviceType) {
        int cmdID = 2116197;
        if (5 == serviceType) {
            cmdID = 2116197;
        } else if (6 == serviceType) {
            cmdID = 2555973;
        } else {
            e2eLogger.error("The serviceType is invalid, will use default! serviceType->" + serviceType);
        }
        return cmdID;
    }

    protected static TENEMgrInterface getCreateDelVBLinkBeanSaveDB(int neID, int sfid, boolean isNotify) {
        TENEMgrInterface bean = null;
        if (5 == sfid) {
            bean = TEE2ECreateVBLink.getCfgVBLinkBeanSaveDB(neID, isNotify);
        } else if (6 == sfid) {
            bean = TEE2ECreateVBLink.getCfgPBLinkBeanSaveDB(neID, isNotify);
        } else {
            e2eLogger.error("The serviceType is invalid, bean is null! serviceType->" + sfid);
        }
        return bean;
    }

    private static TENEMgrInterface getCfgVBLinkBeanSaveDB(int neID, final boolean isNotify) {
        TEVBMgrWriteLogSuperBean bean = null;
        int vbCodeVersion = TEE2EVBUtil.getVBCodeVersion(neID, 2116197);
        bean = 1 == vbCodeVersion ? new TECfgVBMountPortBean(){

            @Override
            protected boolean isSendNotify() {
                return isNotify;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }

            public boolean isNeedOperationlog() {
                return false;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TECfgVBMountPortBean(){

            @Override
            protected boolean isSendNotify() {
                return isNotify;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }

            public boolean isNeedOperationlog() {
                return false;
            }
        };
        return bean;
    }

    private static TENEMgrInterface getCfgPBLinkBeanSaveDB(int neID, boolean isNotify) {
        return new TECfgPBMountPortBean(){

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        };
    }

    protected static Datainterface getCreateDelInput(QAsnEthXCInfo ethXCInfo, int sfid, boolean isCreate) {
        Datainterface inputData = null;
        if (5 == sfid) {
            inputData = TEE2ECreateVBLink.getCfgVBLinkInput(ethXCInfo, isCreate);
        } else if (6 == sfid) {
            inputData = TEE2ECreateVBLink.getCfgPBLinkInput(ethXCInfo, isCreate);
        } else {
            e2eLogger.error("The serviceType is invalid, bean is null! serviceType->" + sfid);
        }
        return inputData;
    }

    private static Datainterface getCfgVBLinkInput(QAsnEthXCInfo ethXCInfo, boolean isCreate) {
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        int linkID = ethXCInfo.xcIndex.xcID;
        int srcPort = ethXCInfo.xcAttr.srcEndTP.portID;
        int srcPortType = ethXCInfo.xcAttr.srcEndTP.portType;
        int snkPort = ethXCInfo.xcAttr.snkEndTP.portID;
        int snkPortType = ethXCInfo.xcAttr.snkEndTP.portType;
        int webSrcPortID = -1;
        webSrcPortID = isCreate ? TEEthXCUtil.getWebLCTPortID(srcPort, srcPortType) : 0;
        int webSnkPortID = TEEthXCUtil.getWebLCTPortID(snkPort, snkPortType);
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotID", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("vbid", String.valueOf(vbID));
        rowparams.addParam(param);
        param = new Param("vbport", String.valueOf(webSnkPortID));
        rowparams.addParam(param);
        param = new Param("changeLinkFlg", "1");
        rowparams.addParam(param);
        param = new Param("linkid", String.valueOf(linkID));
        rowparams.addParam(param);
        param = new Param("portid", String.valueOf(webSrcPortID));
        rowparams.addParam(param);
        return inputData;
    }

    private static Datainterface getCfgPBLinkInput(QAsnEthXCInfo ethXCInfo, boolean isCreate) {
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        int linkID = ethXCInfo.xcIndex.xcID;
        int linkType = ethXCInfo.xcIndex.xcType;
        int srcPort = ethXCInfo.xcAttr.srcEndTP.portID;
        int srcPortType = ethXCInfo.xcAttr.srcEndTP.portType;
        int srcCVlan = ethXCInfo.xcAttr.srcEndTP.vlanID;
        int srcSVlan = ethXCInfo.xcAttr.srcEndTP.svlanID;
        int snkPort = ethXCInfo.xcAttr.snkEndTP.portID;
        int snkPortType = ethXCInfo.xcAttr.snkEndTP.portType;
        int direction = 0;
        int webSrcPortID = TEEthXCUtil.getWebLCTPortID(srcPort, srcPortType);
        int webSnkPortID = TEEthXCUtil.getWebLCTPortID(snkPort, snkPortType);
        int webSrcCVlan = TEEthXCUtil.getWebLCTVlanID(srcCVlan);
        int webSrcSVlan = TEEthXCUtil.getWebLCTVlanID(srcSVlan);
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotID", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("vbid", String.valueOf(vbID));
        rowparams.addParam(param);
        param = new Param("linkid", String.valueOf(linkID));
        rowparams.addParam(param);
        String peType = TEE2ECreateVBLink.queryPeType(neID, slotID, webSrcPortID, srcPortType);
        linkType = C_AWARE.equals(peType) ? (srcCVlan == -1 ? 0 : 1) : (srcSVlan != -1 ? 3 : 2);
        param = new Param("linktype", String.valueOf(linkType));
        rowparams.addParam(param);
        param = new Param("vbport", String.valueOf(webSnkPortID));
        rowparams.addParam(param);
        param = new Param("portid", String.valueOf(webSrcPortID));
        rowparams.addParam(param);
        param = new Param("porttype", "");
        rowparams.addParam(param);
        param = new Param("direction", String.valueOf(direction));
        rowparams.addParam(param);
        param = new Param("portenable", "");
        rowparams.addParam(param);
        param = new Param("portTag", "");
        rowparams.addParam(param);
        param = new Param("VLAN", "");
        rowparams.addParam(param);
        param = new Param("VLANPRIORITY", "");
        rowparams.addParam(param);
        param = new Param("ATTR_ETHOVERSDH_MAC_WORKMODE", "");
        rowparams.addParam(param);
        param = new Param("hubspoke", "");
        rowparams.addParam(param);
        param = new Param("cvlan", String.valueOf(webSrcCVlan));
        rowparams.addParam(param);
        param = new Param("svlan", String.valueOf(webSrcSVlan));
        rowparams.addParam(param);
        param = new Param("deleteold", "false");
        rowparams.addParam(param);
        return inputData;
    }

    private static String queryPeType(int neid, int slotid, int portid, int portType) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        int objTpID = 61603;
        String attrName = "ATTR_ETHOVERSDH_MAC_PE_TYPE";
        if (portType == 1) {
            objTpID = 61602;
            attrName = "ATTR_ETHOVERSDH_VCG_PE_TYPE";
        }
        key.setAttrID(TEEthInfUtil.getAttrID(attrName));
        Input input = new Input();
        Part part = new Part();
        part.setName("slotid");
        part.setValue(String.valueOf(slotid));
        input.addPart(part);
        part = new Part();
        part.setName("port");
        part.setValue(String.valueOf(portid));
        input.addPart(part);
        TEPartSource partSource = new TEPartSource(input);
        int[] objTypeID = TEObjTypeIDCreator.getInstance().createObjectID(neid, objTpID, partSource);
        key.setTEOBJECTID(objTypeID);
        return TEEthInfUtil.getAttrValueFromDB_NoLock(key);
    }

    private static void logCreateVBLinkToNENoDBError(int neID, int slotID, int vbID, int xcID) {
        String tipStr = "createVBLink: create vb link to ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, xcID:%d]", neID, slotID, vbID, xcID);
        e2eLogger.error(tipStr);
    }

    private static void logSaveVBLinkToDBError(int neID, int slotID, int vbID, int xcID) {
        String tipStr = "createVBLink: save vb link to db fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, xcID:%d]", neID, slotID, vbID, xcID);
        e2eLogger.error(tipStr);
    }

    private static void logVBMONullError(int neID, int slotID, int vbID) {
        String tipStr = "createVBLink: The vbMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
    }
}

