/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink;

import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ENewError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.cache.TEVBMOCache;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink.TEE2ECreateVBLink;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink.TEE2EDelVBLink;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink.TEE2EVBLinkUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLinkMOPO;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public final class TEE2EActiveVBLink {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EActiveVBLink() {
    }

    public static int activeVBLink(QAsnEthXCInfo xcInfo, QAsnErrInfoList rspErrList, List<QAsnEthXCInfo> newAsnXCList) {
        int linkID;
        String FUNC_NAME = "TEE2EActiveVBLink.activeVBLink";
        TEEthE2ELog.logFuncBegin("TEE2EActiveVBLink.activeVBLink");
        int retCode = 0;
        int neID = xcInfo.xcIndex.neID;
        int slotID = xcInfo.xcIndex.slotID;
        int vbID = xcInfo.xcAttr.vbID;
        TEVBMOCache vbMOCache = new TEVBMOCache();
        vbMOCache.initMOFromDB(neID, slotID, vbID);
        TEEtherVBLinkMOPO vbLinkMO = TEE2EVBLinkUtil.getVBLinkFromCache(xcInfo, rspErrList, vbMOCache);
        if (null == vbLinkMO) {
            retCode = 1090598186;
            TEE2EActiveVBLink.logVBLinkMONullError(neID, slotID);
            return retCode;
        }
        if (1 == vbLinkMO.getActiveState()) {
            retCode = 0;
            TEE2EActiveVBLink.logVBLinkAlreadyActiveError(neID, slotID, vbID, vbLinkMO);
            return retCode;
        }
        xcInfo.xcIndex.xcID = linkID = vbLinkMO.getIDOnNE();
        if (0 != retCode) {
            TEE2EActiveVBLink.logGetVBLinkFromNEFailError(neID, slotID);
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.activeVBLink");
            return retCode;
        }
        retCode = TEE2EActiveVBLink.activeVBLinkToNENoDB(xcInfo, rspErrList, false);
        if (0 == retCode) {
            retCode = TEE2EActiveVBLink.activeVBLinkToDB(neID, slotID, vbID, linkID, 1, vbMOCache);
            if (0 != retCode) {
                rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            } else {
                newAsnXCList.add(xcInfo);
            }
        }
        TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.activeVBLink");
        return retCode;
    }

    public static int unActiveVBLink(QAsnEthXCInfo xcInfo, QAsnErrInfoList rspErrList) {
        int linkID;
        String FUNC_NAME = "TEE2EActiveVBLink.unActiveVBLink";
        TEEthE2ELog.logFuncBegin("TEE2EActiveVBLink.unActiveVBLink");
        int retCode = 0;
        int neID = xcInfo.xcIndex.neID;
        int slotID = xcInfo.xcIndex.slotID;
        int vbID = xcInfo.xcAttr.vbID;
        int xcID = xcInfo.xcIndex.xcID;
        TEVBMOCache vbMOCache = new TEVBMOCache();
        vbMOCache.initMOFromDB(neID, slotID, vbID);
        TEEtherVBLinkMOPO vbLinkMO = TEE2EVBLinkUtil.getVBLinkFromCache(xcInfo, rspErrList, vbMOCache);
        if (null == vbLinkMO) {
            retCode = 0;
            TEE2EActiveVBLink.logVBLinkMONullError(neID, slotID, vbID, xcID);
            return retCode;
        }
        if (0 == vbLinkMO.getActiveState()) {
            retCode = 0;
            TEE2EActiveVBLink.logAlreadyUnActiveError(neID, slotID, vbID, xcID);
            return retCode;
        }
        xcInfo.xcIndex.xcID = linkID = vbLinkMO.getIDOnNE();
        if (0 != retCode) {
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID, xcID}));
            return retCode;
        }
        retCode = TEE2EDelVBLink.delVBLinkFromNESaveDB(xcInfo, rspErrList);
        if (0 == retCode && 0 != (retCode = TEE2EActiveVBLink.activeVBLinkToDB(neID, slotID, vbID, linkID, 0, vbMOCache))) {
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID, xcID}));
        }
        TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.unActiveVBLink");
        return retCode;
    }

    private static int activeVBLinkToNENoDB(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrList, boolean isNotify) {
        String FUNC_NAME = "TEE2EActiveVBLink.activeVBLinkToNENoDB";
        TEEthE2ELog.logFuncBegin("TEE2EActiveVBLink.activeVBLinkToNENoDB");
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        int xcID = ethXCInfo.xcIndex.xcID;
        int serviceType = ethXCInfo.xcIndex.xcType;
        int sfid = TEE2ECreateVBLink.getSfid(serviceType);
        TENEMgrInterface bean = TEE2ECreateVBLink.getCreateDelVBLinkBeanSaveDB(neID, serviceType, isNotify);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, sfid);
        Datainterface inputData = TEE2ECreateVBLink.getCreateDelInput(ethXCInfo, serviceType, true);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TEE2EActiveVBLink.logOutputDataError(retCode, neID, slotID, vbID, xcID);
            retCode = 1090646019;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID, xcID}));
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.activeVBLinkToNENoDB");
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EActiveVBLink.logBeanError(retCode, neID, slotID, vbID, xcID);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, rspErrList);
        }
        TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.activeVBLinkToNENoDB");
        return retCode;
    }

    protected static int unactiveVBLinkFromNENoDB(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrList) {
        String FUNC_NAME = "TEE2EActiveVBLink.delVBLinkFromNESaveDB";
        TEEthE2ELog.logFuncBegin("TEE2EActiveVBLink.delVBLinkFromNESaveDB");
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int vbID = ethXCInfo.xcAttr.vbID;
        int serviceType = ethXCInfo.xcIndex.xcType;
        int sfid = TEE2ECreateVBLink.getSfid(serviceType);
        TENEMgrInterface bean = TEE2ECreateVBLink.getCreateDelVBLinkBeanSaveDB(neID, serviceType, false);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, sfid);
        Datainterface inputData = TEE2ECreateVBLink.getCreateDelInput(ethXCInfo, serviceType, false);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        if (null == outputData) {
            TEE2EActiveVBLink.logOutputDataNullError(neID, slotID);
            retCode = 1090646019;
            rspErrList.add((Object)TEEthE2ENewError.createQAsnErrInfo(retCode, new int[]{neID, slotID, vbID}));
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.delVBLinkFromNESaveDB");
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EActiveVBLink.logDelVBLinkFromNEError(retCode, neID, slotID);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, rspErrList);
        }
        TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.delVBLinkFromNESaveDB");
        return retCode;
    }

    private static int activeVBLinkToDB(int neID, int slotID, int vbID, int vbLinkID, int activeState, TEVBMOCache vbMOCache) {
        String FUNC_NAME = "TEE2EActiveVBLink.activeVBLinkToDB";
        TEEthE2ELog.logFuncBegin("TEE2EActiveVBLink.activeVBLinkToDB");
        int retCode = 0;
        TEEtherBridgeMOPO vbMO = vbMOCache.getMO(neID, slotID, vbID);
        if (null == vbMO) {
            TEE2EActiveVBLink.logVBMONullError(neID, slotID, vbID, vbLinkID);
            retCode = 1090598181;
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.activeVBLinkToDB");
            return retCode;
        }
        boolean isFound = false;
        TEEtherVBLinkMOPO vbLinkMO2 = null;
        Set vbLinkMOSet = vbMO.getLinkList();
        for (TEEtherVBLinkMOPO vbLinkMO2 : vbLinkMOSet) {
            if (vbLinkMO2.getIDOnNE() != vbLinkID) continue;
            vbLinkMO2.setActiveState((short)activeState);
            isFound = true;
            break;
        }
        if (!isFound) {
            TEE2EActiveVBLink.logVBLinkNotExistError(neID, slotID, vbID, vbLinkID);
            retCode = 1090598186;
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.activeVBLinkToDB");
            return retCode;
        }
        retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            TEE2EActiveVBLink.logActiveVBLinkToDBError(neID, slotID, vbID, vbLinkID);
            retCode = 1090598186;
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBLink.activeVBLinkToDB");
            return retCode;
        }
        return retCode;
    }

    private static void logActiveVBLinkToDBError(int neID, int slotID, int vbID, int vbLinkID) {
        String tipStr = "activeVBLinkToDB: save vb mo to db fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vbLinkID:%d]", neID, slotID, vbID, vbLinkID);
        e2eLogger.error(tipStr);
    }

    private static void logVBLinkNotExistError(int neID, int slotID, int vbID, int vbLinkID) {
        String tipStr = "activeVBLinkToDB: The vblinkMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vbLinkID:%d]", neID, slotID, vbID, vbLinkID);
        e2eLogger.error(tipStr);
    }

    private static void logVBMONullError(int neID, int slotID, int vbID, int vbLinkID) {
        String tipStr = "activeVBLinkToDB: The vbMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vbLinkID:%d]", neID, slotID, vbID, vbLinkID);
        e2eLogger.error(tipStr);
    }

    private static void logBeanError(int retCode, int neID, int slotID, int vbID, int xcID) {
        String tipStr = "activeVBLinkToNENoDB: create vblink to ne fail! ";
        tipStr = tipStr + String.format("[neID:%d,slotID:%d,vbID:%d,xcID:%d,retCode:%d]", neID, slotID, vbID, xcID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logOutputDataError(int retCode, int neID, int slotID, int vbID, int xcID) {
        String tipStr = "activeVBLinkToNENoDB: create vblink to ne fail! outputData is null!";
        tipStr = tipStr + String.format("[neID:%d,slotID:%d,vbID:%d,xcID:%d,retCode:%d]", neID, slotID, vbID, xcID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logGetVBLinkFromNEFailError(int neID, int slotID) {
        String tipStr = "activeVBLink: Get vb from ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        e2eLogger.error(tipStr);
    }

    private static void logVBLinkAlreadyActiveError(int neID, int slotID, int vbID, TEEtherVBLinkMOPO vbLinkMO) {
        int xcID = vbLinkMO.getIDOnNE();
        String tipStr = "activeVBLink: not execute because the link is active! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, xcID:%d]", neID, slotID, vbID, xcID);
        e2eLogger.error(tipStr);
    }

    private static void logVBLinkMONullError(int neID, int slotID) {
        String tipStr = "activeVBLink: Get vb link from ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        e2eLogger.error(tipStr);
    }

    private static void logAlreadyUnActiveError(int neID, int slotID, int vbID, int xcID) {
        String tipStr = "unActiveVBLink: not execute because the link is unactive! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, xcID:%d]", neID, slotID, vbID, xcID);
        e2eLogger.error(tipStr);
    }

    private static void logVBLinkMONullError(int neID, int slotID, int vbID, int xcID) {
        String tipStr = "unActiveVBLink: Get vb link from ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, xcID:%d]", neID, slotID, vbID, xcID);
        e2eLogger.error(tipStr);
    }

    private static void logDelVBLinkFromNEError(int retCode, int neID, int slotID) {
        String tipStr = "delVBLinkFromNE: del vblink from ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
        e2eLogger.error(tipStr);
    }

    private static void logOutputDataNullError(int neID, int slotID) {
        String tipStr = "delVBLinkFromNE: del vblink from ne fail! outputData is null!";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        e2eLogger.error(tipStr);
    }
}

