/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetVlanMaxMacReq;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetVlanMaxMacRsp;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVlanMacContent;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnfdbVlanErr;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnfdbVlanErrList;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TESetVlanMaxMacHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        AsnSetVlanMaxMacReq req = (AsnSetVlanMaxMacReq)fReq;
        AsnSetVlanMaxMacRsp rsp = (AsnSetVlanMaxMacRsp)fRsp;
        if (req == null || req.vlanMacList.isEmpty()) {
            TEE2EVBUtil.fillAsnSingleReturn(0, rsp.result);
            e2elogger.info("AsnSetVlanMaxMacHand req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int neID = req.getNEID();
        Datainterface inputData = this.createInputData(req);
        Datainterface outputData = TEE2EVBUtil.performSubFunc(neID, 2143015, inputData);
        this.parseOutputData(neID, outputData, req, rsp);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected Datainterface createInputData(AsnSetVlanMaxMacReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        String neID = String.valueOf(req.getNEID());
        String slotid = String.valueOf(req.slotid);
        int len = req.vlanMacList.size();
        for (int i = 0; i < len; ++i) {
            AsnVlanMacContent macContent = (AsnVlanMacContent)req.vlanMacList.get(i);
            rowparams = new RowParams();
            rowparams.addParam("neid", neID);
            rowparams.addParam("slotid", slotid);
            rowparams.addParam("vbid", String.valueOf(macContent.vbID));
            rowparams.addParam("vlanid", String.valueOf(macContent.vlanID));
            rowparams.addParam("maccapacity", new String(macContent.maxMac));
            rowparams.addParam("isLogFlag", "0");
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }

    protected void parseOutputData(int neID, Datainterface outputData, AsnSetVlanMaxMacReq req, AsnSetVlanMaxMacRsp rsp) {
        rsp.seterrlist = new AsnfdbVlanErrList();
        if (outputData == null) {
            TEE2EVBUtil.fillAsnSingleReturn(1090593060, rsp.result);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            TEE2EVBUtil.fillAsnSingleReturn(errorCode, rsp.result);
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        if (bussiness != null) {
            int len = bussiness.getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowParams row = bussiness.getRowParams(i);
                if (row.getRowErrorsCount() == 0) continue;
                int retCode = Integer.parseInt(row.getRowErrors(0).getErrorMessage().getErrorcode());
                int vlanID = TEEthQosUtil.getIntParamValue(row.getRowErrors(0).getParam("vlanid"));
                rsp.seterrlist.add((Object)TESetVlanMaxMacHandler.getAsnfdbVlanErr(vlanID, retCode));
            }
        }
        if (rsp.seterrlist.isEmpty()) {
            TEE2EVBUtil.fillAsnSingleReturn(0, rsp.result);
        } else if (rsp.seterrlist.size() >= req.vlanMacList.size()) {
            TEE2EVBUtil.fillAsnSingleReturn(1090650122, rsp.result);
        } else {
            TEE2EVBUtil.fillAsnSingleReturn(1090650121, rsp.result);
        }
    }

    private static AsnfdbVlanErr getAsnfdbVlanErr(int vlanID, int errCode) {
        AsnfdbVlanErr errInfo = new AsnfdbVlanErr();
        TEE2EVBUtil.fillAsnSingleReturn(errCode, errInfo.setresult);
        errInfo.vlanID = BigInteger.valueOf(vlanID);
        return errInfo;
    }
}

