/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetVBLPAttrReq;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetVBLPAttrRsp;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVBLP;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVBLPAttr;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVBLPList;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TESetVBLPAttrHandler
extends TEWNEMgrHandler {
    public static final int TIME_OUT = 20;
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        int slotid;
        AsnSetVBLPAttrReq req = (AsnSetVBLPAttrReq)fReq;
        AsnSetVBLPAttrRsp rsp = (AsnSetVBLPAttrRsp)fRsp;
        if (req.vbLPList == null || req.vbLPList.isEmpty()) {
            rsp.result.isSuccess = true;
            rsp.result.retCode = BigInteger.valueOf(0L);
            e2elogger.info("AsnSetVBLPAttrReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int neid = req.neID.intValue();
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotid = req.slotID.intValue());
        if (errInfo != null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(errInfo.errCode);
            return 0;
        }
        ArrayList<Operation> operList = new ArrayList<Operation>();
        int len = req.vbLPList.size();
        for (int i = 0; i < len; ++i) {
            AsnVBLP vblp = (AsnVBLP)req.vbLPList.get(i);
            List<Operation> operListTmp = this.getApplyOperaion(neid, slotid, vblp);
            if (operListTmp == null || operListTmp.isEmpty()) continue;
            operList.addAll(operListTmp);
        }
        rsp.vbLPList = req.vbLPList;
        rsp.result.isSuccess = true;
        rsp.result.retCode = BigInteger.valueOf(0L);
        if (!operList.isEmpty()) {
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operList, 20);
            if (result.retCode == 0) {
                this.handlerOpertionList(operList, rsp);
            } else {
                rsp.result.isSuccess = false;
                rsp.result.retCode = BigInteger.valueOf(result.retCode);
            }
        }
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    public void handlerOpertionList(List<Operation> operList, AsnSetVBLPAttrRsp rsp) {
        int len = operList.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = operList.get(i);
            AsnVBLP vbLp = this.getAsnVBLPFromList(rsp.vbLPList, this.getPartValue(oper.getInput().getPart("vbid")));
            if (vbLp == null || oper.getOutputCount() <= 0) continue;
            int vbport = this.getPartValue(oper.getInput().getPart("vbport"));
            if (oper.getOutput(0).getFault(0).getCode() == null || oper.getOutput(0).getFault(0).getCode().isEmpty()) continue;
            int errorCode = Integer.parseInt(oper.getOutput(0).getFault(0).getCode());
            if (errorCode != 0) {
                rsp.result.isSuccess = false;
                rsp.result.retCode = BigInteger.valueOf(1090650122L);
            }
            this.setAsnVBLPAttrError(vbLp, vbport, errorCode);
        }
    }

    private AsnVBLP getAsnVBLPFromList(AsnVBLPList vbLPList, int vbid) {
        AsnVBLP asnvb = null;
        int len = vbLPList.size();
        for (int i = 0; i < len; ++i) {
            AsnVBLP asnvbTmp = (AsnVBLP)vbLPList.get(i);
            if (asnvbTmp.brgID.intValue() != vbid) continue;
            asnvb = asnvbTmp;
            break;
        }
        return asnvb;
    }

    private void setAsnVBLPAttrError(AsnVBLP vbLP, int vbport, int errorCode) {
        int len = vbLP.vbLPAttr.size();
        for (int i = 0; i < len; ++i) {
            AsnVBLPAttr vblpattr = (AsnVBLPAttr)vbLP.vbLPAttr.get(i);
            if (vblpattr.vbLPID.intValue() != vbport) continue;
            vblpattr.result.isSuccess = errorCode == 0;
            vblpattr.result.retCode = BigInteger.valueOf(errorCode);
        }
    }

    public List<Operation> getApplyOperaion(int neid, int slotid, AsnVBLP vblp) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_SET_VBLP_HUBSPOKEN");
        ArrayList<Operation> operList = new ArrayList<Operation>();
        if (oper != null) {
            oper.getInput().setPartValue("slotid", String.valueOf(slotid));
            oper.getInput().setPartValue("vbid", vblp.brgID.toString());
            int len = vblp.vbLPAttr.size();
            for (int i = 0; i < len; ++i) {
                AsnVBLPAttr vblpattr = (AsnVBLPAttr)vblp.vbLPAttr.get(i);
                oper.getInput().setPartValue("vbport", vblpattr.vbLPID.toString());
                oper.getInput().setPartValue("hubspoke", vblpattr.hubSpoken.toString());
                operList.add((Operation)oper.clone());
            }
        }
        return operList;
    }

    public int getPartValue(Part part) {
        int result = -1;
        if (part != null && part.getValue() != null && !part.getValue().isEmpty()) {
            result = Integer.parseInt(part.getValue());
        }
        return result;
    }
}

