/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnMacContent;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetMacContentReq;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetMacContentRsp;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TESetPlaMacConHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        AsnSetMacContentReq req = (AsnSetMacContentReq)fReq;
        AsnSetMacContentRsp rsp = (AsnSetMacContentRsp)fRsp;
        if (req == null || req.macConList.isEmpty()) {
            rsp.result.retCode = BigInteger.valueOf(0L);
            e2elogger.info("AsnSetMacContentReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int neID = req.neID.intValue();
        Datainterface inputData = this.createInputData(req);
        Datainterface outputData = TEE2EVBUtil.performSubFunc(neID, 2105525, inputData);
        this.parseOutputData(neID, outputData, req, rsp);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected Datainterface createInputData(AsnSetMacContentReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        int neID = req.neID.intValue();
        int slotID = req.slotID.intValue();
        int len = req.macConList.size();
        for (int i = 0; i < len; ++i) {
            AsnMacContent macContent = (AsnMacContent)req.macConList.get(i);
            rowparams = new RowParams();
            int vbID = macContent.brgID.intValue();
            rowparams.addParam("neid", String.valueOf(neID));
            rowparams.addParam("slotid", String.valueOf(slotID));
            rowparams.addParam("vbid", String.valueOf(vbID));
            rowparams.addParam("vbport", String.valueOf(macContent.port.intValue() + 28672));
            rowparams.addParam("maccapacity", String.valueOf(macContent.macCont));
            rowparams.addParam("isLogFlag", "0");
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }

    protected void parseOutputData(int neID, Datainterface outputData, AsnSetMacContentReq req, AsnSetMacContentRsp rsp) {
        if (outputData == null) {
            TEE2EVBUtil.fillAsnSingleReturn(1090593060, rsp.result);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            TEE2EVBUtil.fillAsnSingleReturn(errorCode, rsp.result);
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        AsnMacContent macContent = null;
        int errorRowSize = 0;
        if (bussiness != null) {
            int len = bussiness.getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowParams row = bussiness.getRowParams(i);
                macContent = new AsnMacContent();
                int vbID = 0;
                int retCode = 0;
                long vbport = -1L;
                long macCont = -1L;
                if (row.getRowErrorsCount() != 0) {
                    int errLen = row.getRowErrorsCount();
                    for (int j = 0; j < errLen; ++j) {
                        ++errorRowSize;
                        retCode = Integer.parseInt(row.getRowErrors(j).getErrorMessage().getErrorcode());
                        vbID = TEEthQosUtil.getIntParamValue(row.getRowErrors(j).getParam("vbid"));
                        vbport = TESetPlaMacConHandler.getLongParamValue(row.getRowErrors(j).getParam("vbport"));
                        macCont = TESetPlaMacConHandler.getLongParamValue(row.getRowErrors(j).getParam("maccapacity"));
                        macContent.brgID = BigInteger.valueOf(vbID);
                        macContent.port = BigInteger.valueOf(vbport);
                        macContent.macCont = BigInteger.valueOf(macCont);
                        TEE2EVBUtil.fillAsnSingleReturn(retCode, macContent.result);
                        rsp.macConList.add((Object)macContent);
                    }
                    continue;
                }
                retCode = 0;
                vbID = TEEthQosUtil.getIntParamValue(row.getParam("vbid"));
                vbport = TESetPlaMacConHandler.getLongParamValue(row.getParam("vbport"));
                macCont = TESetPlaMacConHandler.getLongParamValue(row.getParam("maccapacity"));
                macContent.brgID = BigInteger.valueOf(vbID);
                macContent.port = BigInteger.valueOf(vbport + 28672L);
                macContent.macCont = BigInteger.valueOf(macCont);
                TEE2EVBUtil.fillAsnSingleReturn(retCode, macContent.result);
                rsp.macConList.add((Object)macContent);
            }
        }
        if (errorRowSize >= req.macConList.size()) {
            TEE2EVBUtil.fillAsnSingleReturn(1090650122, rsp.result);
        } else if (errorRowSize > 0 && errorRowSize < req.macConList.size()) {
            TEE2EVBUtil.fillAsnSingleReturn(1090650121, rsp.result);
        } else {
            TEE2EVBUtil.fillAsnSingleReturn(0, rsp.result);
        }
    }

    public static long getLongParamValue(Param param) {
        long result = -1L;
        if (null != param && null != param.getValue() && !param.getValue().isEmpty() && !param.getValue().equals("-")) {
            result = Long.parseLong(param.getValue());
        }
        return result;
    }
}

