/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetEtherMACDisblReq;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetEtherMACDisblRsp;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVBUnit;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVBUnitList;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVLANUnit;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import java.math.BigInteger;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TESetEtherMACDisblHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        int slotid;
        AsnSetEtherMACDisblReq req = (AsnSetEtherMACDisblReq)fReq;
        AsnSetEtherMACDisblRsp rsp = (AsnSetEtherMACDisblRsp)fRsp;
        if (req.vbUnitList == null || req.vbUnitList.isEmpty()) {
            rsp.result.retCode = BigInteger.valueOf(0L);
            e2elogger.info("AsnSetEtherMACDisblReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int neid = req.neID.intValue();
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotid = req.slotID.intValue());
        if (errInfo != null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(errInfo.errCode);
            return 0;
        }
        Datainterface inputData = this.createInputData(neid, slotid, req.vbUnitList);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neid, 2139968, inputData);
        rsp.result.isSuccess = true;
        rsp.result.retCode = BigInteger.valueOf(0L);
        this.parseOutputData(neid, slotid, outputData, rsp);
        if (!rsp.vbUnitList.isEmpty()) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(1090650121L);
        }
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected void parseOutputData(int neID, int slotID, Datainterface outputData, AsnSetEtherMACDisblRsp rsp) {
        if (outputData == null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(1090593060L);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(errorCode);
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        if (bussiness == null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(1090593060L);
            return;
        }
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String error;
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() == 0 || (error = row.getRowErrors(0).getErrorMessage().getErrorcode()) == null || error.isEmpty()) continue;
            int vbid = TEEthQosUtil.getIntParamValue(row.getRowErrors(0).getParam("vbid"));
            AsnVBUnit vbUnit = this.getAsnVBUnitFromList(rsp.vbUnitList, vbid);
            AsnVLANUnit vlanUnit = new AsnVLANUnit();
            vlanUnit.vlanID = BigInteger.valueOf(TEEthQosUtil.getIntParamValue(row.getRowErrors(0).getParam("vlanid")));
            vlanUnit.disblType = BigInteger.valueOf(TEEthQosUtil.getIntParamValue(row.getRowErrors(0).getParam("forbidtype")));
            Param macParam = row.getRowErrors(0).getParam("macaddr");
            if (macParam != null && macParam.getValue() != null && !macParam.getValue().isEmpty()) {
                vlanUnit.macAdd.addAll(TEE2EVBUtil.convertToMacAddrList(macParam.getValue()));
            }
            vlanUnit.errReturn.isSuccess = false;
            vlanUnit.errReturn.retCode = BigInteger.valueOf(Integer.parseInt(error));
            vbUnit.vlanUnitList.add((Object)vlanUnit);
        }
    }

    private AsnVBUnit getAsnVBUnitFromList(AsnVBUnitList strctSglRst, int vbid) {
        AsnVBUnit unit = null;
        int len = strctSglRst.size();
        for (int i = 0; i < len; ++i) {
            AsnVBUnit unitTmp = (AsnVBUnit)strctSglRst.get(i);
            if (unitTmp.vbID.intValue() != vbid) continue;
            unit = unitTmp;
            break;
        }
        if (unit == null) {
            unit = new AsnVBUnit();
            unit.vbID = BigInteger.valueOf(vbid);
            strctSglRst.add((Object)unit);
        }
        return unit;
    }

    protected Datainterface createInputData(int neid, int slotid, AsnVBUnitList vbUnitList) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        int len = vbUnitList.size();
        for (int i = 0; i < len; ++i) {
            AsnVBUnit vbUnit = (AsnVBUnit)vbUnitList.get(i);
            int lenj = vbUnit.vlanUnitList.size();
            for (int j = 0; j < lenj; ++j) {
                AsnVLANUnit vlanUnit = (AsnVLANUnit)vbUnit.vlanUnitList.get(j);
                if (vlanUnit.macAdd.isEmpty()) continue;
                RowParams rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("slotid", String.valueOf(slotid));
                rowparams.addParam("board", "");
                rowparams.addParam("vbid", String.valueOf(vbUnit.vbID.intValue()));
                rowparams.addParam("vlanid", String.valueOf(vlanUnit.vlanID.intValue()));
                rowparams.addParam("forbidtype", String.valueOf(vlanUnit.disblType.intValue()));
                rowparams.addParam("macaddr", TEE2EVBUtil.convertToNeMacAddrStr((List<BigInteger>)vlanUnit.macAdd));
                rowparams.addParam("isLogFlag", "0");
                bussiness.addRowParams(rowparams);
            }
        }
        return inputData;
    }
}

