/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnGetVlanMaxMacReq;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnGetVlanMaxMacRsp;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVlanMacContent;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetVlanMaxMacHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        AsnGetVlanMaxMacReq req = (AsnGetVlanMaxMacReq)fReq;
        AsnGetVlanMaxMacRsp rsp = (AsnGetVlanMaxMacRsp)fRsp;
        if (req == null) {
            rsp.result.retCode = BigInteger.valueOf(0L);
            e2elogger.info("AsnGetVlanMaxMacReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int neID = req.getNEID();
        Datainterface inputData = this.createInputData(req);
        Datainterface outputData = TEE2EVBUtil.performSubFunc(neID, 2143014, inputData);
        this.parseOutputData(neID, outputData, rsp);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected Datainterface createInputData(AsnGetVlanMaxMacReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        rowparams.addParam("neid", String.valueOf(req.getNEID()));
        rowparams.addParam("slotid", String.valueOf(req.slotid));
        rowparams.addParam("vbid", String.valueOf(req.vbID));
        rowparams.addParam("vlanid", "-1");
        rowparams.addParam("isLogFlag", "0");
        return inputData;
    }

    protected void parseOutputData(int neID, Datainterface outputData, AsnGetVlanMaxMacRsp rsp) {
        int retcode = TEE2EVBUtil.fillAsnSingleReturnResult(outputData, rsp.result);
        if (2 == retcode) {
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        int vbID = -1;
        int vlanID = -1;
        AsnVlanMacContent macContent = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            macContent = new AsnVlanMacContent();
            vbID = TEEthQosUtil.getIntParamValue(row.getParam("vbid"));
            vlanID = TEEthQosUtil.getIntParamValue(row.getParam("vlanid"));
            String maccapacity = row.getParam("maccapacity").getValue();
            String macrealcapacity = row.getParam("macrealcapacity").getValue();
            macContent.vbID = BigInteger.valueOf(vbID);
            macContent.vlanID = BigInteger.valueOf(vlanID);
            macContent.maxMac = maccapacity.getBytes();
            macContent.realMaxMac = macrealcapacity.getBytes();
            rsp.vlanMacList.add((Object)macContent);
        }
    }
}

