/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnMacContent;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnQueryPlaMacConReq;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnQueryPlaMacConRsp;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEParseEthLanConfFile;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetPlaMacConHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        AsnQueryPlaMacConReq req = (AsnQueryPlaMacConReq)fReq;
        AsnQueryPlaMacConRsp rsp = (AsnQueryPlaMacConRsp)fRsp;
        if (req == null) {
            rsp.result.retCode = BigInteger.valueOf(0L);
            e2elogger.info("AsnQueryPlaMacConReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int neID = req.neID.intValue();
        Datainterface inputData = this.createInputData(req);
        Datainterface outputData = TEE2EVBUtil.performSubFunc(neID, 2105526, inputData);
        this.parseOutputData(neID, outputData, rsp);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected Datainterface createInputData(AsnQueryPlaMacConReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        int neID = req.neID.intValue();
        int slotID = req.slotID.intValue();
        int portNum = this.getLPCount(neID, slotID);
        int len = req.macConList.size();
        for (int i = 0; i < len; ++i) {
            AsnMacContent macContent = (AsnMacContent)req.macConList.get(i);
            int vbID = macContent.brgID.intValue();
            for (int j = 0; j < portNum; ++j) {
                rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(neID));
                rowparams.addParam("slotid", String.valueOf(slotID));
                rowparams.addParam("vbid", String.valueOf(vbID));
                rowparams.addParam("vbport", String.valueOf(28673 + j));
                rowparams.addParam("isLogFlag", "0");
                bussiness.addRowParams(rowparams);
            }
        }
        return inputData;
    }

    public int getLPCount(int neid, int slotid) {
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TEParseEthLanConfFile confFileObj = TEParseEthLanConfFile.getInstance();
        int neType = cfgDataMgr.getNE(neid).getNEType();
        int boardType = cfgDataMgr.getBoardType(neid, slotid);
        int subrackType = TEBoardUtil.getSubrackType((int)neid, (int)neType, (int)slotid);
        int lpCount = 64;
        String lpCountStr = confFileObj.getNodeAttrValue(neid, String.valueOf(subrackType), String.valueOf(boardType), "maxNumOfVBLP");
        if (lpCountStr != null && !lpCountStr.isEmpty()) {
            lpCount = Integer.parseInt(lpCountStr);
        }
        return lpCount;
    }

    protected void parseOutputData(int neID, Datainterface outputData, AsnQueryPlaMacConRsp rsp) {
        if (outputData == null) {
            TEE2EVBUtil.fillAsnSingleReturn(1090593060, rsp.result);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            TEE2EVBUtil.fillAsnSingleReturn(errorCode, rsp.result);
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        int vbID = -1;
        long vbport = -1L;
        AsnMacContent macContent = null;
        if (bussiness != null) {
            int len = bussiness.getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowParams row = bussiness.getRowParams(i);
                if (row.getRowErrorsCount() != 0) continue;
                macContent = new AsnMacContent();
                vbID = TEEthQosUtil.getIntParamValue(row.getParam("vbid"));
                vbport = TEEthQosUtil.getIntParamValue(row.getParam("vbport"));
                long maccapacity = Long.valueOf(row.getParam("maccapacity").getValue());
                macContent.brgID = BigInteger.valueOf(vbID);
                macContent.port = BigInteger.valueOf(vbport);
                macContent.macCont = BigInteger.valueOf(maccapacity);
                TEE2EVBUtil.fillAsnSingleReturn(0, macContent.result);
                rsp.macConList.add((Object)macContent);
            }
        }
        TEE2EVBUtil.fillAsnSingleReturn(0, rsp.result);
    }
}

