/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnGetEtherMACDisblReq;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnGetEtherMACDisblRsp;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVBUnit;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVBUnitList;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnVLANUnit;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetEtherMACDisblHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        AsnGetEtherMACDisblReq req = (AsnGetEtherMACDisblReq)fReq;
        AsnGetEtherMACDisblRsp rsp = (AsnGetEtherMACDisblRsp)fRsp;
        int neID = req.neID.intValue();
        int slotID = req.slotID.intValue();
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neID, slotID);
        if (errInfo != null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(errInfo.errCode);
            return 0;
        }
        Datainterface inputData = this.createQueryInputData(neID, slotID, req.vbid.intValue());
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neID, 2139966, inputData);
        rsp.result.isSuccess = true;
        rsp.result.retCode = BigInteger.valueOf(0L);
        this.parseOutputData(neID, slotID, outputData, rsp);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected void parseOutputData(int neID, int slotID, Datainterface outputData, AsnGetEtherMACDisblRsp rsp) {
        if (outputData == null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(1090593060L);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(errorCode);
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        if (bussiness == null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(1090593060L);
            return;
        }
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            int vbid = TEEthQosUtil.getIntParamValue(row.getParam("vbid"));
            AsnVBUnit vbUnit = this.getAsnVBUnitFromList(rsp.strctSglRst, vbid);
            AsnVLANUnit vlanunit = new AsnVLANUnit();
            vlanunit.vlanID = BigInteger.valueOf(TEEthQosUtil.getIntParamValue(row.getParam("vlanid")));
            vlanunit.disblType = BigInteger.valueOf(TEEthQosUtil.getIntParamValue(row.getParam("forbidtype")));
            String macAddress = row.getParam("macaddr").getValue();
            if (macAddress != null && !macAddress.isEmpty()) {
                vlanunit.macAdd.addAll(TEE2EVBUtil.convertToMacAddrList(macAddress));
            }
            vlanunit.errReturn.isSuccess = true;
            vlanunit.errReturn.retCode = BigInteger.valueOf(0L);
            vbUnit.vlanUnitList.add((Object)vlanunit);
        }
    }

    private AsnVBUnit getAsnVBUnitFromList(AsnVBUnitList strctSglRst, int vbid) {
        AsnVBUnit unit = null;
        int len = strctSglRst.size();
        for (int i = 0; i < len; ++i) {
            AsnVBUnit unitTmp = (AsnVBUnit)strctSglRst.get(i);
            if (unitTmp.vbID.intValue() != vbid) continue;
            unit = unitTmp;
            break;
        }
        if (unit == null) {
            unit = new AsnVBUnit();
            unit.vbID = BigInteger.valueOf(vbid);
            strctSglRst.add((Object)unit);
        }
        return unit;
    }

    protected Datainterface createQueryInputData(int neID, int slotID, int vbID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("vbid", String.valueOf(vbID));
        rowparams.addParam(param);
        param = new Param("vlanid", "-1");
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

