/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnVBAttr;
import com.huawei.network.qasn.m_q_ipservice.QAsnVBIndex;
import com.huawei.network.qasn.m_q_ipservice.QAsnVBInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnVBInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EVlanUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEQueryVBMountPortSuperBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBMgrSuperBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEQueryVBBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEQueryVBMountPortBean;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLPMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLinkMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public final class TEE2EVBUtil {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final int GET_DATA_FROM_NE = 1;

    private TEE2EVBUtil() {
    }

    public static List<TEEtherBridgeMOPO> getVBMOFromDB(int neID, int slotID) {
        String FUNC_NAME = "TEE2EVBUtil.getVBMOFromDB";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.getVBMOFromDB");
        ArrayList<TEEtherBridgeMOPO> vbMOList = new ArrayList<TEEtherBridgeMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotID}, TEEtherBridgeMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotID}, TEEtherBridgeMOPO.class);
            if (null == dbResult) {
                String tipStr = "getVBMOFromDB: get vb mo fail! The dbResult is null!";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBMOFromDB");
                return vbMOList;
            }
        }
        catch (Exception e) {
            String tipStr = "getVBMOFromDB: get vb mo fail! DB oper error!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr, (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBMOFromDB");
            return vbMOList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    vbMOList.add((TEEtherBridgeMOPO)obj);
                }
            }
        } else {
            String tipStr = "getVBMOFromDB: get vb mo fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
            e2eLogger.error(tipStr);
        }
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBMOFromDB");
        return vbMOList;
    }

    public static int getVBMOFromDB(int neID, int slotID, List<TEEtherBridgeMOPO> succVBMOList) {
        String FUNC_NAME = "TEE2EVBUtil.getVBMOFromDB";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.getVBMOFromDB");
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotID}, TEEtherBridgeMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotID}, TEEtherBridgeMOPO.class);
            if (null == dbResult) {
                String tipStr = "getVBMOFromDB: get vb mo fail! The dbResult is null!";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBMOFromDB");
                return 1092743443;
            }
        }
        catch (Exception e) {
            String tipStr = "getVBMOFromDB: get vb mo fail! DB oper error!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr, (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBMOFromDB");
            return 1092743443;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            String tipStr = "getVBMOFromDB: get vb mo fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
            e2eLogger.error(tipStr);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBMOFromDB");
            return retCode;
        }
        List data = dbResult.getData();
        if (null != data && !data.isEmpty()) {
            for (Object obj : data) {
                succVBMOList.add((TEEtherBridgeMOPO)obj);
            }
        }
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBMOFromDB");
        return 0;
    }

    public static TEEtherBridgeMOPO getVBMOFromDB(int neID, int slotID, int vbID) {
        String FUNC_NAME = "TEE2EVBUtil.getVBMOFromDB";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.getVBMOFromDB");
        List<TEEtherBridgeMOPO> vbMOList = TEE2EVBUtil.getVBMOFromDB(neID, slotID);
        for (TEEtherBridgeMOPO vbMO : vbMOList) {
            if (vbID != vbMO.getVBID()) continue;
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBMOFromDB");
            return vbMO;
        }
        String tipStr = "getVBMOFromDB: Get vb mo fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBMOFromDB");
        return null;
    }

    public static int delVBMOFromDB(int neID, int slotID, int vbID, List<TEEtherBridgeMOPO> delVBMOList) {
        String FUNC_NAME = "TEE2EVBUtil.delVBMOFromDB";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.delVBMOFromDB");
        TEDaoOperationResult dbResult = null;
        TEEtherBridgeMOPO vbMO = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotID}, TEEtherBridgeMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotID}, TEEtherBridgeMOPO.class);
            if (null == dbResult) {
                e2eLogger.error("delVBMOFromDB: Get vb fail! The dbResult is null!");
                TEEthE2ELog.logFuncEnd("TEE2EVBUtil.delVBMOFromDB");
                return 1092743443;
            }
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                TEDaoOperationResult delDbResult = null;
                for (Object obj : data) {
                    vbMO = (TEEtherBridgeMOPO)obj;
                    if (vbID != vbMO.getVBID() && (0 != vbID || 1 != vbMO.getVBActiveState())) continue;
                    delDbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID, slotID}, (Object)vbMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID, slotID}, (Object)vbMO);
                    if (null == delDbResult) {
                        e2eLogger.error("delVBMOFromDB: Del vb fail! The dbResult is null!");
                        continue;
                    }
                    int retCode = delDbResult.getResult();
                    if (0 != retCode) {
                        e2eLogger.error("delVBMOFromDB: Del vb fail! retCode->" + retCode);
                        continue;
                    }
                    if (null == delVBMOList) continue;
                    delVBMOList.add(vbMO);
                }
            }
        }
        catch (Exception e) {
            e2eLogger.error("delVBMOFromDB: Del vb fail! DB oper error!", (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.delVBMOFromDB");
            return 1092743443;
        }
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.delVBMOFromDB");
        return 0;
    }

    public static int updateVBMOToDB(int neID, int slotID, TEEtherBridgeMOPO vbMO) {
        String FUNC_NAME = "TEE2EVBUtil.updateVBMOToDB";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.updateVBMOToDB");
        if (null == vbMO) {
            e2eLogger.error("updateVBMOToDB: Save vb mo success! The vbMO is null!");
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.updateVBMOToDB");
            return 0;
        }
        e2eLogger.info("updateVBMOToDB: Save vb mo. vbMO: " + vbMO.toString());
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID, slotID}, (Object)vbMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID, slotID}, (Object)vbMO);
            if (null == dbResult) {
                e2eLogger.error("updateVBMOToDB: Save vb mo fail! The dbResult is null!");
                TEEthE2ELog.logFuncEnd("TEE2EVBUtil.updateVBMOToDB");
                return 1092743443;
            }
            e2eLogger.info("updateVBMOToDB: Save vb mo. dbResult.result: " + dbResult.getResult());
        }
        catch (Exception e) {
            e2eLogger.error("updateVBMOToDB: Save vb mo fail!", (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.updateVBMOToDB");
            return 2;
        }
        int retCode = dbResult.getResult();
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.updateVBMOToDB");
        return retCode;
    }

    public static int createVBMOToDB(int neID, int slotID, TEEtherBridgeMOPO vbMO) {
        String FUNC_NAME = "TEE2EVBUtil.createVBMOToDB";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.createVBMOToDB");
        if (null == vbMO) {
            e2eLogger.error("createVBMOToDB: Save vb mo success! The vbMO is null!");
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.createVBMOToDB");
            return 0;
        }
        ArrayList<TEEtherBridgeMOPO> delVBMOList = new ArrayList<TEEtherBridgeMOPO>();
        TEE2EVBUtil.delVBMOFromDB(neID, slotID, vbMO.getVBID(), delVBMOList);
        e2eLogger.info("createVBMOToDB: Save vb mo. vbMO: " + vbMO.toString());
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID, slotID}, (Object)vbMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID, slotID}, (Object)vbMO);
            if (null == dbResult) {
                e2eLogger.error("createVBMOToDB: Save vb mo fail! The dbResult is null!");
                TEEthE2ELog.logFuncEnd("TEE2EVBUtil.createVBMOToDB");
                return 1092743443;
            }
            e2eLogger.info("createVBMOToDB: Save vb mo. dbResult.result: " + dbResult.getResult());
        }
        catch (Exception e) {
            e2eLogger.error("createVBMOToDB: Save vb mo fail!", (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.createVBMOToDB");
            return 2;
        }
        int retCode = dbResult.getResult();
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.createVBMOToDB");
        return retCode;
    }

    public static QAsnVBInfo convertPOVBToAsnVB(int neID, int slotID, TEEtherBridgeMOPO vbMO) {
        if (null == vbMO) {
            e2eLogger.error("convertPOVBToAsnVB: The vbMo is null!");
            return null;
        }
        Set vbLinkMOSet = vbMO.getLinkList();
        QAsnVBInfo asnVBInfo = new QAsnVBInfo();
        QAsnVBIndex vbIndex = asnVBInfo.vbIndex;
        QAsnVBAttr vbAttr = asnVBInfo.vbAttr;
        vbIndex.neID = neID;
        vbIndex.slotID = slotID;
        vbIndex.subSlotID = -1;
        vbIndex.vbID = vbMO.getVBID();
        vbAttr.vbLabel = vbMO.getVBLabel().getBytes();
        vbAttr.vbOwner = vbMO.getVBOwner().getBytes();
        vbAttr.vbName = TEE2EVBUtil.getE2EVBName(vbMO).getBytes();
        vbAttr.vbLearnMode = vbMO.getVBLearnMode();
        vbAttr.vbFilterEnable = vbMO.getVBFilterEnable();
        vbAttr.vbMacLrnEnable = vbMO.getVBMacLrnEnable();
        vbAttr.logicportNum = vbLinkMOSet.size();
        Iterator iter = vbLinkMOSet.iterator();
        while (iter.hasNext()) {
            vbAttr.logicPortAttrList.add((Object)((TEEtherVBLinkMOPO)iter.next()).getPhyPortID());
        }
        vbAttr.isActive = vbMO.getVBActiveState();
        return asnVBInfo;
    }

    public static QAsnVBInfoList convertPOVBToAsnVB(int neID, int slotID, List<TEEtherBridgeMOPO> vbMOList) {
        QAsnVBInfoList vbInfoList = new QAsnVBInfoList();
        if (null == vbMOList) {
            return vbInfoList;
        }
        for (TEEtherBridgeMOPO vbMO : vbMOList) {
            vbInfoList.add((Object)TEE2EVBUtil.convertPOVBToAsnVB(neID, slotID, vbMO));
        }
        return vbInfoList;
    }

    private static String getE2EVBName(TEEtherBridgeMOPO vbMO) {
        String vbName = "";
        if (null == vbMO) {
            e2eLogger.error("getE2EVBName: Get e2e vb name fail! The vbMO is null!");
            return vbName;
        }
        vbName = vbMO.getBridgeType() + "." + vbMO.getVBName();
        return vbName;
    }

    public static QAsnVBIndex convertPOVBToAsnVBIndex(int neID, int slotID, TEEtherBridgeMOPO vbMO) {
        if (null == vbMO) {
            return null;
        }
        QAsnVBIndex vbIndex = new QAsnVBIndex();
        vbIndex.neID = neID;
        vbIndex.slotID = slotID;
        vbIndex.subSlotID = -1;
        vbIndex.vbID = vbMO.getVBID();
        return vbIndex;
    }

    public static int connectSBIForNE(int neID, QAsnErrInfoList errInfoList) {
        String FUNC_NAME = "TEE2EVBUtil.connectSBIForNE";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.connectSBIForNE");
        int result = -1;
        result = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != result) {
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = result;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfoList.add((Object)errInfo);
            e2eLogger.error("connectSBIForNE: Connect to ne failed! neID->" + neID);
        }
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.connectSBIForNE");
        return result;
    }

    public static void fillErrorToRsp(QAsnErrInfoList rspErrInfoList, int neID, int retCode) {
        if (0 != retCode) {
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            rspErrInfoList.add((Object)errInfo);
        }
    }

    public static int getVBFromNE(int neID, int slotID) {
        String FUNC_NAME = "TEE2EVBUtil.getVBFromNE";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.getVBFromNE");
        int result = -1;
        TEVBMgrSuperBean queryVBBean = null;
        int vbCodeVersion = TEE2EVBUtil.getVBCodeVersion(neID, 2108741);
        queryVBBean = 1 == vbCodeVersion ? new TEQueryVBBean(){

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }

            public boolean isNeedOperationlog() {
                return false;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEQueryVBBean(){

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }

            public boolean isNeedOperationlog() {
                return false;
            }
        };
        int cmdID = 2108741;
        SubFunc subFunc1 = TEEthXCUtil.createSubFunc(neID, cmdID);
        if (null == subFunc1) {
            String tips = "getVBFromNE: Get SubFunc fail! ";
            tips = tips + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tips);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBFromNE");
            return 1090646019;
        }
        Datainterface inputData = TEE2EVBUtil.createQueryVBInput(neID, slotID);
        Datainterface outputData = null;
        try {
            outputData = queryVBBean.performBussinessProcess(neID, subFunc1, inputData, null, null, null);
        }
        catch (Exception e) {
            String tips = "getVBFromNE: queryVBBean run fail! ";
            tips = tips + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tips, (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBFromNE");
            return 1090646019;
        }
        if (null == outputData) {
            String tips = "getVBFromNE: queryVBBean run fail! outputData is null! ";
            tips = tips + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tips);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBFromNE");
            return 1090646019;
        }
        result = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != result) {
            String tips = "getVBFromNE: Query vb from ne fail! ";
            tips = tips + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, result);
            e2eLogger.error(tips);
            TEE2EVBUtil.printRowError(outputData);
            return result;
        }
        int errCode2 = TEE2EVlanUtil.getVLANFromNE(neID, slotID);
        if (0 != errCode2) {
            String tips = "getVBFromNE: Query vlan from ne fail! ";
            tips = tips + String.format("[neID:%d, slotID:%d, errCode2:%d]", neID, slotID, errCode2);
            e2eLogger.error(tips);
        }
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBFromNE");
        return result;
    }

    public static int getVBFromNESaveDB(int neID, int slotID, QAsnErrInfoList rspErrInfoList) {
        String FUNC_NAME = "TEE2EVBUtil.getVBFromNESaveDB";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.getVBFromNESaveDB");
        int errCode = -1;
        TEVBMgrSuperBean queryVBBean = null;
        int vbCodeVersion = TEE2EVBUtil.getVBCodeVersion(neID, 2108741);
        queryVBBean = 1 == vbCodeVersion ? new TEQueryVBBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEQueryVBBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        };
        int cmdID = 2108741;
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, cmdID);
        if (null == subFunc) {
            String tipStr = "getVBFromNESaveDB: Get SubFunc fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr);
            int retCode = 1090646019;
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            rspErrInfoList.add((Object)errInfo);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBFromNESaveDB");
            return retCode;
        }
        Datainterface inputData = TEE2EVBUtil.createQueryVBInput(neID, slotID);
        Datainterface outputData = null;
        try {
            outputData = queryVBBean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        }
        catch (Exception e) {
            String tipStr = "getVBFromNESaveDB: queryVBBean run fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr, (Throwable)e);
            int retCode = 1090646019;
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            rspErrInfoList.add((Object)errInfo);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBFromNESaveDB");
            return retCode;
        }
        if (null == outputData) {
            String tipStr = "getVBFromNESaveDB: queryVBBean run fail! outputData is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr);
            int retCode = 1090646019;
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            rspErrInfoList.add((Object)errInfo);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBFromNESaveDB");
            return retCode;
        }
        errCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errCode) {
            String tipStr = "getVBFromNESaveDB: Query vb from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errCode);
            e2eLogger.error(tipStr);
            TEE2EVBUtil.printRowError(outputData);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, rspErrInfoList);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBFromNESaveDB");
            return errCode;
        }
        int errCode2 = TEE2EVlanUtil.getVLANFromNE(neID, slotID);
        if (0 != errCode2) {
            String tipStr = "getVBFromNESaveDB: Query vlan from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode2:%d]", neID, slotID, errCode2);
            e2eLogger.error(tipStr);
        }
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBFromNESaveDB");
        return errCode;
    }

    public static void printRowError(Datainterface outputData) {
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            return;
        }
        RowParams[] rowParamsArr = bussiness.getRowParams();
        if (0 == rowParamsArr.length) {
            return;
        }
        String errorCodeStr = null;
        for (RowParams rowParams : rowParamsArr) {
            int len = rowParams.getRowErrorsCount();
            for (int i = 0; i < len; ++i) {
                RowErrors[] rowErrorsArr = rowParams.getRowErrors();
                if (null == rowErrorsArr) continue;
                for (RowErrors rowErrors : rowErrorsArr) {
                    errorCodeStr = rowErrors.getErrorMessage().getErrorcode();
                    if (null == errorCodeStr || errorCodeStr.isEmpty() || errorCodeStr.equals(String.valueOf(38669))) continue;
                    e2eLogger.error("ne operation errorCode->" + errorCodeStr);
                }
            }
        }
    }

    public static int getVBLinkFromNE(int neID, int slotID, int vbid) {
        String FUNC_NAME = "TEE2EVBUtil.getVBLinkFromNE";
        TEEthE2ELog.logFuncBegin("TEE2EVBUtil.getVBLinkFromNE");
        int errCode = -1;
        TEQueryVBMountPortSuperBean queryVBLinkBean = null;
        int cmdID = 2116210;
        int vbCodeVersion = TEE2EVBUtil.getVBCodeVersion(neID, cmdID);
        queryVBLinkBean = 1 == vbCodeVersion ? new TEQueryVBMountPortBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEQueryVBMountPortBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        };
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, cmdID);
        if (null == subFunc) {
            String tipStr = "getVBLinkFromNE: Get SubFunc fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBLinkFromNE");
            return 1090646019;
        }
        Datainterface inputData = TEE2EVBUtil.createQueryVBLinkInput(neID, slotID, vbid);
        Datainterface outputData = null;
        try {
            outputData = queryVBLinkBean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        }
        catch (Exception e) {
            String tipStr = "getVBLinkFromNE: queryVBLinkBean run fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr, (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBLinkFromNE");
            return 1090646019;
        }
        errCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errCode) {
            String tipStr = "getVBLinkFromNE: Query vb link from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errCode);
            e2eLogger.error(tipStr);
            TEE2EVBUtil.printRowError(outputData);
        }
        TEEthE2ELog.logFuncEnd("TEE2EVBUtil.getVBLinkFromNE");
        return errCode;
    }

    private static Datainterface createQueryVBInput(int neID, int slotID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neID", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("vbid", String.valueOf(0));
        rowparams.addParam(param);
        param = new Param("linkid", String.valueOf(0));
        rowparams.addParam(param);
        return inputData;
    }

    private static Datainterface createQueryVBLinkInput(int neID, int slotID, int vbid) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neID", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("vbid", String.valueOf(vbid));
        rowparams.addParam(param);
        param = new Param("linkid", String.valueOf(0));
        rowparams.addParam(param);
        return inputData;
    }

    public static int getVBCodeVersion(int neID, int cmdID) {
        int version = 0;
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("neID", neID);
        paramMap.put("cmdID", cmdID);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, cmdID);
        if (null == subFunc) {
            e2eLogger.error("getVBCodeVersion: The subFunc is null! paramList: " + ((Object)paramMap).toString());
            return version;
        }
        String classMapping = subFunc.getClassMapping();
        if (null == classMapping) {
            e2eLogger.error("getVBCodeVersion: The classMapping is null! paramList: " + ((Object)paramMap).toString());
            classMapping = "";
            return version;
        }
        version = -1 != classMapping.indexOf(".ethlanservice.") ? 0 : (-1 != classMapping.indexOf(".ethlanservice_v2r7c01.") ? 1 : (-1 != classMapping.indexOf(".ethlanservice_v2r7c02.") ? 2 : (-1 != classMapping.indexOf(".ethlanservice_v2r8c01.") ? 3 : 0)));
        e2eLogger.info("getVBCodeVersion: vb code version->" + version);
        return version;
    }

    public static QAsnEthXCInfoList getVBLinkFromDB(int neID, int slotID) {
        QAsnEthXCInfoList infoList = new QAsnEthXCInfoList();
        List<TEEtherBridgeMOPO> vbMOList = TEE2EVBUtil.getVBMOFromDB(neID, slotID);
        int vbType = -1;
        Set vbLinkSet = null;
        Iterator vbLinkMOIter = null;
        TEEtherVBLinkMOPO vbLinkMO2 = null;
        QAsnEthXCInfo asnEVPLMO = null;
        Set<Integer> vblpIDList = null;
        if (!vbMOList.isEmpty()) {
            for (TEEtherBridgeMOPO vbMO : vbMOList) {
                vbType = vbMO.getBridgeType();
                vblpIDList = TEE2EVBUtil.getVlanUsedVBLP(vbMO);
                vbLinkSet = vbMO.getLinkList();
                for (TEEtherVBLinkMOPO vbLinkMO2 : vbLinkSet) {
                    if (!TEE2EVBUtil.isEthXC(vbType, vblpIDList, vbLinkMO2)) continue;
                    asnEVPLMO = TEEthXCUtil.mo2asnEthXC(neID, slotID, vbMO, vbLinkMO2);
                    infoList.add((Object)asnEVPLMO);
                }
            }
        } else {
            String tipStr = "getVBLinkFromDB: The vbMOList is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
        }
        return infoList;
    }

    private static Set<Integer> getVlanUsedVBLP(TEEtherBridgeMOPO vbMO) {
        HashSet<Integer> vblpSet = new HashSet<Integer>();
        TEEtherVBLPMOPO vblpMO2 = null;
        Set vblpMOSet = vbMO.getVBLPList();
        for (TEEtherVBLPMOPO vblpMO2 : vblpMOSet) {
            vblpSet.add(vblpMO2.getVBPortID());
        }
        return vblpSet;
    }

    private static boolean isEthXC(int vbType, Set<Integer> vblpList, TEEtherVBLinkMOPO vbLinkMO) {
        boolean isXc = true;
        return isXc;
    }

    public static Set<Integer> getExistedLinkIDSet(TEEtherBridgeMOPO vbMO) {
        HashSet<Integer> linkIDSet = new HashSet<Integer>();
        Set linkMOSet = vbMO.getLinkList();
        for (TEEtherVBLinkMOPO linkMO : linkMOSet) {
            linkIDSet.add(linkMO.getIDOnNE());
        }
        return linkIDSet;
    }

    public static Set<Integer> getCreatedVBLinkID(int neID, int slotID) {
        HashSet<Integer> vbLinkIDSet = new HashSet<Integer>();
        List<TEEtherBridgeMOPO> vbMOList = TEE2EVBUtil.getVBMOFromDB(neID, slotID);
        Set vbLinkSet = null;
        Iterator vbLinkMOIter = null;
        TEEtherVBLinkMOPO vbLinkMO2 = null;
        if (!vbMOList.isEmpty()) {
            for (TEEtherBridgeMOPO vbMO : vbMOList) {
                vbLinkSet = vbMO.getLinkList();
                for (TEEtherVBLinkMOPO vbLinkMO2 : vbLinkSet) {
                    vbLinkIDSet.add(vbLinkMO2.getIDOnNE());
                }
            }
        } else {
            String tipStr = "getCreatedVBLinkID: The vbMOList is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
        }
        return vbLinkIDSet;
    }

    public static TEEtherVBLinkMOPO asn2moEthXC(QAsnEthXCInfo ethXCInfo) {
        TEEtherVBLinkMOPO vblinkMO = new TEEtherVBLinkMOPO();
        int e2eSrcPortID = ethXCInfo.xcAttr.srcEndTP.portID;
        int e2eSnkPortID = ethXCInfo.xcAttr.snkEndTP.portID;
        int e2eSrcPortType = ethXCInfo.xcAttr.srcEndTP.portType;
        int e2eSnkPortType = ethXCInfo.xcAttr.snkEndTP.portType;
        int weblctSrcPortID = TEEthXCUtil.getWebLCTPortID(e2eSrcPortID, e2eSrcPortType);
        int weblctSnkPortID = TEEthXCUtil.getWebLCTPortID(e2eSnkPortID, e2eSnkPortType);
        vblinkMO.setActiveState((short)ethXCInfo.xcAttr.isActive);
        vblinkMO.setCVLanID(TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.srcEndTP.vlanID));
        vblinkMO.setDir((short)ethXCInfo.xcAttr.direction);
        vblinkMO.setForwardPRI(-1);
        vblinkMO.setIDOnNE(ethXCInfo.xcIndex.xcID);
        vblinkMO.setPhyPortID(weblctSrcPortID);
        vblinkMO.setPhyPortType((short)e2eSrcPortType);
        vblinkMO.setPktPRI(0);
        vblinkMO.setRPRdstNodeID(-1);
        vblinkMO.setRPRFwdPRI(-1);
        vblinkMO.setRPRRingDir(-1);
        vblinkMO.setSVLanID(TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.srcEndTP.svlanID));
        vblinkMO.setSVlanPRI(0);
        vblinkMO.setTunnelLabel(-1L);
        vblinkMO.setType((short)ethXCInfo.xcIndex.xcType);
        vblinkMO.setVBPortID(weblctSnkPortID);
        vblinkMO.setVCLabel(-1L);
        return vblinkMO;
    }

    public static int getWebLCTVBType(String e2eVBName) {
        return Integer.parseInt(e2eVBName.substring(0, 1));
    }

    public static String getWebLCTVBName(String e2eVBName) {
        return e2eVBName.substring(2);
    }

    public static String getE2EVBName(String weblctVBName, int vbType) {
        return "" + vbType + "." + weblctVBName;
    }

    public static int ne2E2EVBType(int neVBType) {
        return neVBType + 1;
    }

    public static int e2e2NEVBType(int e2eVBType) {
        return e2eVBType - 1;
    }

    public static Datainterface performSubFunc(int neID, int sfid, Datainterface inputData) {
        Datainterface allData = null;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
            if (null == subFunc && null == (subFunc = TECreateObjectFactory.getSubFunc((int)sfid))) {
                e2eLogger.info("Don't found subfunction(sfid = " + sfid + ") description in Functions description file\u00a3\u00a1");
                return null;
            }
            Datainterface memeryData = new Datainterface();
            allData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neID, (SubFunc)subFunc, (Datainterface)inputData, (Datainterface)memeryData, null, null, (int)1);
        }
        catch (Exception e) {
            e2eLogger.error("performWNEMgrBussinessProcess Failed, function sfid:" + sfid + ",neid=" + neID, (Throwable)e);
            allData = new Datainterface();
            allData.setBussinessParams(new BussinessParams());
            allData.setErrorMessage(new ErrorMessage());
            allData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)1090646019));
        }
        return allData;
    }

    public static void fillAsnSingleReturn(int result, AsnSingleReturn singleReturn) {
        singleReturn.retCode = BigInteger.valueOf(result);
        singleReturn.isSuccess = result == 0;
    }

    public static int fillAsnSingleReturnResult(Datainterface outputData, AsnSingleReturn singleReturn) {
        if (outputData == null) {
            TEE2EVBUtil.fillAsnSingleReturn(1090593060, singleReturn);
            return 2;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            TEE2EVBUtil.fillAsnSingleReturn(errorCode, singleReturn);
            return 2;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() == 0) continue;
            int retCode = Integer.parseInt(row.getRowErrors(0).getErrorMessage().getErrorcode());
            TEE2EVBUtil.fillAsnSingleReturn(retCode, singleReturn);
            return 0;
        }
        TEE2EVBUtil.fillAsnSingleReturn(0, singleReturn);
        return 0;
    }

    public static List<BigInteger> convertToMacAddrList(String macAddr) {
        ArrayList<BigInteger> macAddrList = new ArrayList<BigInteger>();
        int len = macAddr.length();
        for (int i = 0; i < len; i += 2) {
            macAddrList.add(BigInteger.valueOf(Long.valueOf(macAddr.substring(i, i + 2), 16)));
        }
        return macAddrList;
    }

    public static String convertToNeMacAddrStr(List<BigInteger> macAddrList) {
        StringBuilder res = new StringBuilder();
        for (BigInteger macAddr : macAddrList) {
            String tempStr = "00" + macAddr.toString(16).toUpperCase();
            res.append(tempStr.substring(tempStr.length() - 2));
        }
        return res.toString();
    }

    public static void main(String[] args) {
        String str = "BF0000D000AB";
        System.out.println(TEE2EVBUtil.convertToNeMacAddrStr(TEE2EVBUtil.convertToMacAddrList(str)));
    }
}

