/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetUnicastReq;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnSetUnicastRsp;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnUnicast;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnUnicastList;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2ESetUnicastInfoHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        int slotid;
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        AsnSetUnicastReq req = (AsnSetUnicastReq)fReq;
        AsnSetUnicastRsp rsp = (AsnSetUnicastRsp)fRsp;
        if (req.routeList == null || req.routeList.isEmpty()) {
            rsp.result.retCode = BigInteger.valueOf(0L);
            e2elogger.info("AsnSetUnicastReq Unicast List is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)req.routeList));
            return 0;
        }
        int neid = req.neid.intValue();
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotid = req.slotid.intValue());
        if (errInfo != null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(errInfo.errCode);
            e2elogger.info("handler AsnSetUnicastReq failed! retCode:" + rsp.result.retCode);
            return 0;
        }
        Datainterface inputData = this.createInputData(neid, slotid, req);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neid, 0x202026, inputData);
        this.parseOutputData(neid, slotid, outputData, rsp);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected void parseOutputData(int neID, int slotID, Datainterface outputData, AsnSetUnicastRsp rsp) {
        if (outputData == null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(1090593060L);
            e2elogger.info("handler AsnSetUnicastReq failed! retCode:" + rsp.result.retCode);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 2 != errorCode && 1 != errorCode) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(errorCode);
            e2elogger.info("handler AsnSetUnicastReq failed! retCode:" + rsp.result.retCode);
            return;
        }
        rsp.result.isSuccess = true;
        rsp.result.retCode = 0 == errorCode ? BigInteger.valueOf(0L) : this.getErrorCode(outputData);
    }

    private BigInteger getErrorCode(Datainterface outputData) {
        BussinessParams buss = outputData.getBussinessParams();
        ArrayList<BigInteger> errCodes = new ArrayList<BigInteger>();
        int len = buss.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams rowParams = buss.getRowParams(i);
            if (rowParams.getRowErrorsCount() <= 0) continue;
            int jLen = rowParams.getRowErrorsCount();
            for (int j = 0; j < jLen; ++j) {
                RowErrors rowErrors = rowParams.getRowErrors(j);
                errCodes.add(BigInteger.valueOf(Long.valueOf(rowErrors.getErrorMessage().getErrorcode())));
                this.logRowError(rowErrors);
            }
        }
        if (!errCodes.isEmpty()) {
            return (BigInteger)errCodes.get(0);
        }
        return BigInteger.valueOf(1L);
    }

    private void logRowError(RowErrors rowErrors) {
        StringBuilder errStr = new StringBuilder();
        errStr.append("handler AsnSetUnicastReq detail(");
        errStr.append("errCode:" + rowErrors.getErrorMessage().getErrorcode() + ",");
        errStr.append("errParams[" + rowErrors.getErrorMessage().getErrorcode());
        errStr.append("slotid=" + (rowErrors.getParam("slotid") == null ? "" : rowErrors.getParam("slotid").getValue()));
        errStr.append("vbid=" + (rowErrors.getParam("vbid") == null ? "" : rowErrors.getParam("vbid").getValue()));
        errStr.append("vlanid=" + (rowErrors.getParam("vlanid") == null ? "" : rowErrors.getParam("vlanid").getValue()));
        errStr.append("macaddress=" + (rowErrors.getParam("macaddress") == null ? "" : rowErrors.getParam("macaddress").getValue()));
        errStr.append("vbport=" + (rowErrors.getParam("vbport") == null ? "" : rowErrors.getParam("vbport").getValue()));
        errStr.append("])");
        e2elogger.info(errStr.toString());
    }

    protected Datainterface createInputData(int neid, int slotid, AsnSetUnicastReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        AsnUnicastList uniCasts = req.routeList;
        int len = uniCasts.size();
        for (int i = 0; i < len; ++i) {
            AsnUnicast uniCast = (AsnUnicast)uniCasts.get(i);
            RowParams rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(neid));
            rowparams.addParam("slotid", String.valueOf(slotid));
            rowparams.addParam("vbid", uniCast.index.userid.toString());
            rowparams.addParam("vlanid", uniCast.index.vlanid.toString());
            rowparams.addParam("macaddress", TEE2EVBUtil.convertToNeMacAddrStr((List<BigInteger>)uniCast.index.macAddr));
            rowparams.addParam("vbport", uniCast.outPort.ifID.toString());
            rowparams.addParam("isLogFlag", "0");
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }
}

