/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnGetUnicastReq;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnGetUnicastRsp;
import com.huawei.nglct.nemgr.f_interface.asnipvb.AsnUnicast;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBTask;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EGetUnicastInfoHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        AsnGetUnicastReq req = (AsnGetUnicastReq)fReq;
        AsnGetUnicastRsp rsp = (AsnGetUnicastRsp)fRsp;
        int neID = req.neid.intValue();
        int slotID = req.slotid.intValue();
        int vbID = req.vbid.intValue() <= 0 ? 0 : req.vbid.intValue();
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neID, slotID);
        if (errInfo != null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(errInfo.errCode);
            e2elogger.info("handler AsnGetUnicastReq failed! retCode:" + rsp.result.retCode);
            return 0;
        }
        Datainterface inputData = this.createQueryInputData(neID, slotID, vbID);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neID, 0x202028, inputData);
        this.parseOutputData(neID, slotID, outputData, rsp);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected void parseOutputData(int neID, int slotID, Datainterface outputData, AsnGetUnicastRsp rsp) {
        if (outputData == null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(1090593060L);
            e2elogger.info("handler AsnGetUnicastReq failed! retCode:" + rsp.result.retCode);
            return;
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode && 1 != errorCode && 2 != errorCode) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(errorCode);
            e2elogger.info("handler AsnGetUnicastReq failed! retCode:" + rsp.result.retCode);
            return;
        }
        BussinessParams bussiness = outputData.getBussinessParams();
        if (bussiness == null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(1090593060L);
            e2elogger.info("handler AsnGetUnicastReq failed! retCode:" + rsp.result.retCode);
            return;
        }
        rsp.result.isSuccess = true;
        rsp.result.retCode = BigInteger.valueOf(0L);
        rsp.isVlanUnicast = true;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            AsnUnicast uniCast = new AsnUnicast();
            uniCast.index.userid = BigInteger.valueOf(TEEthQosUtil.getIntParamValue(row.getParam("vbid")));
            uniCast.index.vlanid = BigInteger.valueOf(TEEthQosUtil.getIntParamValue(row.getParam("vlanid")));
            uniCast.index.macAddr.addAll(TEE2EVBUtil.convertToMacAddrList(row.getParam("macaddress").getValue()));
            uniCast.outPort.slotID = BigInteger.valueOf(slotID);
            uniCast.outPort.ifType = BigInteger.valueOf(0L);
            uniCast.outPort.ifID = BigInteger.valueOf(TEEthQosUtil.getIntParamValue(row.getParam("vbport")));
            uniCast.routeStatus = BigInteger.valueOf(0L);
            rsp.routeList.add((Object)uniCast);
            e2elogger.info("handler AsnGetUnicastReq success! add an record:" + TEAsn1Util.getAsn1String((Object)uniCast));
        }
    }

    protected Datainterface createQueryInputData(int neID, int slotID, int vbID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("vbid", String.valueOf(vbID));
        rowparams.addParam(param);
        param = new Param("vlanid", "-1");
        rowparams.addParam(param);
        param = new Param("macaddress", "ffffffffffff");
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }

    public static void main(String[] args) {
        AsnGetUnicastReq req = new AsnGetUnicastReq();
        AsnGetUnicastRsp rsp = new AsnGetUnicastRsp();
        req.userid = BigInteger.valueOf(350L);
        req.neid = BigInteger.valueOf(23L);
        req.slotid = BigInteger.valueOf(5L);
        req.vbid = BigInteger.valueOf(0L);
        TEE2EVBTask task = new TEE2EVBTask();
        task.onGetUnicast(req, rsp, null);
        System.out.println(TEAsn1Util.getAsn1String((Object)rsp));
    }
}

