/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ipservice.QAsnDeleteVBReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnDeleteVBRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELogVB;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ENewError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBMgrWriteLogSuperBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TEDeleteVBDBHander;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEDeleteVBBean;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import java.util.ArrayList;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EDelVBHandler
extends TEWNEMgrHandler {
    private static final String NE_NOT_EXIST = "the ne is not exist! ";
    private static final String BOARD_NOT_EXIST = "the board is not exist! ";
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        ArrayList<TEEtherBridgeMOPO> delVBMOList;
        String FUNC_NAME = "TEE2EDelVBHandler.handleRequestImpl";
        TEEthE2ELog.logFuncBegin("TEE2EDelVBHandler.handleRequestImpl");
        QAsnDeleteVBReq req = (QAsnDeleteVBReq)qReq;
        QAsnDeleteVBRsp rsp = (QAsnDeleteVBRsp)qRsp;
        rsp.result.errList = new QAsnErrInfoList();
        int neID = req.vbIndex.neID;
        int slotID = req.vbIndex.slotID;
        int vbID = req.vbIndex.vbID;
        int retCode = 0;
        if (!this.isVBValid(neID, slotID, rsp.result)) {
            TEEthE2ELog.logFuncEnd("TEE2EDelVBHandler.handleRequestImpl");
            return 0;
        }
        TEEtherBridgeMOPO vbMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        if (null == vbMO) {
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, 1090598181, rsp.result);
            rsp.result.result = 1090650122;
            TEEthE2ELog.logFuncEnd("TEE2EDelVBHandler.handleRequestImpl");
            return 0;
        }
        if (1 == vbMO.getVBActiveState()) {
            retCode = TEE2EVBUtil.connectSBIForNE(neID, rsp.result.errList);
            if (0 != retCode) {
                rsp.result.result = 1090650122;
                TEEthE2ELog.logFuncEnd("TEE2EDelVBHandler.handleRequestImpl");
                return 0;
            }
            retCode = TEE2EDelVBHandler.delVBFromNE(neID, slotID, vbID, rsp.result);
            if (0 != retCode) {
                TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, vbID, retCode, rsp.result);
                rsp.result.result = 1090650122;
                TEEthE2ELog.logFuncEnd("TEE2EDelVBHandler.handleRequestImpl");
                return 0;
            }
        }
        if (0 != (retCode = TEE2EVBUtil.delVBMOFromDB(neID, slotID, vbID, delVBMOList = new ArrayList<TEEtherBridgeMOPO>()))) {
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, vbID, retCode, rsp.result);
            rsp.result.result = 1090650122;
            TEEthE2ELog.logFuncEnd("TEE2EDelVBHandler.handleRequestImpl");
            return 0;
        }
        TEEthServiceOAMUtil.deleteElanOAM(neID, slotID, vbID);
        TEDeleteVBDBHander.sendDelVBMessage(neID, slotID, delVBMOList);
        rsp.result.result = 0;
        TEEthE2ELog.logFuncEnd("TEE2EDelVBHandler.handleRequestImpl");
        return 0;
    }

    private boolean isVBValid(int neID, int slotID, QAsnErrInfoReturn rspRet) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            this.logNENullError(neID, slotID);
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, 1090596385, rspRet);
            rspRet.result = 1090650122;
            return false;
        }
        TEBoard board = ne.getBoard(slotID);
        if (null == board) {
            this.logBoardNullError(neID, slotID);
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, 1090646021, rspRet);
            rspRet.result = 1090650122;
            return false;
        }
        return true;
    }

    public static int delVBFromNE(int neID, int slotID, int vbID, QAsnErrInfoReturn rspErrorInfo) {
        Datainterface inputData;
        SubFunc subFunc;
        int retCode = 0;
        int sfid = TEE2EDelVBHandler.getSfid();
        TENEMgrInterface bean = TEE2EDelVBHandler.getDelVBBean(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc = TEEthXCUtil.createSubFunc(neID, sfid), inputData = TEE2EDelVBHandler.createDataInterface(neID, slotID, vbID), null, null, null);
        if (null == outputData) {
            TEE2EDelVBHandler.logOutputDataError(neID, slotID, vbID);
            retCode = 1090646019;
            TEE2EDelVBHandler.fillErrorToRsp(neID, rspErrorInfo, retCode);
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2EDelVBHandler.logBeanOperError(neID, slotID, vbID);
            TEE2EDelVBHandler.fillErrorToRsp(neID, slotID, rspErrorInfo, outputData);
            return retCode;
        }
        return retCode;
    }

    private static TENEMgrInterface getDelVBBean(int neID, int sfid) {
        TEVBMgrWriteLogSuperBean bean = null;
        int vbCodeVersion = TEE2EVBUtil.getVBCodeVersion(neID, sfid);
        bean = 1 == vbCodeVersion ? new TEDeleteVBBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isDelVBFromDB() {
                return false;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEDeleteVBBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isDelVBFromDB() {
                return false;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        };
        return bean;
    }

    private static int getSfid() {
        return 2108738;
    }

    private static Datainterface createDataInterface(int neID, int slotID, int vbID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("vbid", String.valueOf(vbID));
        rowparams.addParam(param);
        return inputData;
    }

    private static void fillErrorToRsp(int neID, int slotID, QAsnErrInfoReturn rspErrorInfo, Datainterface outputData) {
        TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, rspErrorInfo.errList);
        rspErrorInfo.result = 1090650122;
    }

    private static void fillErrorToRsp(int neID, QAsnErrInfoReturn rspErrorInfo, int retCode) {
        TEE2EVBUtil.fillErrorToRsp(rspErrorInfo.errList, neID, retCode);
        rspErrorInfo.result = 1090650122;
    }

    private void logBoardNullError(int neID, int slotID) {
        String tipStr = BOARD_NOT_EXIST;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, tipStr);
        e2eLogger.error(tipStr);
    }

    private void logNENullError(int neID, int slotID) {
        String tipStr = NE_NOT_EXIST;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, tipStr);
        e2eLogger.error(tipStr);
    }

    private static void logOutputDataError(int neID, int slotID, int vbID) {
        String tipStr = "outputData is null!";
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, tipStr);
        e2eLogger.error(tipStr);
    }

    private static void logBeanOperError(int neID, int slotID, int vbID) {
        String tipStr = "bean oper fail!";
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, tipStr);
        e2eLogger.error(tipStr);
    }
}

