/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ipservice.QAsnCreateVBReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnCreateVBRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnVBInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELogVB;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ENewError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEVBIDGenerator;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TECreateVBBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBMgrSuperBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TECreateVBDBHandler;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2ECreateVBHandler
extends TEWNEMgrHandler {
    private static final String NE_NOT_EXIST = "the ne is not exist! ";
    private static final String BOARD_NOT_EXIST = "the board is not exist! ";
    private static final String BOARD_ONLY_CREATE_ONE_VB = "the board only can create one vb! ";
    private static final String OUTPUT_DATA_IS_NULL = "outputData is null!";
    private static final String ERROR_BEAN_OPER_FAIL = "bean oper fail!";
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        String FUNC_NAME = "TEE2ECreateVBHandler.handleRequestImpl";
        TEEthE2ELog.logFuncBegin("TEE2ECreateVBHandler.handleRequestImpl");
        QAsnCreateVBReq req = (QAsnCreateVBReq)qReq;
        QAsnCreateVBRsp rsp = (QAsnCreateVBRsp)qRsp;
        rsp.result.errList = new QAsnErrInfoList();
        this.setVBInfoFromReq(rsp.vbInfo, req);
        int neID = req.cpIndex.neID;
        int slotID = req.cpIndex.slotID;
        if (req.cpIndex.shelfID != null) {
            slotID = TEBoardUtil.neToSlotIDNM((int)req.cpIndex.shelfID, (int)req.cpIndex.slotID);
        }
        if (!this.isVBValid(neID, slotID, rsp)) {
            TEEthE2ELog.logFuncEnd("TEE2ECreateVBHandler.handleRequestImpl");
            return 0;
        }
        int vbID = this.getVBID(neID, slotID);
        TEEtherBridgeMOPO vbMO = this.constructVBMO(vbID, req);
        int retCode = TEE2EVBUtil.createVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, vbID, retCode, rsp.result);
            rsp.result.result = 1090650122;
            TEEthE2ELog.logFuncEnd("TEE2ECreateVBHandler.handleRequestImpl");
            return retCode;
        }
        TECreateVBDBHandler.sendCreateVBMessage(neID, slotID, vbMO);
        rsp.result.result = 0;
        rsp.vbInfo = TEE2EVBUtil.convertPOVBToAsnVB(neID, slotID, vbMO);
        TEEthE2ELog.logFuncEnd("TEE2ECreateVBHandler.handleRequestImpl");
        return 0;
    }

    private boolean isVBValid(int neID, int slotID, QAsnCreateVBRsp rsp) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            this.logNENullError(neID, slotID);
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, 1090596385, rsp.result);
            rsp.result.result = 1090650122;
            return false;
        }
        int result = TEE2EVBUtil.connectSBIForNE(neID, rsp.result.errList);
        if (0 != result) {
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, result, rsp.result);
            rsp.result.result = 1090650122;
            return false;
        }
        TEBoard board = ne.getBoard(slotID);
        if (null == board) {
            this.logBoardNullError(neID, slotID);
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, 1090646021, rsp.result);
            rsp.result.result = 1090650122;
            return false;
        }
        List<TEEtherBridgeMOPO> vbMOList = TEE2EVBUtil.getVBMOFromDB(neID, slotID);
        if (!vbMOList.isEmpty()) {
            this.logVBExistError(neID, slotID);
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, 1090598144, rsp.result);
            rsp.result.result = 1090650122;
            return false;
        }
        return true;
    }

    private void setVBInfoFromReq(QAsnVBInfo vbInfo, QAsnCreateVBReq req) {
        vbInfo.vbIndex.neID = req.cpIndex.neID;
        vbInfo.vbIndex.slotID = req.cpIndex.shelfID != null ? TEBoardUtil.neToSlotIDNM((int)req.cpIndex.shelfID, (int)req.cpIndex.slotID) : req.cpIndex.slotID;
        vbInfo.vbIndex.subSlotID = req.cpIndex.subSlotID != null ? req.cpIndex.subSlotID : -1;
        vbInfo.vbIndex.vbID = -1;
        vbInfo.vbAttr.isActive = 0;
        vbInfo.vbAttr.logicportNum = 0;
        vbInfo.vbAttr.vbFilterEnable = req.vbFilterEnable;
        vbInfo.vbAttr.vbLearnMode = req.vbLearnMode;
        vbInfo.vbAttr.vbMacLrnEnable = req.vbMacLrnEnable;
        vbInfo.vbAttr.vbLabel = "".getBytes();
        vbInfo.vbAttr.vbName = req.vbName;
        vbInfo.vbAttr.vbOwner = "".getBytes();
    }

    public static int createVBToNE(int neID, int slotID, int newVBID, TEEtherBridgeMOPO vbMO, QAsnErrInfoReturn rspErrRet) {
        Datainterface inputData;
        SubFunc subFunc;
        int retCode = 0;
        int sfid = TEE2ECreateVBHandler.getSfid();
        TENEMgrInterface bean = TEE2ECreateVBHandler.getCreateVBBean(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc = TEEthXCUtil.createSubFunc(neID, sfid), inputData = TEE2ECreateVBHandler.createDataInterface(neID, slotID, newVBID, vbMO), null, null, null);
        if (null == outputData) {
            TEE2ECreateVBHandler.logOutputDataNullError(neID, slotID, newVBID);
            retCode = 1090646019;
            TEE2ECreateVBHandler.fillErrorToRsp(neID, rspErrRet, retCode);
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEE2ECreateVBHandler.logBeanOperFailError(neID, slotID, newVBID);
            TEE2ECreateVBHandler.fillErrorToRsp(neID, slotID, rspErrRet, outputData);
            return retCode;
        }
        return retCode;
    }

    private static TENEMgrInterface getCreateVBBean(int neID, int sfid) {
        TEVBMgrSuperBean bean = null;
        int vbCodeVersion = TEE2EVBUtil.getVBCodeVersion(neID, 2108741);
        bean = 1 == vbCodeVersion ? new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TECreateVBBean(){

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isNeedSendCreateNtf() {
                return false;
            }
        } : new TECreateVBBean(){

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isNeedSendCreateNtf() {
                return false;
            }
        };
        return bean;
    }

    private static Datainterface createDataInterface(int neID, int slotID, int vbID, TEEtherBridgeMOPO vbMO) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("vbid", String.valueOf(vbID));
        rowparams.addParam(param);
        param = new Param("vbname", vbMO.getVBName());
        rowparams.addParam(param);
        param = new Param("vbtype", String.valueOf(TEE2EVBUtil.e2e2NEVBType(vbMO.getBridgeType())));
        rowparams.addParam(param);
        param = new Param("lpcount", "0");
        rowparams.addParam(param);
        param = new Param("vbstudymode", String.valueOf(vbMO.getVBLearnMode()));
        rowparams.addParam(param);
        param = new Param("vbstudytype", String.valueOf(vbMO.getVBLearnMode()));
        rowparams.addParam(param);
        param = new Param("ingressfilter", String.valueOf(vbMO.getVBFilterEnable()));
        rowparams.addParam(param);
        param = new Param("accessenable", String.valueOf(0));
        rowparams.addParam(param);
        param = new Param("macaddrlearn", String.valueOf(vbMO.getVBMacLrnEnable()));
        rowparams.addParam(param);
        return inputData;
    }

    private static int getSfid() {
        return 2108737;
    }

    private TEEtherBridgeMOPO constructVBMO(int newVBID, QAsnCreateVBReq req) {
        TEEtherBridgeMOPO vbMO = new TEEtherBridgeMOPO();
        String e2eVBName = new String(req.vbName);
        vbMO.setVBID(newVBID);
        vbMO.setVBName(TEE2EVBUtil.getWebLCTVBName(e2eVBName));
        vbMO.setVBLearnMode(req.vbLearnMode);
        vbMO.setVBFilterEnable(req.vbFilterEnable);
        vbMO.setVBMacLrnEnable(req.vbMacLrnEnable);
        vbMO.setBridgeType(TEE2EVBUtil.getWebLCTVBType(e2eVBName));
        vbMO.setVBLabel("");
        vbMO.setVBOwner("");
        vbMO.setVBActiveState((short)0);
        vbMO.setPortNum(0);
        return vbMO;
    }

    private int getVBID(int neID, int slotID) {
        TEVBIDGenerator vbIDGenerator = new TEVBIDGenerator();
        vbIDGenerator.init(neID, slotID);
        return vbIDGenerator.generateLinkID();
    }

    private static void fillErrorToRsp(int neID, int slotID, QAsnErrInfoReturn rspErrRet, Datainterface outputData) {
        TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, rspErrRet.errList);
        rspErrRet.result = 1090650122;
    }

    private static void fillErrorToRsp(int neID, QAsnErrInfoReturn rspErrRet, int retCode) {
        TEE2EVBUtil.fillErrorToRsp(rspErrRet.errList, neID, retCode);
        rspErrRet.result = 1090650122;
    }

    private static void logBeanOperFailError(int neID, int slotID, int newVBID) {
        String tipStr = ERROR_BEAN_OPER_FAIL;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, tipStr);
        e2eLogger.error(tipStr);
    }

    private static void logOutputDataNullError(int neID, int slotID, int newVBID) {
        String tipStr = OUTPUT_DATA_IS_NULL;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, tipStr);
        e2eLogger.error(tipStr);
    }

    private void logVBExistError(int neID, int slotID) {
        String tipStr = BOARD_ONLY_CREATE_ONE_VB;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, tipStr);
        e2eLogger.error(tipStr);
    }

    private void logBoardNullError(int neID, int slotID) {
        String tipStr = BOARD_NOT_EXIST;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, tipStr);
        e2eLogger.error(tipStr);
    }

    private void logNENullError(int neID, int slotID) {
        String tipStr = NE_NOT_EXIST;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, tipStr);
        e2eLogger.error(tipStr);
    }
}

