/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ipservice.QAsnActiveVBReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnActiveVBRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnVBActiveRpt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECheckVB;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELogVB;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ENewError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2ECreateVBHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EDelVBHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.event.TEE2EActiveVBMsg;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.event.TEE2EVBNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import java.util.ArrayList;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EActiveVBHandler
extends TEWNEMgrHandler {
    private static final String ERROR_UNACTIVE_VB_FAIL_WHEN_CREATE_TO_NE = "unactive vb fail when create vb to ne! ";
    private static final String ERROR_UNACTIVE_VB_FAIL_WHEN_SAVE_DB = "unactive vb fail when save vb to db! ";
    private static final String ERROR_VB_ALREADY_ACTIVE = "the vb is active! ";
    private static final String ERROR_VB_ALREADY_UNACTIVE = "The vb is unactive! ";
    private static final String ERROR_CREATE_VB_TO_NE_FAIL = "create vb to ne fail! ";
    private static final String ERROR_SAVE_VB_TO_DB_FAIL = "active vb fail when save vb to db! ";
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        String FUNC_NAME = "TEE2EActiveVBHandler.handleRequestImpl";
        TEEthE2ELog.logFuncBegin("TEE2EActiveVBHandler.handleRequestImpl");
        QAsnActiveVBReq req = (QAsnActiveVBReq)qReq;
        QAsnActiveVBRsp rsp = (QAsnActiveVBRsp)qRsp;
        rsp.errorInfo.errList = new QAsnErrInfoList();
        int neID = req.vbIndex.neID;
        int slotID = req.vbIndex.slotID;
        int vbID = req.vbIndex.vbID;
        if (!TEEthE2ECheckVB.isVBValid("TEE2EActiveVBHandler.handleRequestImpl", req.vbIndex, rsp.errorInfo)) {
            rsp.errorInfo.result = 1090650122;
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBHandler.handleRequestImpl");
            return 0;
        }
        int result = TEE2EVBUtil.connectSBIForNE(neID, rsp.errorInfo.errList);
        if (0 != result) {
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, vbID, result, rsp.errorInfo);
            rsp.errorInfo.result = 1090650122;
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBHandler.handleRequestImpl");
            return 0;
        }
        TEEtherBridgeMOPO vbMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        if (null == vbMO) {
            TEEthE2ELogVB.getLog4Invoke("TEE2EActiveVBHandler.handleRequestImpl", "The vbMO is not exist! ", req.vbIndex);
            this.constructVBNotExistError(req, rsp);
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBHandler.handleRequestImpl");
            return 0;
        }
        int retCode = this.activeOrUnActiveVB(req, rsp, vbMO);
        if (0 != retCode) {
            TEEthE2ELog.logFuncEnd("TEE2EActiveVBHandler.handleRequestImpl");
            return 0;
        }
        this.sendActiveMessage(neID, slotID, vbMO, req.isActive);
        rsp.errorInfo.result = 0;
        TEEthE2ELog.logFuncEnd("TEE2EActiveVBHandler.handleRequestImpl");
        return 0;
    }

    private int activeOrUnActiveVB(QAsnActiveVBReq req, QAsnActiveVBRsp rsp, TEEtherBridgeMOPO vbMO) {
        int neID = req.vbIndex.neID;
        int slotID = req.vbIndex.slotID;
        int isActiveOper = req.isActive;
        if (1 == isActiveOper) {
            return this.activeVB(neID, slotID, vbMO, rsp.errorInfo);
        }
        return this.unActiveVB(neID, slotID, vbMO, rsp.errorInfo);
    }

    private int activeVB(int neID, int slotID, TEEtherBridgeMOPO vbMO, QAsnErrInfoReturn errorInfo) {
        int vbID = vbMO.getVBID();
        if (1 == vbMO.getVBActiveState()) {
            this.logVBAlreadyActiveError(neID, slotID, vbID);
            return 0;
        }
        int retCode = TEE2ECreateVBHandler.createVBToNE(neID, slotID, vbID, vbMO, errorInfo);
        if (0 != retCode) {
            this.logCreateVBToNEError(neID, slotID, vbID, retCode);
            return retCode;
        }
        vbMO.setVBActiveState((short)1);
        retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            this.logUpdateVBMOToDBError(neID, slotID, vbID, retCode);
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, vbID, retCode, errorInfo);
            return retCode;
        }
        return 0;
    }

    private int unActiveVB(int neID, int slotID, TEEtherBridgeMOPO vbMO, QAsnErrInfoReturn errorInfo) {
        int vbID = vbMO.getVBID();
        if (0 == vbMO.getVBActiveState()) {
            this.logVBAlreadyUnActiveError(neID, slotID, vbID);
            return 0;
        }
        int retCode = TEE2EDelVBHandler.delVBFromNE(neID, slotID, vbID, errorInfo);
        if (0 != retCode) {
            this.logDelVBFromNEError(neID, slotID, vbID, retCode);
            return retCode;
        }
        vbMO.setVBActiveState((short)0);
        retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            this.logUpdateVBMOToDBOnUnActiveError(neID, slotID, vbID, retCode);
            TEEthE2ENewError.fillRetCode2Rsp(neID, slotID, vbID, retCode, errorInfo);
            return retCode;
        }
        TEEthServiceOAMUtil.deleteElanOAM(neID, slotID, vbID);
        return 0;
    }

    private void sendActiveMessage(int neID, int slotID, TEEtherBridgeMOPO vbMO, int isActive) {
        QAsnVBActiveRpt content = new QAsnVBActiveRpt();
        ArrayList<TEEtherBridgeMOPO> vbMOList = new ArrayList<TEEtherBridgeMOPO>();
        vbMOList.add(vbMO);
        content.vbInfoList = TEE2EVBUtil.convertPOVBToAsnVB(neID, slotID, vbMOList);
        content.isActive = isActive;
        TEE2EActiveVBMsg e2eVBMsg = new TEE2EActiveVBMsg(content);
        TEE2EVBNoticeMgr.sendActiveNtf(e2eVBMsg);
    }

    private void constructVBNotExistError(QAsnActiveVBReq req, QAsnActiveVBRsp rsp) {
        int retCode = 1090598181;
        rsp.errorInfo.errList.addAll(TEEthE2ENewError.createQAsnErrInfo(retCode, req.vbIndex));
        rsp.errorInfo.result = 1090650122;
    }

    private void logUpdateVBMOToDBError(int neID, int slotID, int vbID, int retCode) {
        String tipStr = ERROR_SAVE_VB_TO_DB_FAIL;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, retCode, tipStr);
        e2eLogger.error(tipStr);
    }

    private void logCreateVBToNEError(int neID, int slotID, int vbID, int retCode) {
        String tipStr = ERROR_CREATE_VB_TO_NE_FAIL;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, retCode, tipStr);
        e2eLogger.error(tipStr);
    }

    private void logVBAlreadyUnActiveError(int neID, int slotID, int vbID) {
        String tipStr = ERROR_VB_ALREADY_UNACTIVE;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, tipStr);
        e2eLogger.error(tipStr);
    }

    private void logVBAlreadyActiveError(int neID, int slotID, int vbID) {
        String tipStr = ERROR_VB_ALREADY_ACTIVE;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, tipStr);
        e2eLogger.error(tipStr);
    }

    private void logUpdateVBMOToDBOnUnActiveError(int neID, int slotID, int vbID, int retCode) {
        String tipStr = ERROR_UNACTIVE_VB_FAIL_WHEN_SAVE_DB;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, retCode, tipStr);
        e2eLogger.error(tipStr);
    }

    private void logDelVBFromNEError(int neID, int slotID, int vbID, int retCode) {
        String tipStr = ERROR_UNACTIVE_VB_FAIL_WHEN_CREATE_TO_NE;
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, retCode, tipStr);
        e2eLogger.error(tipStr);
    }
}

