/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util;

import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEEthE2ELogEVPL {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEEthE2ELogEVPL() {
    }

    public static Logger getLogger() {
        return e2eLogger;
    }

    public static void logLinkNullInDBError(QAsnEthXCInfo xcInfo, String FUNC_NAME) {
        e2eLogger.error(TEEthE2ELogEVPL.getLog4Invoke(FUNC_NAME, "The link is not exist in db! ", xcInfo));
    }

    public static void logSubFuncNullError(QAsnEthXCInfo xcInfo, String FUNC_NAME) {
        e2eLogger.error(TEEthE2ELogEVPL.getLog4Invoke(FUNC_NAME, "Get subFunc fail! ", xcInfo));
    }

    public static void logDelFromNEFailError(QAsnEthXCInfo xcInfo, String FUNC_NAME, Datainterface inputData) {
        String detail = "Del evpl from ne fail! \n" + inputData.toString();
        String tip = TEEthE2ELogEVPL.getLog4Invoke(FUNC_NAME, detail, xcInfo);
        e2eLogger.error(tip);
    }

    public static void logOutputDataError(QAsnEthXCInfo xcInfo, String FUNC_NAME, Datainterface inputData) {
        String detail = "Del evpl from ne fail! The outputData is null! \n" + inputData.toString();
        String tip = TEEthE2ELogEVPL.getLog4Invoke(FUNC_NAME, detail, xcInfo);
        e2eLogger.error(tip);
    }

    public static void logExceptionError(QAsnEthXCInfo xcInfo, String FUNC_NAME, Exception e) {
        String detail = "Del evpl from ne fail! The bean run fail! ";
        String tip = TEEthE2ELogEVPL.getLog4Invoke(FUNC_NAME, detail, xcInfo);
        e2eLogger.error(tip, (Throwable)e);
    }

    public static String getLog4Invoke(String funcName, String tip, QAsnEthXCInfo xcInfo) {
        String logStr = funcName + ": " + tip + "\n" + "xcInfo[F1]: " + TEEthE2ELogEVPL.getLogObjID(xcInfo).toString();
        return logStr;
    }

    public static String getLog4Ego(String funcName, String tip, QAsnEthXCInfo xcInfo) {
        String logStr = funcName + ": " + tip + "\n" + "xcInfo[F1]: " + TEEthE2ELogEVPL.getLogObjID(xcInfo).toString();
        return logStr;
    }

    public static List<Integer> getLogObjID(QAsnEthXCInfo xcInfo) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        int neID = xcInfo.xcIndex.neID;
        int slotID = xcInfo.xcIndex.slotID;
        int srcPortID = xcInfo.xcAttr.srcEndTP.portID;
        int srcPortType = xcInfo.xcAttr.srcEndTP.portType;
        int snkPortID = xcInfo.xcAttr.snkEndTP.portID;
        int snkPortType = xcInfo.xcAttr.snkEndTP.portType;
        int webSrcPortID = TEEthXCUtil.getWebLCTPortID(srcPortID, srcPortType);
        int webSnkPortID = TEEthXCUtil.getWebLCTPortID(snkPortID, snkPortType);
        int srcVlanID = xcInfo.xcAttr.srcEndTP.vlanID;
        int srcSVlanID = xcInfo.xcAttr.srcEndTP.svlanID;
        int snkVlanID = xcInfo.xcAttr.snkEndTP.vlanID;
        int snkSVlanID = xcInfo.xcAttr.snkEndTP.svlanID;
        int direction = xcInfo.xcAttr.direction;
        idList.add(neID);
        idList.add(slotID);
        idList.add(direction);
        idList.add(webSrcPortID);
        idList.add(srcVlanID);
        idList.add(srcSVlanID);
        idList.add(webSnkPortID);
        idList.add(snkVlanID);
        idList.add(snkSVlanID);
        return idList;
    }
}

