/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import java.util.ArrayList;
import java.util.List;

public class TEEthE2ECreateError {
    private TEEthE2ECreateError() {
    }

    public static List<QAsnErrInfo> createQAsnErrInfo(int errorCode, QAsnEthXCInfo xcInfo) {
        ArrayList<QAsnErrInfo> errInfoList = new ArrayList<QAsnErrInfo>();
        List<int[]> objIDList = TEEthE2ECreateError.getErrObjIDList(xcInfo);
        errInfoList.addAll(TEEthE2ECreateError.createQAsnErrInfo(errorCode, objIDList));
        return errInfoList;
    }

    public static List<QAsnErrInfo> createQAsnErrInfo(int errorCode, List<int[]> objIDList) {
        ArrayList<QAsnErrInfo> errInfoList = new ArrayList<QAsnErrInfo>();
        if (null == objIDList) {
            return errInfoList;
        }
        for (int[] objID : objIDList) {
            errInfoList.add(TEEthE2ECreateError.createQAsnErrInfo(errorCode, objID));
        }
        return errInfoList;
    }

    public static QAsnErrInfo createQAsnErrInfo(int errorCode, int[] objID) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.errCode = errorCode;
        errInfo.objID = new QAsnTinyIntList();
        int len = objID.length;
        for (int i = 0; i < len; ++i) {
            errInfo.objID.add((Object)objID[i]);
        }
        return errInfo;
    }

    public static List<int[]> getErrObjIDList(QAsnEthXCInfo xcInfo) {
        ArrayList<int[]> objIDList = new ArrayList<int[]>();
        int neID = xcInfo.xcIndex.neID;
        int slotID = xcInfo.xcIndex.slotID;
        int srcPortID = xcInfo.xcAttr.srcEndTP.portID;
        int srcPortType = xcInfo.xcAttr.srcEndTP.portType;
        int snkPortID = xcInfo.xcAttr.snkEndTP.portID;
        int snkPortType = xcInfo.xcAttr.snkEndTP.portType;
        int webSrcPortID = TEEthXCUtil.getWebLCTPortID(srcPortID, srcPortType);
        int webSnkPortID = TEEthXCUtil.getWebLCTPortID(snkPortID, snkPortType);
        int srcVlanID = xcInfo.xcAttr.srcEndTP.vlanID;
        int srcSVlanID = xcInfo.xcAttr.srcEndTP.svlanID;
        int snkVlanID = xcInfo.xcAttr.snkEndTP.vlanID;
        int snkSVlanID = xcInfo.xcAttr.snkEndTP.svlanID;
        int direction = xcInfo.xcAttr.direction;
        int[] objID = new int[]{neID, slotID, webSrcPortID, srcVlanID, srcSVlanID, webSnkPortID, snkVlanID, snkSVlanID};
        objIDList.add(objID);
        if (1 == direction) {
            objID = new int[]{neID, slotID, webSnkPortID, snkVlanID, snkSVlanID, webSrcPortID, srcVlanID, srcSVlanID};
            objIDList.add(objID);
        }
        return objIDList;
    }
}

