/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECreateError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELogEVPL;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class TEEthE2ECheckXC {
    private TEEthE2ECheckXC() {
    }

    public static boolean isXCValid(QAsnEthXCInfo xcInfo, Set<Integer> normalNEIDSet, QAsnErrInfoReturn asnRet, String invokeMethod) {
        int neID = xcInfo.xcIndex.neID;
        int slotID = xcInfo.xcIndex.slotID;
        if (!normalNEIDSet.contains(neID)) {
            return false;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            String detail = "The ne is not exist!";
            TEEthE2ELogEVPL.getLogger().error(TEEthE2ELogEVPL.getLog4Invoke(invokeMethod, detail, xcInfo));
            int retCode = 1090596385;
            List<QAsnErrInfo> errInfoList = TEEthE2ECreateError.createQAsnErrInfo(retCode, xcInfo);
            asnRet.errList.addAll(errInfoList);
            return false;
        }
        TEBoard board = ne.getBoard(slotID);
        if (null == board) {
            String detail = "The board is not exist!";
            TEEthE2ELogEVPL.getLogger().error(TEEthE2ELogEVPL.getLog4Invoke(invokeMethod, detail, xcInfo));
            int retCode = 1090646021;
            List<QAsnErrInfo> errInfoList = TEEthE2ECreateError.createQAsnErrInfo(retCode, xcInfo);
            asnRet.errList.addAll(errInfoList);
            return false;
        }
        return true;
    }

    public static int checkXCStatus(String funcName, QAsnEthXCInfo asnXC, TEEtherEVPLContainer container) {
        ArrayList<QAsnEthXCInfo> unDirAsnXCList = new ArrayList<QAsnEthXCInfo>();
        List<TEEtherEVPLMOPO> moEvplList = TEEthXCUtil.getEVPLMOFromDB(asnXC, unDirAsnXCList, container);
        if (!TEEthE2ECheckXC.isXCExist(moEvplList)) {
            TEEthE2ELogEVPL.logLinkNullInDBError(asnXC, funcName);
            return 1090598186;
        }
        if (!TEEthE2ECheckXC.isXCStatusValid(asnXC, moEvplList)) {
            TEEthE2ELogEVPL.getLogger().error(TEEthE2ELogEVPL.getLog4Invoke(funcName, "The link is not consist! ", asnXC));
            return 1090600975;
        }
        return 0;
    }

    private static boolean isXCExist(List<TEEtherEVPLMOPO> moEvplList) {
        return !moEvplList.isEmpty();
    }

    private static boolean isXCStatusValid(QAsnEthXCInfo asnXC, List<TEEtherEVPLMOPO> moEvplList) {
        boolean isEqual = true;
        int asnState = asnXC.xcAttr.isActive;
        int moState = -1;
        for (TEEtherEVPLMOPO moEvpl : moEvplList) {
            moState = moEvpl.getActivateState();
            if (moState == asnState) continue;
            isEqual = false;
            break;
        }
        return isEqual;
    }
}

