/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipbase.QAsnAttrValue;
import com.huawei.network.qasn.m_q_ipqos.QAsnCOSIndex;
import com.huawei.network.qasn.m_q_ipqos.QAsnCOSIndexList;
import com.huawei.network.qasn.m_q_ipqos.QAsnCOSInfo;
import com.huawei.network.qasn.m_q_ipqos.QAsnCOSInfoList;
import com.huawei.network.qasn.m_q_ipqos.QAsnGetCOSReq;
import com.huawei.network.qasn.m_q_ipqos.QAsnGetCOSRsp;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetCosHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        QAsnGetCOSReq req = (QAsnGetCOSReq)fReq;
        QAsnGetCOSRsp rsp = (QAsnGetCOSRsp)fRsp;
        QAsnCOSIndexList cosIndexList = req.cosIndexList;
        if (cosIndexList.isEmpty()) {
            rsp.result.result = 0;
            e2elogger.info("QAsnGetCOSReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        rsp.result.errList = new QAsnErrInfoList();
        int len = cosIndexList.size();
        for (int i = 0; i < len; ++i) {
            QAsnCOSIndex cosIndex = (QAsnCOSIndex)cosIndexList.get(i);
            int neID = cosIndex.neID;
            int slotID = cosIndex.slotID;
            QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neID, slotID);
            if (errInfo != null) {
                rsp.result.errList.add((Object)errInfo);
                continue;
            }
            Datainterface inputData = TEGetCosHandler.createQueryInputData(neID, slotID, cosIndex.cosID);
            Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neID, 2105419, inputData);
            rsp.result.errList.addAll((Collection)TEGetCosHandler.parseOutputData(neID, slotID, outputData, rsp.cosList));
        }
        rsp.result.result = rsp.result.errList.isEmpty() ? 0 : (rsp.result.errList.size() >= req.cosIndexList.size() ? 1090650122 : 1090650121);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    public static QAsnErrInfoList parseOutputData(int neID, int slotID, Datainterface outputData, QAsnCOSInfoList cosList) {
        BussinessParams bussiness;
        QAsnErrInfoList errList = new QAsnErrInfoList();
        QAsnErrInfoList errInfoList = TEEthQosUtil.checkOutputData(neID, slotID, outputData);
        if (!errInfoList.isEmpty()) {
            errList.addAll((Collection)errInfoList);
        }
        if ((bussiness = outputData.getBussinessParams()) == null) {
            return errList;
        }
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            int cosID = TEEthQosUtil.getIntParamValue(row.getParam("cosid"));
            int cosType = TEEthQosUtil.getIntParamValue(row.getParam("costype"));
            QAsnCOSInfo cosIndex = TEGetCosHandler.getQAsnCosInfo(cosList, cosID);
            if (cosIndex == null) {
                cosIndex = new QAsnCOSInfo();
                cosIndex.cosIndex.neID = neID;
                cosIndex.cosIndex.slotID = slotID;
                cosIndex.cosIndex.cosID = cosID;
                cosIndex.cosAttr.costype = cosType;
                cosList.add((Object)cosIndex);
            }
            if (cosType == 1) {
                cosIndex.cosAttr.simplePri = TEEthQosUtil.getIntParamValue(row.getParam("pri"));
                continue;
            }
            QAsnAttrValue attrValue = new QAsnAttrValue();
            attrValue.attrID = TEEthQosUtil.getIntParamValue(row.getParam("cospara"));
            attrValue.attrValue = TEEthQosUtil.getIntParamValue(row.getParam("pri"));
            cosIndex.cosAttr.attrList.add((Object)attrValue);
        }
        return errList;
    }

    public static QAsnCOSInfo getQAsnCosInfo(QAsnCOSInfoList cosList, int cosid) {
        int len = cosList.size();
        for (int i = 0; i < len; ++i) {
            QAsnCOSInfo cosInfo = (QAsnCOSInfo)cosList.get(i);
            if (cosInfo.cosIndex.cosID != cosid) continue;
            return cosInfo;
        }
        return null;
    }

    public static Datainterface createQueryInputData(int neID, int slotID, int cosid) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("cosid", String.valueOf(cosid));
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

