/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipqos.QAsnCARIndex;
import com.huawei.network.qasn.m_q_ipqos.QAsnCARIndexList;
import com.huawei.network.qasn.m_q_ipqos.QAsnCARInfo;
import com.huawei.network.qasn.m_q_ipqos.QAsnCARInfoList;
import com.huawei.network.qasn.m_q_ipqos.QAsnGetCARReq;
import com.huawei.network.qasn.m_q_ipqos.QAsnGetCARRsp;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetCarHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        QAsnGetCARReq req = (QAsnGetCARReq)fReq;
        QAsnGetCARRsp rsp = (QAsnGetCARRsp)fRsp;
        QAsnCARIndexList carList = req.carIndexList;
        if (carList.isEmpty()) {
            rsp.result.result = 0;
            e2elogger.info("QAsnGetCARReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        rsp.result.errList = new QAsnErrInfoList();
        int len = carList.size();
        for (int i = 0; i < len; ++i) {
            QAsnCARIndex carIndex = (QAsnCARIndex)carList.get(i);
            int neID = carIndex.neID;
            int slotid = carIndex.slotID;
            QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neID, slotid);
            if (errInfo != null) {
                rsp.result.errList.add((Object)errInfo);
                continue;
            }
            Datainterface inputData = TEGetCarHandler.createQueryInputData(neID, slotid, carIndex.carID);
            Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neID, 2105414, inputData);
            rsp.result.errList.addAll((Collection)TEGetCarHandler.parseOutputData(neID, slotid, outputData, rsp.carList));
        }
        rsp.result.result = rsp.result.errList.isEmpty() ? 0 : (rsp.result.errList.size() >= req.carIndexList.size() ? 1090650122 : 1090650121);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    public static QAsnErrInfoList parseOutputData(int neID, int slotID, Datainterface outputData, QAsnCARInfoList carList) {
        BussinessParams bussiness;
        QAsnErrInfoList errList = new QAsnErrInfoList();
        QAsnErrInfoList errInfoList = TEEthQosUtil.checkOutputData(neID, slotID, outputData);
        if (!errInfoList.isEmpty()) {
            errList.addAll((Collection)errInfoList);
        }
        if ((bussiness = outputData.getBussinessParams()) == null) {
            return errList;
        }
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            QAsnCARInfo carIndex = new QAsnCARInfo();
            carIndex.carIndex.neID = neID;
            carIndex.carIndex.slotID = slotID;
            carIndex.carIndex.carID = TEEthQosUtil.getIntParamValue(row.getParam("carid"));
            carIndex.carAttr.isEnable = TEEthQosUtil.getIntParamValue(row.getParam("status"));
            carIndex.carAttr.cir = TEEthQosUtil.getIntParamValue(row.getParam("cir"));
            carIndex.carAttr.pir = TEEthQosUtil.getIntParamValue(row.getParam("pir"));
            carIndex.carAttr.dcbs = TEEthQosUtil.getIntParamValue(row.getParam("dcbs"));
            carIndex.carAttr.dmbs = TEEthQosUtil.getIntParamValue(row.getParam("dmbs"));
            carList.add((Object)carIndex);
        }
        return errList;
    }

    public static Datainterface createQueryInputData(int neID, int slotID, int carid) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("carid", String.valueOf(carid));
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

