/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_common.QAsnCPIndexList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnNameAndValueString;
import com.huawei.network.qasn.m_q_ipqos.QAsnFlowInfo;
import com.huawei.network.qasn.m_q_ipqos.QAsnFlowInfoList;
import com.huawei.network.qasn.m_q_ipqos.QAsnGetAllFlowReq;
import com.huawei.network.qasn.m_q_ipqos.QAsnGetAllFlowRsp;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetAllFlowHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        QAsnGetAllFlowReq req = (QAsnGetAllFlowReq)fReq;
        QAsnGetAllFlowRsp rsp = (QAsnGetAllFlowRsp)fRsp;
        QAsnCPIndexList cpIndexList = req.cpIndexList;
        if (cpIndexList.isEmpty()) {
            rsp.result.result = 0;
            e2elogger.info("QAsnGetAllFlowReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        rsp.result.errList = new QAsnErrInfoList();
        int len = cpIndexList.size();
        for (int i = 0; i < len; ++i) {
            QAsnCPIndex cpIndex;
            int neID = cpIndex.neID;
            cpIndex = (QAsnCPIndex)cpIndexList.get(i);
            int slotid = TEEthQosUtil.getAsnSlotID(cpIndex);
            QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neID, slotid);
            if (errInfo != null) {
                rsp.result.errList.add((Object)errInfo);
                continue;
            }
            Datainterface inputData = this.createQueryInputData(neID, slotid, 0);
            Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neID, 2105438, inputData);
            rsp.result.errList.addAll((Collection)this.parseOutputData(neID, slotid, outputData, rsp.flowList));
        }
        rsp.result.result = rsp.result.errList.isEmpty() ? 0 : (rsp.result.errList.size() >= req.cpIndexList.size() ? 1090650122 : 1090650121);
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected QAsnErrInfoList parseOutputData(int neID, int slotID, Datainterface outputData, QAsnFlowInfoList flowList) {
        BussinessParams bussiness;
        QAsnErrInfoList errList = new QAsnErrInfoList();
        QAsnErrInfoList errInfoList = TEEthQosUtil.checkOutputData(neID, slotID, outputData);
        if (!errInfoList.isEmpty()) {
            errList.addAll((Collection)errInfoList);
        }
        if ((bussiness = outputData.getBussinessParams()) == null) {
            return errList;
        }
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            QAsnFlowInfo asnFlow = new QAsnFlowInfo();
            asnFlow.flowIndex.neID = neID;
            asnFlow.flowIndex.slotID = slotID;
            asnFlow.flowIndex.flowID = TEEthQosUtil.getIntParamValue(row.getParam("flowid"));
            asnFlow.flowAttr.flowType = TEEthQosUtil.getIntParamValue(row.getParam("flowtype"));
            asnFlow.flowAttr.portID = TEEthServiceOAMUtil.convertPortIDNE2E2E(TEEthQosUtil.getIntParamValue(row.getParam("portid")));
            asnFlow.flowAttr.portType = TEEthServiceOAMUtil.getPortType(TEEthQosUtil.getIntParamValue(row.getParam("portid")));
            asnFlow.flowAttr.vlanID = TEEthQosUtil.getIntParamValue(row.getParam("vlanid"));
            asnFlow.flowAttr.svlanID = TEEthQosUtil.getIntParamValue(row.getParam("svlanid"));
            asnFlow.flowAttr.vbID = TEEthQosUtil.getIntParamValue(row.getParam("vbid"));
            asnFlow.flowAttr.priority = TEEthQosUtil.getIntParamValue(row.getParam("priority"));
            asnFlow.flowAttr.cosID = TEEthQosUtil.getIntParamValue(row.getParam("boundCoS"));
            asnFlow.flowAttr.carID = TEEthQosUtil.getIntParamValue(row.getParam("boundCAR"));
            asnFlow.flowAttr.flowshapingID = TEEthQosUtil.getIntParamValue(row.getParam("boundShaping"));
            QAsnNVSList poExAttrList = new QAsnNVSList();
            QAsnNameAndValueString nameValue = new QAsnNameAndValueString();
            nameValue.name = "label".getBytes();
            if (row.getParam("label") != null) {
                nameValue.value = row.getParam("label").getValue().getBytes();
                poExAttrList.addElement((Object)nameValue);
            }
            nameValue = new QAsnNameAndValueString();
            nameValue.name = "exp".getBytes();
            if (row.getParam("exp") != null) {
                nameValue.value = row.getParam("exp").getValue().getBytes();
                poExAttrList.addElement((Object)nameValue);
            }
            asnFlow.flowAttr.poExAttrList = poExAttrList;
            flowList.add((Object)asnFlow);
        }
        return errList;
    }

    protected Datainterface createQueryInputData(int neID, int slotID, int flowid) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("flowid", String.valueOf(flowid));
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

