/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnNameAndValueString;
import com.huawei.network.qasn.m_q_ipqos.QAsnCreateFlowReq;
import com.huawei.network.qasn.m_q_ipqos.QAsnCreateFlowRsp;
import com.huawei.network.qasn.m_q_ipqos.QAsnFlowAttr;
import com.huawei.network.qasn.m_q_ipqos.QAsnFlowIndex;
import com.huawei.network.qasn.m_q_ipqos.QAsnFlowInfo;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TECreateFlowHandler
extends TEWNEMgrHandler {
    private static final int MODIFY_CAR_TYPE = 1;
    private static final int MODIFY_COS_TYPE = 2;
    private static final int MODIFY_SHAPING_TYPE = 3;
    private static final int FLOW_TYPE_PORTSVLAN = 3;
    private static final int FLOW_TYPE_PORTCSVLAN = 4;
    private static final int FLOW_TYPE_PORTSVLANPRI = 8;
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        QAsnCreateFlowReq req = (QAsnCreateFlowReq)fReq;
        QAsnCreateFlowRsp rsp = (QAsnCreateFlowRsp)fRsp;
        if (req.cpIndex == null || req.flowAttr == null) {
            rsp.result.result = 0;
            e2elogger.info("QAsnCreateFlowReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        rsp.result.errList = new QAsnErrInfoList();
        int neid = req.cpIndex.neID;
        int slotid = TEEthQosUtil.getAsnSlotID(req.cpIndex);
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotid);
        if (errInfo != null) {
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int flowid = this.getAvailableFlowID(neid, slotid);
        rsp.flowInfo = new QAsnFlowInfo();
        rsp.flowInfo.flowIndex.neID = neid;
        rsp.flowInfo.flowIndex.slotID = slotid;
        rsp.flowInfo.flowIndex.flowID = flowid;
        rsp.flowInfo.flowAttr = req.flowAttr;
        Datainterface inputData = this.createInputData(neid, slotid, flowid, req.flowAttr);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(req.cpIndex.neID, 2105422, inputData);
        QAsnErrInfoList asnErrList = TEEthQosUtil.checkOutputData(neid, slotid, outputData);
        if (!asnErrList.isEmpty()) {
            rsp.result.errList.addAll((Collection)asnErrList);
            rsp.result.result = 1090650122;
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        inputData = this.createModifyInputData(rsp.flowInfo.flowIndex, req.flowAttr);
        if (inputData.getBussinessParams().getRowParamsCount() > 0 && !(asnErrList = TEEthQosUtil.checkOutputData(neid, slotid, outputData = TEEthServiceOAMUtil.performSubFunc(req.cpIndex.neID, 2105439, inputData))).isEmpty()) {
            rsp.result.errList.addAll((Collection)asnErrList);
            rsp.result.result = 1090650122;
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        rsp.result.result = 0;
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    protected Datainterface createModifyInputData(QAsnFlowIndex flowIndex, QAsnFlowAttr flowAttr) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        if (flowAttr.carID != -1) {
            rowparams = this.createModifyRow(flowIndex, 1, flowAttr.carID);
            bussiness.addRowParams(rowparams);
        }
        if (flowAttr.cosID != -1) {
            rowparams = this.createModifyRow(flowIndex, 2, flowAttr.cosID);
            bussiness.addRowParams(rowparams);
        }
        if (flowAttr.flowshapingID != -1) {
            rowparams = this.createModifyRow(flowIndex, 3, flowAttr.flowshapingID);
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }

    protected RowParams createModifyRow(QAsnFlowIndex flowIndex, int costype, int paraid) {
        RowParams rowparams = new RowParams();
        rowparams.addParam("neid", String.valueOf(flowIndex.neID));
        rowparams.addParam("slotid", String.valueOf(flowIndex.slotID));
        rowparams.addParam("flowid", String.valueOf(flowIndex.flowID));
        rowparams.addParam("qostype", String.valueOf(costype));
        rowparams.addParam("paraid", String.valueOf(paraid));
        rowparams.addParam("isLogFlag", "0");
        return rowparams;
    }

    protected Datainterface createInputData(int neid, int slotid, int flowid, QAsnFlowAttr flowAttr) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        rowparams.addParam("neid", String.valueOf(neid));
        rowparams.addParam("slotid", String.valueOf(slotid));
        rowparams.addParam("flowid", String.valueOf(flowid));
        rowparams.addParam("flowType", String.valueOf(flowAttr.flowType));
        int port = TEEthServiceOAMUtil.convertPortIDE2E2NE(flowAttr.portID, flowAttr.portType);
        rowparams.addParam("portid", String.valueOf(port));
        rowparams.addParam("pri", String.valueOf(flowAttr.priority));
        if (flowAttr.poExAttrList != null) {
            Enumeration e = flowAttr.poExAttrList.elements();
            while (e.hasMoreElements()) {
                String value;
                QAsnNameAndValueString nameandvalue = (QAsnNameAndValueString)e.nextElement();
                String name = new String(nameandvalue.name);
                if (name.equals("label")) {
                    value = new String(nameandvalue.value);
                    rowparams.addParam("label", value);
                    continue;
                }
                if (!name.equals("exp")) continue;
                value = new String(nameandvalue.value);
                rowparams.addParam("exp", value);
            }
        }
        if (flowAttr.vlanID != -1) {
            if (flowAttr.flowType == 3 || flowAttr.flowType == 4 || flowAttr.flowType == 8) {
                rowparams.addParam("cvlanid", String.valueOf(flowAttr.vlanID));
            } else {
                rowparams.addParam("vlanID", String.valueOf(flowAttr.vlanID));
            }
        } else if (flowAttr.flowType == 8) {
            rowparams.addParam("cvlanid", "65535");
        }
        if (flowAttr.svlanID != -1) {
            rowparams.addParam("svlanid", String.valueOf(flowAttr.svlanID));
        }
        if (!flowAttr.cvlanIDs.isEmpty()) {
            rowparams.addParam("cvlanid", String.valueOf(flowAttr.cvlanIDs.get(0)));
        }
        rowparams.addParam("isLogFlag", "0");
        return inputData;
    }

    protected int getAvailableFlowID(int neid, int slotid) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        this.appendQueryFlowOper(neid, slotid, operList, "NSCMD_ETHN_GET_PORTFLOW");
        this.appendQueryFlowOper(neid, slotid, operList, "NSCMD_ETHN_GET_PORTVLANFLOW");
        this.appendQueryFlowOper(neid, slotid, operList, "NSCMD_ETHN_GET_PORTSVLANFLOW");
        this.appendQueryFlowOper(neid, slotid, operList, "NSCMD_ETHN_GET_PORTCSVLANFLOW");
        this.appendQueryFlowOper(neid, slotid, operList, "NSCMD_ETHN_GET_PORTVLANPRIFLOW");
        this.appendQueryFlowOper(neid, slotid, operList, "NSCMD_ETHN_GET_LABELFLOW_EX");
        this.appendQueryFlowOper(neid, slotid, operList, "NSCMD_ETHN_GET_LABELEXPFLOW_EX");
        this.appendQueryFlowOper(neid, slotid, operList, "NSCMD_ETHN_GET_PORTCSVLANPRIFLOW_EX");
        return TEEthQosUtil.getAvailableID(neid, slotid, 2, operList, "flowid");
    }

    protected void appendQueryFlowOper(int neid, int slotid, List<Operation> operList, String operName) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)operName);
        if (null != oper) {
            oper.getInput().setPartValue("slotid", String.valueOf(slotid));
            oper.getInput().setPartValue("flowid", "0");
            operList.add(oper);
        }
    }
}

