/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipbase.QAsnAttrValue;
import com.huawei.network.qasn.m_q_ipbase.QAsnAttrValueList;
import com.huawei.network.qasn.m_q_ipqos.QAsnCOSAttr;
import com.huawei.network.qasn.m_q_ipqos.QAsnCOSInfo;
import com.huawei.network.qasn.m_q_ipqos.QAsnCOSInfoList;
import com.huawei.network.qasn.m_q_ipqos.QAsnCreateCOSReq;
import com.huawei.network.qasn.m_q_ipqos.QAsnCreateCOSRsp;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEGetCosHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TECreateCosHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        QAsnCreateCOSReq req = (QAsnCreateCOSReq)fReq;
        QAsnCreateCOSRsp rsp = (QAsnCreateCOSRsp)fRsp;
        if (req.cpIndex == null || req.cosAttr == null) {
            rsp.result.isSuccess = true;
            rsp.result.retCode = 0;
            e2elogger.info("QAsnCreateCARReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int neid = req.cpIndex.neID;
        int slotid = TEEthQosUtil.getAsnSlotID(req.cpIndex);
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotid);
        if (errInfo != null) {
            rsp.result.retCode = errInfo.errCode;
            rsp.result.isSuccess = false;
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int cosid = this.getExistCos(neid, slotid, req);
        rsp.cosInfo.cosAttr = req.cosAttr;
        rsp.cosInfo.cosIndex.neID = neid;
        rsp.cosInfo.cosIndex.slotID = slotid;
        rsp.cosInfo.cosIndex.cosID = cosid;
        if (cosid == -1) {
            rsp.cosInfo.cosIndex.cosID = cosid = this.getAvailableCosID(neid, slotid);
            Datainterface inputData = this.createInputData(neid, slotid, cosid, req.cosAttr);
            Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(req.cpIndex.neID, 2105417, inputData);
            QAsnErrInfoList asnErrList = TEEthQosUtil.checkOutputData(neid, slotid, outputData);
            if (!asnErrList.isEmpty()) {
                rsp.result.retCode = ((QAsnErrInfo)asnErrList.get((int)0)).errCode;
                rsp.result.isSuccess = false;
                e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
                return 0;
            }
        }
        rsp.result.retCode = 0;
        rsp.result.isSuccess = true;
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private int getExistCos(int neid, int slotid, QAsnCreateCOSReq req) {
        Datainterface inputData = TEGetCosHandler.createQueryInputData(neid, slotid, 0);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neid, 2105419, inputData);
        QAsnCOSInfoList cosInfoList = new QAsnCOSInfoList();
        TEGetCosHandler.parseOutputData(neid, slotid, outputData, cosInfoList);
        int result = -1;
        int len = cosInfoList.size();
        for (int i = 0; i < len; ++i) {
            QAsnCOSInfo cosInfo = (QAsnCOSInfo)cosInfoList.get(i);
            if (cosInfo.cosAttr.costype != req.cosAttr.costype || cosInfo.cosAttr.costype == 1 && cosInfo.cosAttr.simplePri != req.cosAttr.simplePri || cosInfo.cosAttr.attrList.size() != req.cosAttr.attrList.size() || !this.isEqualQAsnAttrValueList(cosInfo.cosAttr.attrList, req.cosAttr.attrList)) continue;
            result = cosInfo.cosIndex.cosID;
            break;
        }
        return result;
    }

    private boolean isEqualQAsnAttrValueList(QAsnAttrValueList list1, QAsnAttrValueList list2) {
        int len = list1.size();
        for (int i = 0; i < len; ++i) {
            QAsnAttrValue asnAttr1 = (QAsnAttrValue)list1.get(i);
            boolean isExist = false;
            int lenj = list2.size();
            for (int j = 0; j < lenj; ++j) {
                QAsnAttrValue asnAttr2 = (QAsnAttrValue)list2.get(j);
                if (asnAttr1.attrID != asnAttr2.attrID || asnAttr1.attrValue != asnAttr2.attrValue) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            return false;
        }
        return true;
    }

    protected Datainterface createInputData(int neid, int slotid, int cosid, QAsnCOSAttr cosAttr) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        rowparams.addParam("neid", String.valueOf(neid));
        rowparams.addParam("slotid", String.valueOf(slotid));
        rowparams.addParam("cosid", String.valueOf(cosid));
        rowparams.addParam("costype", String.valueOf(cosAttr.costype));
        rowparams.addParam("isLogFlag", "0");
        if (cosAttr.costype == 1) {
            rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(neid));
            rowparams.addParam("slotid", String.valueOf(slotid));
            rowparams.addParam("cosid", String.valueOf(cosid));
            rowparams.addParam("pri", String.valueOf(cosAttr.simplePri));
            bussiness.addRowParams(rowparams);
        } else {
            int len = cosAttr.attrList.size();
            for (int i = 0; i < len; ++i) {
                QAsnAttrValue attrValue = (QAsnAttrValue)cosAttr.attrList.get(i);
                rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("slotid", String.valueOf(slotid));
                rowparams.addParam("cosid", String.valueOf(cosid));
                rowparams.addParam("cospara", String.valueOf(attrValue.attrID));
                rowparams.addParam("pri", String.valueOf(attrValue.attrValue));
                bussiness.addRowParams(rowparams);
            }
        }
        return inputData;
    }

    protected int getAvailableCosID(int neid, int slotid) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        this.appendQueryCosOper(neid, slotid, operList, "NSCMD_ETHN_GET_COS");
        return TEEthQosUtil.getAvailableID(neid, slotid, 3, operList, "cosid");
    }

    protected void appendQueryCosOper(int neid, int slotid, List<Operation> operList, String operName) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)operName);
        if (null != oper) {
            oper.getInput().setPartValue("slotid", String.valueOf(slotid));
            oper.getInput().setPartValue("cosid", "0");
            operList.add(oper);
        }
    }
}

