/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipqos.QAsnCARAttr;
import com.huawei.network.qasn.m_q_ipqos.QAsnCARInfo;
import com.huawei.network.qasn.m_q_ipqos.QAsnCARInfoList;
import com.huawei.network.qasn.m_q_ipqos.QAsnCreateCARReq;
import com.huawei.network.qasn.m_q_ipqos.QAsnCreateCARRsp;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEEthQosUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.qos.TEGetCarHandler;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TECreateCarHandler
extends TEWNEMgrHandler {
    protected static final Logger e2elogger = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct fReq, FStruct fRsp, TaskMgr tm) {
        e2elogger.info(TEAsn1Util.getAsn1String((Object)fReq));
        QAsnCreateCARReq req = (QAsnCreateCARReq)fReq;
        QAsnCreateCARRsp rsp = (QAsnCreateCARRsp)fRsp;
        if (req.cpIndex == null || req.carAttr == null) {
            rsp.result.isSuccess = true;
            rsp.result.retCode = 0;
            e2elogger.info("QAsnCreateCARReq req is null!");
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int neid = req.cpIndex.neID;
        int slotid = TEEthQosUtil.getAsnSlotID(req.cpIndex);
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotid);
        if (errInfo != null) {
            rsp.result.retCode = errInfo.errCode;
            rsp.result.isSuccess = false;
            e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            return 0;
        }
        int carid = this.getExistCar(neid, slotid, req);
        rsp.carInfo.carIndex.neID = neid;
        rsp.carInfo.carIndex.slotID = slotid;
        rsp.carInfo.carIndex.carID = carid;
        rsp.carInfo.carAttr = req.carAttr;
        if (carid == -1) {
            rsp.carInfo.carIndex.carID = carid = this.getAvailableCarID(neid, slotid);
            Datainterface inputData = this.createInputData(neid, slotid, carid, req.carAttr);
            Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(req.cpIndex.neID, 0x202044, inputData);
            QAsnErrInfoList asnErrList = TEEthQosUtil.checkOutputData(neid, slotid, outputData);
            if (!asnErrList.isEmpty()) {
                rsp.result.retCode = ((QAsnErrInfo)asnErrList.get((int)0)).errCode;
                rsp.result.isSuccess = false;
                e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
                return 0;
            }
        }
        rsp.result.retCode = 0;
        rsp.result.isSuccess = true;
        e2elogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        return 0;
    }

    private int getExistCar(int neid, int slotid, QAsnCreateCARReq req) {
        Datainterface inputData = TEGetCarHandler.createQueryInputData(neid, slotid, 0);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neid, 2105414, inputData);
        QAsnCARInfoList carInfoList = new QAsnCARInfoList();
        TEGetCarHandler.parseOutputData(neid, slotid, outputData, carInfoList);
        int result = -1;
        int len = carInfoList.size();
        for (int i = 0; i < len; ++i) {
            QAsnCARInfo carInfo = (QAsnCARInfo)carInfoList.get(i);
            if (carInfo.carAttr.cir != req.carAttr.cir || carInfo.carAttr.dcbs != req.carAttr.dcbs || carInfo.carAttr.dmbs != req.carAttr.dmbs || carInfo.carAttr.isEnable != req.carAttr.isEnable || carInfo.carAttr.pir != req.carAttr.pir) continue;
            result = carInfo.carIndex.carID;
            break;
        }
        return result;
    }

    protected Datainterface createInputData(int neid, int slotid, int carid, QAsnCARAttr carAttr) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        rowparams.addParam("neid", String.valueOf(neid));
        rowparams.addParam("slotid", String.valueOf(slotid));
        rowparams.addParam("carid", String.valueOf(carid));
        rowparams.addParam("status", String.valueOf(carAttr.isEnable));
        rowparams.addParam("cir", String.valueOf(carAttr.cir));
        rowparams.addParam("dcbs", String.valueOf(carAttr.dcbs));
        rowparams.addParam("pir", String.valueOf(carAttr.pir));
        rowparams.addParam("dmbs", String.valueOf(carAttr.dmbs));
        rowparams.addParam("isLogFlag", "0");
        return inputData;
    }

    protected int getAvailableCarID(int neid, int slotid) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        this.appendQueryCarOper(neid, slotid, operList, "NSCMD_ETHN_GET_CAR_PARA");
        return TEEthQosUtil.getAvailableID(neid, slotid, 4, operList, "carid");
    }

    protected void appendQueryCarOper(int neid, int slotid, List<Operation> operList, String operName) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)operName);
        if (null != oper) {
            oper.getInput().setPartValue("slotid", String.valueOf(slotid));
            oper.getInput().setPartValue("carid", "0");
            operList.add(oper);
        }
    }
}

