/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ip_8021ag_model.QAsnEthOamPort;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnGetEthPortReq;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnGetEthPortRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.fdn.FDNUtil;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetEthPortHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnGetEthPortReq begin.");
        QAsnGetEthPortReq req = (QAsnGetEthPortReq)qReq;
        QAsnGetEthPortRsp rsp = (QAsnGetEthPortRsp)qRsp;
        int neid = req.portIndex.neID;
        String fdnStr = TEEthServiceOAMUtil.getStr(req.portIndex.strFDN);
        int shelfID = FDNUtil.getFrameID((String)fdnStr);
        int slotID = FDNUtil.getSlotID((String)fdnStr);
        int portID = FDNUtil.getPortID((String)fdnStr);
        slotID = TEBoardUtil.neToSlotIDNM((int)shelfID, (int)slotID);
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotID);
        if (errInfo != null) {
            rsp.oReturn.result = errInfo.errCode;
            return 0;
        }
        Datainterface inputData = TEGetEthPortHandler.createQueryEthPortInputData(neid, slotID, portID);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neid, 999979, inputData);
        BussinessParams bussiness = outputData.getBussinessParams();
        QAsnEthOamPort ethOamPort = null;
        QAsnErrInfoList errInfoList = new QAsnErrInfoList();
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) {
                errInfoList.add((Object)TEEthServiceOAMUtil.convertErrorRow2AsnErrInfo(row.getRowErrors(0)));
                continue;
            }
            ethOamPort = new QAsnEthOamPort();
            ethOamPort.portIndex = TEEthServiceOAMUtil.cloneAsnUniResID(req.portIndex);
            ethOamPort.oamEnabled = TEEthServiceOAMUtil.convertPMEnableNE2NBI(TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("oamenable"))).intValue();
            ethOamPort.alarmEnabled = TEEthServiceOAMUtil.convertPMEnableNE2NBI(TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("eventsupport"))).intValue();
            ethOamPort.oamWorkMode = TEEthServiceOAMUtil.convertPMModeNE2NBI(TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("oamworktype"))).intValue();
            ethOamPort.remoteLBEnabled = TEEthServiceOAMUtil.convertPMEnableNE2NBI(TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("remoteresponse"))).intValue();
            ethOamPort.poPduMaxSize = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("maxlength")).intValue();
            ethOamPort.poLookbackStatus = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("circlestate")).intValue();
            ethOamPort.poTriggerIfDownStatus = TEEthServiceOAMUtil.convertPMEnableNE2NBI(TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("portBlock"))).intValue();
            ethOamPort.poLoopDetectStatus = TEEthServiceOAMUtil.convertPMEnableNE2NBI(TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("portEnable"))).intValue();
            rsp.oamPortList.add((Object)ethOamPort);
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        rsp.oReturn.result = 0 == errorCode ? 0 : (1 == errorCode ? 1090600984 : 1090646033);
        if (!errInfoList.isEmpty()) {
            rsp.oReturn.errList = errInfoList;
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnGetEthPortReq end.");
        return 0;
    }

    protected static Datainterface createQueryEthPortInputData(int neID, int slotID, int portid) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("port", String.valueOf(portid));
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

