/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ip_8021ag_model.QAsnEthOamInfo;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnGetEthOAMReq;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnGetEthOAMRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.fdn.FDNUtil;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetEthOAMHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnGetEthOAMReq begin.");
        QAsnGetEthOAMReq req = (QAsnGetEthOAMReq)qReq;
        QAsnGetEthOAMRsp rsp = (QAsnGetEthOAMRsp)qRsp;
        int neid = req.portIndex.neID;
        String fdnStr = TEEthServiceOAMUtil.getStr(req.portIndex.strFDN);
        int shelfID = FDNUtil.getFrameID((String)fdnStr);
        int slotID = FDNUtil.getSlotID((String)fdnStr);
        int portID = FDNUtil.getPortID((String)fdnStr);
        slotID = TEBoardUtil.neToSlotIDNM((int)shelfID, (int)slotID);
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotID);
        if (errInfo != null) {
            rsp.oReturn.result = errInfo.errCode;
            return 0;
        }
        Datainterface inputData = TEGetEthOAMHandler.createQueryEthOAMInputData(neid, slotID, portID);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neid, 2143036, inputData);
        BussinessParams bussiness = outputData.getBussinessParams();
        QAsnEthOamInfo ethOam = null;
        QAsnErrInfoList errInfoList = new QAsnErrInfoList();
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) {
                errInfoList.add((Object)TEEthServiceOAMUtil.convertErrorRow2AsnErrInfo(row.getRowErrors(0)));
                continue;
            }
            ethOam = new QAsnEthOamInfo();
            ethOam.portIndex = TEEthServiceOAMUtil.cloneAsnUniResID(req.portIndex);
            ethOam.errorFrameMonitorWindow = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("errormonitor")).intValue();
            ethOam.errorFrameMonitorThreshold = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("errormonitorrange")).intValue();
            ethOam.errorFramePeriodWindow = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("errormonitorperiod")).intValue();
            ethOam.errorFramePeriodThreshold = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("errormonitorperiodrange")).intValue();
            ethOam.errorFrameSecondWindow = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("errormonitorsecond")).intValue();
            ethOam.errorFrameSecondThreshold = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("errormonitorsecondrange")).intValue();
            rsp.oamInfoList.add((Object)ethOam);
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        rsp.oReturn.result = 0 == errorCode ? 0 : (1 == errorCode ? 1090600984 : 1090646033);
        if (!errInfoList.isEmpty()) {
            rsp.oReturn.errList = errInfoList;
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnGetEthOAMReq end.");
        return 0;
    }

    protected static Datainterface createQueryEthOAMInputData(int neID, int slotID, int portid) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("port", String.valueOf(portid));
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

