/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ipoam.QAsnEthermpID;
import com.huawei.network.qasn.m_q_ipoam.QAsnEthermpIDList;
import com.huawei.network.qasn.m_q_ipoam.QAsnEvtPFMtestOverTimeNtf;
import com.huawei.network.qasn.m_q_ipoam.QAsnEvtPFMtestRspNtf;
import com.huawei.network.qasn.m_q_ipoam.QAsnEvtPFMtestStatisticsNft;
import com.huawei.network.qasn.m_q_ipoam.QAsnEvtPingOverTimeNft;
import com.huawei.network.qasn.m_q_ipoam.QAsnEvtPingRspNft;
import com.huawei.network.qasn.m_q_ipoam.QAsnEvtPingStatisticsNft;
import com.huawei.network.qasn.m_q_ipoam.QFAsnMPInfo;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgNEInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.jni.AsnJNIAllocMPIDReq;
import com.huawei.nglct.jni.AsnJNIAllocMPIDRsp;
import com.huawei.nglct.jni.AsnJNIGetAllMPIDReq;
import com.huawei.nglct.jni.AsnJNIGetAllMPIDRsp;
import com.huawei.nglct.jni.TEJNIFacadeUtil;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEthOAMMPContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherOAMMPMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEEthServiceOAMUtil {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();
    private static final int PORTTYPE_SPLIT = 32768;
    private static final int PORTTYPE_VCTRUNK = 1;
    private static final int PORTTYPE_IP = 0;
    public static final int CLEAR_ALL = 0;
    public static final int CLEAR_MP = 1;
    public static final int CLEAR_MD = 2;
    public static final int CLEAR_MA = 3;
    private static final int GET_DATA_FROM_NE = 1;
    public static final int INVALID_VALUE = -1;
    public static final int NBI_ENABLED = 1;
    public static final int NBI_DISABLED = 2;
    public static final int NE_ENABLED = 1;
    public static final int NE_DISABLED = 0;
    public static int NBI_PASSIVITY_MODE = 2;
    public static int NBI_INITIATIVE_MODE = 1;
    public static int NE_PASSIVITY_MODE = 1;
    public static int NE_INITIATIVE_MODE = 2;
    public static int SERVICE_TYPE_ELAN = 1;
    public static int SERVICE_TYPE_ELINE = 1;

    private TEEthServiceOAMUtil() {
    }

    public static int getPortType(int portid) {
        return portid > 32768 ? 1 : 0;
    }

    public static int convertPortIDE2E2NE(int portid, int portType) {
        int portID;
        switch (portType) {
            case 1: {
                portID = 32768 + portid;
                break;
            }
            default: {
                portID = portid;
            }
        }
        return portID;
    }

    public static int convertPortIDNE2E2E(int portid) {
        return portid > 32768 ? portid - 32768 : portid;
    }

    public static TEEthOAMMPContainer getContainer(int neID, int slotID) {
        TEEthOAMMPContainer container = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotID}, TEEthOAMMPContainer.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotID}, TEEthOAMMPContainer.class);
            if (null == dbResult) {
                String tipStr = "Get EthServiceOAM container fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                E2ELOGGER.error(tipStr);
                return container;
            }
        }
        catch (Exception e) {
            String tipStr = "Get EthServiceOAM container fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            E2ELOGGER.error(tipStr, (Throwable)e);
            return container;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                container = (TEEthOAMMPContainer)data.get(0);
            }
        } else {
            String tipStr = "Get EthServiceOAM container fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
            E2ELOGGER.error(tipStr);
        }
        E2ELOGGER.info("get EthServiceOAM container from db end.");
        return container;
    }

    public static TEEtherOAMMPMOPO getEtherOAMMP(TEEthOAMMPContainer oamContainer, String mpID) {
        Set mpList = oamContainer.getOAMMPList();
        Iterator mpIterator = mpList.iterator();
        TEEtherOAMMPMOPO mpMOPO = null;
        TEEtherOAMMPMOPO mpMOPOTmp = null;
        while (mpIterator.hasNext()) {
            mpMOPOTmp = (TEEtherOAMMPMOPO)mpIterator.next();
            if (!mpMOPOTmp.getMPID().equals(mpID)) continue;
            mpMOPO = mpMOPOTmp;
            break;
        }
        return mpMOPO;
    }

    public static void cleanContainer(TEEthOAMMPContainer container, int clearType) {
        if (container != null) {
            if (clearType == 1 || clearType == 0) {
                container.getOAMMPList().clear();
            }
            if (clearType == 2 || clearType == 0) {
                container.getOAMMDList().clear();
            }
            if (clearType == 3 || clearType == 0) {
                container.getOAMMAList().clear();
            }
        }
    }

    public static int saveContainerToDB(int neID, int slotID, TEEthOAMMPContainer container) {
        if (null == container) {
            String tipStr = "The container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            E2ELOGGER.info(tipStr);
            return 0;
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID, slotID}, (Object)container) : TECommonDaoService.update_NonLock((int[])new int[]{neID, slotID}, (Object)container);
            if (null == dbResult) {
                String tipStr = "Save EthServiceOAM result fail! The dbResult is null! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                E2ELOGGER.error(tipStr);
                return 1092743443;
            }
        }
        catch (Exception e) {
            E2ELOGGER.error("Save EthServiceOAM result fail!", (Throwable)e);
            return 2;
        }
        int retCode = dbResult.getResult();
        String tipStr = "Save EthServiceOAM result. ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
        E2ELOGGER.error(tipStr);
        E2ELOGGER.info("save evpl container to db end.");
        return retCode;
    }

    public static List<String> getDeleteSuccessID(String idName, Datainterface inputData, Datainterface outputData) {
        ArrayList<String> errorIDList = new ArrayList<String>();
        ArrayList<String> deleteIDList = new ArrayList<String>();
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (errorCode == 2) {
            E2ELOGGER.error("Delete " + idName + "fail and not save data to DB");
            return deleteIDList;
        }
        if (errorCode == 1) {
            BussinessParams outBusinessparams = outputData.getBussinessParams();
            int errorRowLen = outBusinessparams.getRowParamsCount();
            for (int errorRow = 0; errorRow < errorRowLen; ++errorRow) {
                RowErrors[] rowErrors;
                for (RowErrors rowError : rowErrors = outputData.getBussinessParams().getRowParams(errorRow).getRowErrors()) {
                    if (rowError.getParam(idName) == null) continue;
                    errorIDList.add(rowError.getParam(idName).getValue());
                }
            }
        }
        BussinessParams businessparams = inputData.getBussinessParams();
        String id = "";
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            RowParams rowparams = businessparams.getRowParams(row);
            id = rowparams.getParam(idName).getValue();
            if (errorIDList.contains(id)) continue;
            deleteIDList.add(id);
        }
        return deleteIDList;
    }

    public static QAsnErrInfo qInterfaceErrorCheck(int neID, int slotID) {
        QAsnErrInfo errInfo = null;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        int[] objs = new int[]{neID};
        if (null == ne) {
            errInfo = TEEthServiceOAMUtil.getQAsnErrInfo(objs, 1090596385);
            return errInfo;
        }
        TEBoard board = ne.getBoard(slotID);
        if (null == board) {
            errInfo = TEEthServiceOAMUtil.getQAsnErrInfo(objs, 1090646021);
            errInfo.objID.add((Object)slotID);
            return errInfo;
        }
        int result = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (result != 0) {
            errInfo = TEEthServiceOAMUtil.getQAsnErrInfo(objs, result);
            return errInfo;
        }
        return errInfo;
    }

    public static QAsnErrInfo getQAsnErrInfo(int[] objs, int retCode) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.errCode = retCode;
        errInfo.objID = new QAsnTinyIntList();
        int len = objs.length;
        for (int i = 0; i < len; ++i) {
            errInfo.objID.add((Object)objs[i]);
        }
        return errInfo;
    }

    public static QAsnErrInfo convertErrorRow2AsnErrInfo(RowErrors errors) {
        int[] objs = new int[]{Integer.parseInt(errors.getParam("neid").getValue())};
        int errorCode = Integer.parseInt(errors.getErrorMessage().getErrorcode());
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.getQAsnErrInfo(objs, errorCode);
        if (errors.getParam("slotid") != null && !"".equals(errors.getParam("slotid"))) {
            errInfo.objID.add((Object)Integer.parseInt(errors.getParam("slotid").getValue()));
        }
        if (errors.getParam("port") != null && !"".equals(errors.getParam("port"))) {
            errInfo.objID.add((Object)Integer.parseInt(errors.getParam("port").getValue()));
        }
        return errInfo;
    }

    public static boolean checkOutputSuccess(int neID, Datainterface inputData, Datainterface outputData, String errorMsg) {
        String errorCode = outputData.getErrorMessage().getErrorcode();
        int slotID = 0;
        if (inputData.getBussinessParams().getRowParams(0).getParam("slotid") != null) {
            slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        }
        if (!errorCode.equals(String.valueOf(0))) {
            String tipStr = "perform " + errorMsg + " is fail and not save data to DB! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            E2ELOGGER.info(tipStr);
            return false;
        }
        return true;
    }

    public static Datainterface performSubFunc(int neID, int sfid, Datainterface inputData) {
        Datainterface allData = null;
        try {
            SubFunc subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
            if (null == subFunc && null == (subFunc = TECreateObjectFactory.getSubFunc((int)sfid))) {
                E2ELOGGER.info("Don't found subfunction(sfid = " + sfid + ") description in Functions description file\u00a3\u00a1");
                return null;
            }
            Datainterface memeryData = new Datainterface();
            allData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess((int)neID, (SubFunc)subFunc, (Datainterface)inputData, (Datainterface)memeryData, null, null, (int)1);
        }
        catch (Exception e) {
            E2ELOGGER.error("The set LMSP ProtocolType from weblct exception " + neID, (Throwable)e);
            allData = new Datainterface();
            allData.setBussinessParams(new BussinessParams());
            allData.setErrorMessage(new ErrorMessage());
            allData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)1090646019));
        }
        return allData;
    }

    public static Map<String, List<String>> getModifyOAMMPErrorParamNames(Datainterface outputData) {
        HashMap<String, List<String>> errorMPIDToObjMap = new HashMap<String, List<String>>();
        BussinessParams outBusinessparams = outputData.getBussinessParams();
        int errorRowLen = outBusinessparams.getRowParamsCount();
        for (int errorRow = 0; errorRow < errorRowLen; ++errorRow) {
            RowErrors[] rowErrors;
            for (RowErrors rowError : rowErrors = outputData.getBussinessParams().getRowParams(errorRow).getRowErrors()) {
                String mpID = rowError.getParam("mpid").getValue();
                ArrayList<String> list = (ArrayList<String>)errorMPIDToObjMap.get(mpID);
                if (list == null) {
                    list = new ArrayList<String>();
                    errorMPIDToObjMap.put(mpID, list);
                }
                int size = rowError.getParamCount();
                for (int i = 0; i < size; ++i) {
                    Param rowParam = rowError.getParam(i);
                    list.add(rowParam.getName());
                }
            }
        }
        return errorMPIDToObjMap;
    }

    protected static Datainterface createQueryOAMMPInputData(int neID, int slotID) {
        Datainterface inputData = TEEthServiceOAMUtil.createQueryOAMMDMAInputData(neID, slotID);
        Param param = new Param("mpid", "0");
        inputData.getBussinessParams().getRowParams(0).addParam(param);
        return inputData;
    }

    protected static Datainterface createQueryOAMMDMAInputData(int neID, int slotID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }

    public static int getOAMFromNEAndSaveTODB(int neID, int slotID) {
        int errorCode = -1;
        Datainterface inputData = TEEthServiceOAMUtil.createQueryOAMMDMAInputData(neID, slotID);
        Datainterface outputDataMDMA = TEEthServiceOAMUtil.performSubFunc(neID, 2106289, inputData);
        if (outputDataMDMA == null) {
            return errorCode;
        }
        errorCode = Integer.parseInt(outputDataMDMA.getErrorMessage().getErrorcode());
        if (0 != errorCode) {
            String tipStr = "Query EthServiceOAMMDMA from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errorCode);
            E2ELOGGER.error(tipStr);
        } else {
            inputData = TEEthServiceOAMUtil.createQueryOAMMPInputData(neID, slotID);
            Datainterface outputDataMP = TEEthServiceOAMUtil.performSubFunc(neID, 2105654, inputData);
            errorCode = Integer.parseInt(outputDataMP.getErrorMessage().getErrorcode());
            if (0 != errorCode) {
                String tipStr = "Query EthServiceOAMMP from ne fail! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errorCode);
                E2ELOGGER.error(tipStr);
            }
        }
        return errorCode;
    }

    public static boolean isBoardSupportEthServiceOAM(int boardType) {
        ArrayList<Integer> ethBoardTypeList = new ArrayList<Integer>();
        ethBoardTypeList.add(1067);
        ethBoardTypeList.add(1557);
        ethBoardTypeList.add(2109);
        ethBoardTypeList.add(2110);
        ethBoardTypeList.add(2217);
        ethBoardTypeList.add(2272);
        ethBoardTypeList.add(3005);
        ethBoardTypeList.add(2292);
        return ethBoardTypeList.contains(boardType) || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_ETH_OAM", "ETHOAM_SUPPORT_OAM");
    }

    public static int getNEAllOAMToDB(TEDataCfgNEInfo pPara, boolean uploadFlag) {
        String firstFlag = "Upload";
        if (!uploadFlag) {
            firstFlag = "Sync";
        }
        E2ELOGGER.info(firstFlag + " EthServiceOAM begin.");
        int neID = pPara.getNeID();
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            String tipStr = firstFlag + " EthServiceOAM fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
            E2ELOGGER.info(firstFlag + " EthServiceOAM end.");
            return retCode;
        }
        List boardList = TEConfigurationDataMgr.getInstance().getBoardList(neID);
        int boardType = -1;
        boolean isAllFail = true;
        boolean isAllSuccess = true;
        TEErrInfoReturn errInfoReturn = new TEErrInfoReturn();
        for (TEBoard board : boardList) {
            boardType = board.getBoardType();
            if (!TEEthServiceOAMUtil.isBoardSupportEthServiceOAM(boardType)) continue;
            int errorCode = TEEthServiceOAMUtil.getOAMFromNEAndSaveTODB(neID, board.getSlotID());
            if (0 != errorCode) {
                TEErrInfo errInfo = new TEErrInfo();
                errInfo.setObjID(new int[]{neID, board.getSlotID()});
                errInfo.setErrorCode(errorCode);
                errInfoReturn.addErrInfo(errInfo);
                isAllSuccess = false;
                continue;
            }
            String tipStr = firstFlag + " EthServiceOAM for the board fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errorCode:%d]", neID, board.getSlotID(), errorCode);
            E2ELOGGER.error(tipStr);
            isAllFail = false;
        }
        if (isAllSuccess) {
            errInfoReturn.setResult(0);
        } else if (isAllFail) {
            errInfoReturn.setResult(1090650122);
        } else {
            errInfoReturn.setResult(1090650126);
        }
        E2ELOGGER.info(firstFlag + " EthServiceOAM end.");
        return 0;
    }

    public static QAsnEthermpID convertMpIDNe2E2E(String neMpID) {
        QAsnEthermpID e2eMpID = new QAsnEthermpID();
        if (neMpID.length() == 8) {
            int first = Integer.parseInt(neMpID.substring(0, 2), 16);
            int second = Integer.parseInt(neMpID.substring(2, 4), 16);
            int third = Integer.parseInt(neMpID.substring(4, 8), 16);
            e2eMpID.add((Object)first);
            e2eMpID.add((Object)second);
            e2eMpID.add((Object)third);
        }
        return e2eMpID;
    }

    public static QAsnEthermpID convertMpIDNeWithSplit2E2E(String neMpID) {
        String[] neMpIDs;
        QAsnEthermpID e2eMpID = new QAsnEthermpID();
        if (neMpID != null && !neMpID.equals("") && (neMpIDs = neMpID.split("-")).length >= 3) {
            int first = Integer.parseInt(neMpIDs[0], 16);
            int second = Integer.parseInt(neMpIDs[1], 16);
            int third = Integer.parseInt(neMpIDs[2], 16);
            e2eMpID.add((Object)first);
            e2eMpID.add((Object)second);
            e2eMpID.add((Object)third);
        }
        return e2eMpID;
    }

    public static QAsnEthermpID convertMpIDDB2E2E(String dbMpID) {
        String[] dbmpIDs;
        QAsnEthermpID e2eMpID = new QAsnEthermpID();
        if (dbMpID != null && !dbMpID.equals("") && (dbmpIDs = dbMpID.split(",")).length >= 3) {
            int first = Integer.parseInt(dbmpIDs[0]);
            int second = Integer.parseInt(dbmpIDs[1]);
            int third = Integer.parseInt(dbmpIDs[2]);
            e2eMpID.add((Object)first);
            e2eMpID.add((Object)second);
            e2eMpID.add((Object)third);
        }
        return e2eMpID;
    }

    public static String convertMpIDE2E2Ne(QAsnEthermpID e2eMpID) {
        String neMpID = "";
        int temp = 0;
        if (e2eMpID.size() == 3) {
            temp = Integer.parseInt(String.valueOf(e2eMpID.get(0)));
            String frist = "0" + Integer.toString(temp, 16);
            temp = Integer.parseInt(String.valueOf(e2eMpID.get(1)));
            String second = "0" + Integer.toString(temp, 16);
            temp = Integer.parseInt(String.valueOf(e2eMpID.get(2)));
            String third = "000" + Integer.toString(temp, 16);
            neMpID = neMpID + frist.substring(frist.length() - 2);
            neMpID = neMpID + second.substring(second.length() - 2);
            neMpID = neMpID + third.substring(third.length() - 4);
        }
        return neMpID;
    }

    public static String convertMpIDE2E2NeWithSplit(QAsnEthermpID e2eMpID) {
        String neMpID = "";
        int temp = 0;
        if (e2eMpID.size() == 3) {
            temp = Integer.parseInt(String.valueOf(e2eMpID.get(0)));
            String frist = "0" + Integer.toString(temp, 16);
            temp = Integer.parseInt(String.valueOf(e2eMpID.get(1)));
            String second = "0" + Integer.toString(temp, 16);
            temp = Integer.parseInt(String.valueOf(e2eMpID.get(2)));
            String third = "000" + Integer.toString(temp, 16);
            neMpID = neMpID + frist.substring(frist.length() - 2) + "-";
            neMpID = neMpID + second.substring(second.length() - 2) + "-";
            neMpID = neMpID + third.substring(third.length() - 4);
        }
        return neMpID;
    }

    public static String convertMpIDE2E2Ne(BigInteger mpID) {
        String neMpID = "";
        neMpID = "00000000" + mpID.toString(16).toUpperCase();
        neMpID = neMpID.substring(neMpID.length() - 8);
        return neMpID;
    }

    public static String convertMpIDDB2Ne(String mpID) {
        String dbMpID = "";
        String[] mpIDs = mpID.split(",");
        String tmp = "";
        if (mpIDs.length >= 3) {
            tmp = "0" + Integer.toString(Integer.parseInt(mpIDs[0]), 16);
            dbMpID = tmp.substring(tmp.length() - 2);
            tmp = "0" + Integer.toString(Integer.parseInt(mpIDs[1]), 16);
            dbMpID = dbMpID + tmp.substring(tmp.length() - 2);
            tmp = "000" + Integer.toString(Integer.parseInt(mpIDs[2]), 16);
            dbMpID = dbMpID + tmp.substring(tmp.length() - 4);
        }
        return dbMpID;
    }

    public static String convertMpIDNe2DB(String neMpID) {
        String mpID = "";
        if (neMpID.length() == 8) {
            int first = Integer.parseInt(neMpID.substring(0, 2), 16);
            int second = Integer.parseInt(neMpID.substring(2, 4), 16);
            int third = Integer.parseInt(neMpID.substring(4, 8), 16);
            mpID = first + ",";
            mpID = mpID + second + ",";
            mpID = mpID + third;
        }
        return mpID;
    }

    public static BigInteger getSupport(boolean bSupport) {
        return BigInteger.valueOf(bSupport ? 1L : 0L);
    }

    public static int getFirstErrorCodeFromOutput(Datainterface output) {
        int retCode = Integer.parseInt(output.getErrorMessage().getErrorcode());
        RowParams row = null;
        int len = output.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = output.getBussinessParams().getRowParams(i);
            if (row.getRowErrorsCount() <= 0) continue;
            retCode = Integer.parseInt(row.getRowErrors(0).getErrorMessage().getErrorcode());
            break;
        }
        return retCode;
    }

    public static QAsnEvtPFMtestRspNtf getPFMTestRspFromOutput(int neID, Output outPut) {
        QAsnEvtPFMtestRspNtf event = new QAsnEvtPFMtestRspNtf();
        event.delayTime = Integer.parseInt(outPut.getPartValue("delayTime"));
        event.frameLen = Integer.parseInt(outPut.getPartValue("frameLength"));
        event.snkMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(outPut.getPartValue("snkmpid"));
        event.srcMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(outPut.getPartValue("srcmpid"));
        event.ttl = Integer.parseInt(outPut.getPartValue("TTL"));
        event.result.isSuccess = true;
        event.result.retCode = 0;
        event.srcCPIndex = TEEthServiceOAMUtil.getAsnCPIndex(neID, Integer.parseInt(outPut.getPartValue("slotid")));
        return event;
    }

    public static QAsnEvtPFMtestOverTimeNtf getPFMTestOverTimeFromOutput(int neID, Output outPut) {
        QAsnEvtPFMtestOverTimeNtf event = new QAsnEvtPFMtestOverTimeNtf();
        event.frameLen = Integer.parseInt(outPut.getPartValue("frameLength"));
        event.snkMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(outPut.getPartValue("snkmpid"));
        event.srcMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(outPut.getPartValue("srcmpid"));
        event.result.isSuccess = true;
        event.result.retCode = 0;
        event.srcCPIndex = TEEthServiceOAMUtil.getAsnCPIndex(neID, Integer.parseInt(outPut.getPartValue("slotid")));
        return event;
    }

    public static QAsnEvtPFMtestStatisticsNft getPFMTestStatisticsFromOutput(int neID, Output outPut) {
        QAsnEvtPFMtestStatisticsNft event = new QAsnEvtPFMtestStatisticsNft();
        event.snkMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(outPut.getPartValue("snkmpid"));
        event.srcMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(outPut.getPartValue("srcmpid"));
        event.rxpxtNum = Integer.parseInt(outPut.getPartValue("receiveFrameAmount"));
        event.txpxtNum = Integer.parseInt(outPut.getPartValue("sendFrameAmount"));
        event.averageDelay = Integer.parseInt(outPut.getPartValue("averageDelay"));
        event.loseRate = Integer.parseInt(outPut.getPartValue("lostRate"));
        event.maxDelay = Integer.parseInt(outPut.getPartValue("maxDelay"));
        event.minDelay = Integer.parseInt(outPut.getPartValue("minDelay"));
        event.result.isSuccess = true;
        event.result.retCode = 0;
        event.srcCPIndex = TEEthServiceOAMUtil.getAsnCPIndex(neID, Integer.parseInt(outPut.getPartValue("slotid")));
        return event;
    }

    public static QAsnEvtPingRspNft getPingRspFromOutput(int neID, Output outPut) {
        QAsnEvtPingRspNft event = new QAsnEvtPingRspNft();
        event.delayTime = Integer.parseInt(outPut.getPartValue("delayTime"));
        event.frameLen = Integer.parseInt(outPut.getPartValue("frameLength"));
        event.srcMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(outPut.getPartValue("mpID"));
        event.ttl = Integer.parseInt(outPut.getPartValue("TTL"));
        event.snkMPIP = (int)Long.parseLong(outPut.getPartValue("mpIP"), 16);
        event.result.isSuccess = true;
        event.result.retCode = 0;
        event.srcCPIndex = TEEthServiceOAMUtil.getAsnCPIndex(neID, Integer.parseInt(outPut.getPartValue("slotid")));
        return event;
    }

    public static QAsnEvtPingOverTimeNft getPingOverTimeFromOutput(int neID, Output outPut) {
        QAsnEvtPingOverTimeNft event = new QAsnEvtPingOverTimeNft();
        event.frameLen = Integer.parseInt(outPut.getPartValue("frameLength"));
        event.srcMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(outPut.getPartValue("mpID"));
        event.snkMPIP = (int)Long.parseLong(outPut.getPartValue("mpIP"), 16);
        event.result.isSuccess = true;
        event.result.retCode = 0;
        event.srcCPIndex = TEEthServiceOAMUtil.getAsnCPIndex(neID, Integer.parseInt(outPut.getPartValue("slotid")));
        return event;
    }

    public static QAsnEvtPingStatisticsNft getPingStatisticsFromOutput(int neID, Output outPut) {
        QAsnEvtPingStatisticsNft event = new QAsnEvtPingStatisticsNft();
        event.snkMPIP = (int)Long.parseLong(outPut.getPartValue("mpIP"), 16);
        event.srcMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(outPut.getPartValue("mpID"));
        event.rxpxtNum = Integer.parseInt(outPut.getPartValue("receiveFrameAmount"));
        event.txpxtNum = Integer.parseInt(outPut.getPartValue("sendFrameAmount"));
        event.averageDelay = Integer.parseInt(outPut.getPartValue("averageDelay"));
        event.loseRate = Integer.parseInt(outPut.getPartValue("lostRate"));
        event.maxDelay = Integer.parseInt(outPut.getPartValue("maxDelay"));
        event.minDelay = Integer.parseInt(outPut.getPartValue("minDelay"));
        event.result.isSuccess = true;
        event.result.retCode = 0;
        event.srcCPIndex = TEEthServiceOAMUtil.getAsnCPIndex(neID, Integer.parseInt(outPut.getPartValue("slotid")));
        return event;
    }

    public static QAsnCPIndex getAsnCPIndex(int neid, int slotid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        QAsnCPIndex cpIndex = null;
        if (ne != null) {
            cpIndex = new QAsnCPIndex();
            cpIndex.oneID = ne.getONEID();
            cpIndex.neID = neid;
            cpIndex.shelfID = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)slotid);
            cpIndex.slotID = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid);
        }
        return cpIndex;
    }

    public static QAsnEthermpIDList getUsedMPIDList() {
        QAsnEthermpIDList list = new QAsnEthermpIDList();
        AsnJNIGetAllMPIDRsp rsp = new AsnJNIGetAllMPIDRsp();
        rsp.result = BigInteger.valueOf(-1L);
        TEJNIFacadeUtil.sendJNIMessage((int)4, (FStruct)new AsnJNIGetAllMPIDReq(), (FStruct)rsp);
        if (rsp.result.intValue() == 0) {
            String dbMpid = "";
            int len = rsp.allMPIDList.size();
            for (int i = 0; i < len; ++i) {
                dbMpid = new String((byte[])rsp.allMPIDList.get(i));
                if ("".equals(dbMpid)) continue;
                list.add((Object)TEEthServiceOAMUtil.convertMpIDDB2E2E(dbMpid));
            }
        } else {
            E2ELOGGER.info("Get OAMAllMPID List fail! result=" + rsp.result.toString());
        }
        return list;
    }

    public static List<String> getAutoAssignMPID(int allocNum) {
        ArrayList<String> list = new ArrayList<String>();
        AsnJNIAllocMPIDReq req = new AsnJNIAllocMPIDReq();
        req.allocNum = BigInteger.valueOf(allocNum);
        AsnJNIAllocMPIDRsp rsp = new AsnJNIAllocMPIDRsp();
        rsp.result = BigInteger.valueOf(-1L);
        TEJNIFacadeUtil.sendJNIMessage((int)5, (FStruct)req, (FStruct)rsp);
        if (rsp.result.intValue() == 0) {
            String dbMpid = "";
            int len = rsp.allocMPIDList.size();
            for (int i = 0; i < len; ++i) {
                dbMpid = new String((byte[])rsp.allocMPIDList.get(i));
                if ("".equals(dbMpid)) continue;
                list.add(TEEthServiceOAMUtil.convertMpIDDB2Ne(dbMpid));
            }
        } else {
            E2ELOGGER.info("Get OAMAllocMPID List fail! result=" + rsp.result.toString());
        }
        return list;
    }

    public static QFAsnMPInfo cloneMPInfo(QFAsnMPInfo mpInfo) {
        QFAsnMPInfo mpInfoResult = new QFAsnMPInfo();
        mpInfoResult.mpdir = mpInfo.mpdir;
        mpInfoResult.mpID = (QAsnEthermpID)mpInfo.mpID.clone();
        mpInfoResult.mplevel = mpInfo.mplevel;
        mpInfoResult.mptype = mpInfo.mptype;
        mpInfoResult.neID = mpInfo.neID;
        mpInfoResult.pairID = mpInfo.pairID;
        mpInfoResult.slotID = mpInfo.slotID;
        mpInfoResult.portID = mpInfo.portID;
        mpInfoResult.portType = mpInfo.portType;
        mpInfoResult.serviceID = mpInfo.serviceID;
        mpInfoResult.servicetype = mpInfo.servicetype;
        mpInfoResult.snkmpID = (QAsnEthermpID)mpInfo.snkmpID.clone();
        mpInfoResult.vlanID = mpInfo.vlanID;
        mpInfoResult.issuportLT = mpInfo.issuportLT;
        mpInfoResult.issuportPFMtest = mpInfo.issuportPFMtest;
        mpInfoResult.issuportPing = mpInfo.issuportPing;
        mpInfoResult.issuportTboard = mpInfo.issuportTboard;
        if (mpInfo.ccStatus != null) {
            mpInfoResult.ccStatus = mpInfo.ccStatus;
        }
        if (mpInfo.lbTime != null) {
            mpInfoResult.lbTime = mpInfo.lbTime;
        }
        if (mpInfo.ltTime != null) {
            mpInfoResult.ltTime = mpInfo.ltTime;
        }
        if (mpInfo.ccTime != null) {
            mpInfoResult.ccTime = mpInfo.ccTime;
        }
        return mpInfoResult;
    }

    public static String convertBigInt2Str(BigInteger bigInt) {
        return null == bigInt ? "" : bigInt.toString();
    }

    public static BigInteger convertParam2BigInt(Param param) {
        BigInteger result = null;
        result = null != param && !"".equals(param.getValue()) ? BigInteger.valueOf(Long.valueOf(param.getValue())) : BigInteger.valueOf(-1L);
        return result;
    }

    public static String getStr(byte[] byteArr) {
        if (null == byteArr || 0 == byteArr.length) {
            return "";
        }
        return new String(byteArr);
    }

    public static QAsnUniResID cloneAsnUniResID(QAsnUniResID resid) {
        QAsnUniResID resID = new QAsnUniResID();
        resID.neID = resid.neID;
        resID.strMOC = (byte[])resid.strMOC.clone();
        resID.strFDN = (byte[])resid.strFDN.clone();
        if (resid.poSerialNum != null) {
            resID.poSerialNum = (byte[])resid.poSerialNum.clone();
        }
        return resID;
    }

    public static BigInteger convertPMEnableNBI2NE(BigInteger nbienable) {
        BigInteger neenable = nbienable.intValue() == 1 ? BigInteger.valueOf(1L) : (nbienable.intValue() == 2 ? BigInteger.valueOf(0L) : BigInteger.valueOf(-1L));
        return neenable;
    }

    public static BigInteger convertPMEnableNE2NBI(BigInteger neenable) {
        BigInteger nbienable = neenable.intValue() == 1 ? BigInteger.valueOf(1L) : (neenable.intValue() == 0 ? BigInteger.valueOf(2L) : BigInteger.valueOf(-1L));
        return nbienable;
    }

    public static BigInteger convertPMModeNBI2NE(BigInteger nbimode) {
        BigInteger nemode = nbimode.intValue() == NBI_PASSIVITY_MODE ? BigInteger.valueOf(NE_PASSIVITY_MODE) : (nbimode.intValue() == NBI_INITIATIVE_MODE ? BigInteger.valueOf(NE_INITIATIVE_MODE) : BigInteger.valueOf(-1L));
        return nemode;
    }

    public static BigInteger convertPMModeNE2NBI(BigInteger nemode) {
        BigInteger nbimode = nemode.intValue() == NE_PASSIVITY_MODE ? BigInteger.valueOf(NBI_PASSIVITY_MODE) : (nemode.intValue() == NE_INITIATIVE_MODE ? BigInteger.valueOf(NBI_INITIATIVE_MODE) : BigInteger.valueOf(-1L));
        return nbimode;
    }

    public static void deleteServiceOAM(int neID, int slotID, int serviceid, int serviceType) {
        TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
        if (null == oamContainer || oamContainer.getOAMMPList().isEmpty()) {
            return;
        }
        Set mpList = oamContainer.getOAMMPList();
        Iterator mpIterator = mpList.iterator();
        TEEtherOAMMPMOPO mpMOPO = null;
        while (mpIterator.hasNext()) {
            mpMOPO = (TEEtherOAMMPMOPO)mpIterator.next();
            if (mpMOPO.getServiceID() != serviceid || mpMOPO.getServiceType() != serviceType) continue;
            mpIterator.remove();
        }
        TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
    }

    public static void deleteElanOAM(int neID, int slotID, int serviceid) {
        TEEthServiceOAMUtil.deleteServiceOAM(neID, slotID, serviceid, SERVICE_TYPE_ELAN);
    }

    public static void deleteElineOAM(int neID, int slotID, int serviceid) {
        TEEthServiceOAMUtil.deleteServiceOAM(neID, slotID, serviceid, SERVICE_TYPE_ELINE);
    }
}

