/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.network.qasn.m_q_ipoam.QAsnMPCreateRpt;
import com.huawei.network.qasn.m_q_ipoam.QAsnMPDeleteRpt;
import com.huawei.network.qasn.m_q_ipoam.QFAsnMPInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEE2EOAMNoticeMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEthOAMMPContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherOAMMAMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherOAMMDMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherOAMMPMOPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEEthServiceOAMDBHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();
    private static final int DEFAULT_AISLEVEL = 7;
    private static final int DEFAULT_AISPERIOD = 60000;
    private static final int DEFAULT_AISSTATUS = 0;
    private static final String DEFAULT_CCMAC = "01-80-c2-00-00-30";

    private TEEthServiceOAMDBHandler() {
    }

    public static void saveEthServiceOAMMPToDB(int neID, Datainterface inputData, Datainterface outputData) {
        List<TEEtherOAMMPMOPO> ethOAMMPist = TEEthServiceOAMDBHandler.constructEthServiceOAMMP(neID, outputData);
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        if (null == ethOAMMPist) {
            String tipStr = "The ethOAMMPist is empty! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            E2ELOGGER.info(tipStr);
            return;
        }
        TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
        if (null == oamContainer) {
            oamContainer = new TEEthOAMMPContainer();
        } else {
            TEEthServiceOAMUtil.cleanContainer(oamContainer, 1);
        }
        oamContainer.getOAMMPList().addAll(ethOAMMPist);
        TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
    }

    public static void addOAMMPTODBAndNotice(int neID, Datainterface inputData, Datainterface outputData) {
        TEEthOAMMPContainer oamContainer;
        if (!TEEthServiceOAMUtil.checkOutputSuccess(neID, inputData, outputData, "AddEthOAMMP")) {
            return;
        }
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        TEEtherOAMMPMOPO mpMOPO = TEEthServiceOAMDBHandler.getEthServiceOAMMPMOPO(inputData.getBussinessParams().getRowParams(0));
        if (mpMOPO.getMDIndex() != 0) {
            mpMOPO.setAisLevel(7);
            mpMOPO.setAisPeriod(60000L);
            mpMOPO.setAisStatus(0);
            mpMOPO.setCCDMac(DEFAULT_CCMAC);
        }
        if (null == (oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID))) {
            return;
        }
        oamContainer.getOAMMPList().add(mpMOPO);
        TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
        QFAsnMPInfo mpInfo = TEEthServiceOAMDBHandler.convertRowParams2AsnMP(neID, slotID, inputData.getBussinessParams().getRowParams(0));
        QAsnMPCreateRpt rpt = new QAsnMPCreateRpt();
        rpt.mpInfoList.add((Object)mpInfo);
        TEE2EOAMNoticeMgr.sendMPCreateRpt((FStruct)rpt);
    }

    public static void deleteOAMMPFromDBAndNotice(int neID, Datainterface inputData, Datainterface outputData) {
        List<String> deleteSuccessID = TEEthServiceOAMUtil.getDeleteSuccessID("mpid", inputData, outputData);
        if (deleteSuccessID.isEmpty()) {
            return;
        }
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
        if (null == oamContainer) {
            return;
        }
        Set mpList = oamContainer.getOAMMPList();
        Iterator mpIterator = mpList.iterator();
        TEEtherOAMMPMOPO mpMOPO = null;
        QAsnMPDeleteRpt rpt = new QAsnMPDeleteRpt();
        while (mpIterator.hasNext()) {
            mpMOPO = (TEEtherOAMMPMOPO)mpIterator.next();
            if (!deleteSuccessID.contains(TEEthServiceOAMUtil.convertMpIDDB2Ne(mpMOPO.getMPID()))) continue;
            rpt.mpInfoList.add((Object)TEEthServiceOAMDBHandler.convertOAMMPMO2Asn(neID, slotID, mpMOPO));
            mpIterator.remove();
        }
        TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
        TEE2EOAMNoticeMgr.sendMPDeleteRpt((FStruct)rpt);
    }

    public static void setEthServiceOAMMPCCStatusToDB(int neID, Datainterface inputData, Datainterface outputData) {
        if (!TEEthServiceOAMUtil.checkOutputSuccess(neID, inputData, outputData, "SetEthOAMMPCCStatus")) {
            return;
        }
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        String mpID = inputData.getBussinessParams().getRowParams(0).getParam("mpid").getValue();
        int cCStatus = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("ccstatus").getValue());
        TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
        if (null == oamContainer) {
            return;
        }
        TEEtherOAMMPMOPO mpMOPO = TEEthServiceOAMUtil.getEtherOAMMP(oamContainer, TEEthServiceOAMUtil.convertMpIDNe2DB(mpID));
        if (mpMOPO != null) {
            mpMOPO.setCCStatus((short)cCStatus);
            TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
        }
    }

    public static void setEthServiceOAMMPParamsToDB(int neID, Datainterface inputData, Datainterface outputData) {
        if (!TEEthServiceOAMUtil.checkOutputSuccess(neID, inputData, outputData, "SetEthOAMMPParams")) {
            return;
        }
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        if (null != outputData.getBussinessParams()) {
            Map<String, List<String>> errorMPIDToOBJMap = TEEthServiceOAMUtil.getModifyOAMMPErrorParamNames(outputData);
            HashMap mpIDToObjMap = new HashMap();
            BussinessParams inBusinessparams = inputData.getBussinessParams();
            int rowlen = inBusinessparams.getRowParamsCount();
            for (int row = 0; row < rowlen; ++row) {
                RowParams rowParams = inBusinessparams.getRowParams(row);
                String mpID = rowParams.getParam("mpid").getValue();
                ArrayList<Param> list = (ArrayList<Param>)mpIDToObjMap.get(mpID);
                if (list == null) {
                    list = new ArrayList<Param>();
                    mpIDToObjMap.put(mpID, list);
                }
                List<String> errorlist = errorMPIDToOBJMap.get(mpID);
                int size = rowParams.getParamCount();
                for (int i = 0; i < size; ++i) {
                    Param rowParam = rowParams.getParam(i);
                    if (!rowParam.getModifyFlag() || errorlist != null && errorlist.contains(rowParam.getName())) continue;
                    list.add(rowParam);
                }
            }
            TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
            if (null == oamContainer) {
                return;
            }
            TEEtherOAMMPMOPO mpMOPO = null;
            for (Map.Entry entry : mpIDToObjMap.entrySet()) {
                mpMOPO = TEEthServiceOAMUtil.getEtherOAMMP(oamContainer, TEEthServiceOAMUtil.convertMpIDNe2DB((String)entry.getKey()));
                if (null == mpMOPO) continue;
                for (Param param : (List)entry.getValue()) {
                    String name = param.getName();
                    String value = param.getValue();
                    if ("lbtesttime".equals(name)) {
                        mpMOPO.setLBTime(Integer.parseInt(value));
                    }
                    if ("lttesttime".equals(name)) {
                        mpMOPO.setLTTime(Integer.parseInt(value));
                    }
                    if ("ccperiod".equals(name)) {
                        mpMOPO.setCCTime(Integer.parseInt(value));
                    }
                    if ("aisStatus".equals(name)) {
                        mpMOPO.setAisStatus(Integer.parseInt(value));
                    }
                    if ("clientLevel".equals(name)) {
                        mpMOPO.setAisLevel(Integer.parseInt(value));
                    }
                    if ("aisPeriod".equals(name)) {
                        mpMOPO.setAisPeriod(Long.valueOf(value).longValue());
                    }
                    if (!"ccMac".equals(name)) continue;
                    mpMOPO.setCCDMac(value);
                }
            }
            TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
        }
    }

    public static void addEthServciceOAMMDTODB(int neID, Datainterface inputData, Datainterface outputData) {
        if (!TEEthServiceOAMUtil.checkOutputSuccess(neID, inputData, outputData, "AddEthOAMMD")) {
            return;
        }
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        TEEtherOAMMDMOPO mdMOPO = TEEthServiceOAMDBHandler.getEthServiceOAMMDMOPO(inputData.getBussinessParams().getRowParams(0));
        TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
        if (null == oamContainer) {
            String tipStr = "The container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            E2ELOGGER.info(tipStr);
            return;
        }
        oamContainer.getOAMMDList().add(mdMOPO);
        TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
    }

    public static void deleteEthServiceOAMMDFromDB(int neID, Datainterface inputData, Datainterface outputData) {
        List<String> deleteSuccessID = TEEthServiceOAMUtil.getDeleteSuccessID("mdid", inputData, outputData);
        if (deleteSuccessID.isEmpty()) {
            return;
        }
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
        if (null == oamContainer) {
            return;
        }
        Set mdList = oamContainer.getOAMMDList();
        Iterator mdIterator = mdList.iterator();
        TEEtherOAMMDMOPO mdMOPO = null;
        while (mdIterator.hasNext()) {
            mdMOPO = (TEEtherOAMMDMOPO)mdIterator.next();
            if (!deleteSuccessID.contains(String.valueOf(mdMOPO.getMDIndex()))) continue;
            mdIterator.remove();
        }
        Set maList = oamContainer.getOAMMAList();
        Iterator maIterator = maList.iterator();
        TEEtherOAMMAMOPO maMOPO = null;
        while (maIterator.hasNext()) {
            maMOPO = (TEEtherOAMMAMOPO)maIterator.next();
            if (!deleteSuccessID.contains(String.valueOf(maMOPO.getMDIndex()))) continue;
            maIterator.remove();
        }
        TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
    }

    public static void addEthServciceOAMMATODB(int neID, Datainterface inputData, Datainterface outputData) {
        if (!TEEthServiceOAMUtil.checkOutputSuccess(neID, inputData, outputData, "AddEthOAMMA")) {
            return;
        }
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        TEEtherOAMMAMOPO maMOPO = TEEthServiceOAMDBHandler.getEthServiceOAMMAMOPO(inputData.getBussinessParams().getRowParams(0));
        TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
        if (null == oamContainer) {
            return;
        }
        oamContainer.getOAMMAList().add(maMOPO);
        TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
    }

    public static void deleteEthServiceOAMMAFromDB(int neID, Datainterface inputData, Datainterface outputData) {
        List<String> deleteSuccessID = TEEthServiceOAMUtil.getDeleteSuccessID("maid", inputData, outputData);
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        if (deleteSuccessID.isEmpty()) {
            return;
        }
        String mDID = inputData.getBussinessParams().getRowParams(0).getParam("mdid").getValue();
        TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
        if (null == oamContainer) {
            return;
        }
        Set mpList = oamContainer.getOAMMAList();
        Iterator mpIterator = mpList.iterator();
        TEEtherOAMMAMOPO maMOPO = null;
        while (mpIterator.hasNext()) {
            maMOPO = (TEEtherOAMMAMOPO)mpIterator.next();
            if (!mDID.equals(String.valueOf(maMOPO.getMDIndex())) || !deleteSuccessID.contains(String.valueOf(maMOPO.getMAIndex()))) continue;
            mpIterator.remove();
        }
        TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
    }

    public static void saveEthServiceOAMMDMAToDB(int neID, Datainterface inputData, Datainterface outputData) {
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            String tipStr = "The bussiness is null! ";
            E2ELOGGER.error(tipStr);
            return;
        }
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        ArrayList<TEEtherOAMMDMOPO> oamMDList = new ArrayList<TEEtherOAMMDMOPO>();
        ArrayList<TEEtherOAMMAMOPO> oamMAList = new ArrayList<TEEtherOAMMAMOPO>();
        RowParams rowparams = null;
        TEEtherOAMMDMOPO oamMDMOPO = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = bussiness.getRowParams(i);
            oamMDMOPO = TEEthServiceOAMDBHandler.getEthServiceOAMMDMOPO(rowparams);
            if (null == oamMDMOPO) continue;
            oamMDList.add(oamMDMOPO);
            oamMAList.addAll(TEEthServiceOAMDBHandler.getEthServiceOAMMAMOPOList(rowparams));
        }
        TEEthOAMMPContainer oamContainer = TEEthServiceOAMUtil.getContainer(neID, slotID);
        if (null == oamContainer) {
            oamContainer = new TEEthOAMMPContainer();
        } else {
            TEEthServiceOAMUtil.cleanContainer(oamContainer, 2);
            TEEthServiceOAMUtil.cleanContainer(oamContainer, 3);
        }
        oamContainer.getOAMMDList().addAll(oamMDList);
        oamContainer.getOAMMAList().addAll(oamMAList);
        TEEthServiceOAMUtil.saveContainerToDB(neID, slotID, oamContainer);
    }

    public static TEEtherOAMMDMOPO getEthServiceOAMMDMOPO(RowParams row) {
        TEEtherOAMMDMOPO oamMDMOPO = null;
        if (row.getRowErrorsCount() == 0) {
            oamMDMOPO = new TEEtherOAMMDMOPO();
            int mDIndex = Integer.parseInt(row.getParam("mdid").getValue());
            int mDType = Integer.parseInt(row.getParam("mdNameType").getValue());
            String mDName = row.getParam("mdName").getValue();
            oamMDMOPO.setMDIndex(mDIndex);
            Param levelParams = row.getParam("mdLevel");
            if (null == levelParams) {
                levelParams = row.getParam("level");
            }
            if (null != levelParams) {
                oamMDMOPO.setMDLevel(Integer.parseInt(levelParams.getValue()));
            }
            oamMDMOPO.setMDType(mDType);
            oamMDMOPO.setMDName(mDName);
        }
        return oamMDMOPO;
    }

    public static TEEtherOAMMAMOPO getEthServiceOAMMAMOPO(RowParams rowparam) {
        TEEtherOAMMAMOPO oamMAMOPO = null;
        if (rowparam.getRowErrorsCount() == 0) {
            oamMAMOPO = new TEEtherOAMMAMOPO();
            int mDID = Integer.parseInt(rowparam.getParam("mdid").getValue());
            int mAID = Integer.parseInt(rowparam.getParam("maid").getValue());
            String mAName = rowparam.getParam("maName").getValue();
            oamMAMOPO.setMDIndex(mDID);
            oamMAMOPO.setMAIndex(mAID);
            oamMAMOPO.setMAName(mAName);
        }
        return oamMAMOPO;
    }

    public static List<TEEtherOAMMAMOPO> getEthServiceOAMMAMOPOList(RowParams row) {
        ArrayList<TEEtherOAMMAMOPO> oamMAMOPOList = new ArrayList<TEEtherOAMMAMOPO>();
        if (row.getRowErrorsCount() == 0) {
            int mDIndex = Integer.parseInt(row.getParam("mdid").getValue());
            Param malist = row.getParam("maList");
            TEEtherOAMMAMOPO oamMAMOPO = null;
            String maStr = "";
            int index = 0;
            int len = malist.getOptionCount();
            for (int i = 0; i < len; ++i) {
                maStr = malist.getOption(i).getValue();
                if (null == maStr || maStr.equals("")) continue;
                oamMAMOPO = new TEEtherOAMMAMOPO();
                oamMAMOPO.setMDIndex(mDIndex);
                index = maStr.indexOf(44);
                oamMAMOPO.setMAIndex(Integer.parseInt(maStr.substring(0, index)));
                oamMAMOPO.setMAName(maStr.substring(index + 1));
                oamMAMOPOList.add(oamMAMOPO);
            }
        }
        return oamMAMOPOList;
    }

    public static List<TEEtherOAMMPMOPO> constructEthServiceOAMMP(int neID, Datainterface outputData) {
        ArrayList<TEEtherOAMMPMOPO> ethoamList = null;
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            String tipStr = "The bussiness is null! ";
            E2ELOGGER.error(tipStr);
            return ethoamList;
        }
        ethoamList = new ArrayList<TEEtherOAMMPMOPO>();
        RowParams rowparams = null;
        TEEtherOAMMPMOPO oamMOPO = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = bussiness.getRowParams(i);
            oamMOPO = TEEthServiceOAMDBHandler.getEthServiceOAMMPMOPO(rowparams);
            if (null == oamMOPO) continue;
            ethoamList.add(oamMOPO);
        }
        return ethoamList;
    }

    public static TEEtherOAMMPMOPO getEthServiceOAMMPMOPO(RowParams row) {
        TEEtherOAMMPMOPO oammopo = null;
        if (row.getRowErrorsCount() == 0) {
            int servicetype = Integer.parseInt(row.getParam("servicetype").getValue());
            int serviceid = Integer.parseInt(row.getParam("serviceid").getValue());
            int portid = Integer.parseInt(row.getParam("port").getValue());
            int porttype = TEEthServiceOAMUtil.getPortType(portid);
            int vlanid = Integer.parseInt(row.getParam("vlanid").getValue());
            int mptype = Integer.parseInt(row.getParam("type").getValue());
            int mplevel = Integer.parseInt(row.getParam("level").getValue());
            int mpdir = Integer.parseInt(row.getParam("direction").getValue());
            String mpid = row.getParam("mpid").getValue();
            int ccstatus = -1;
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("ccstatus"))) {
                ccstatus = Integer.parseInt(row.getParam("ccstatus").getValue());
            }
            int lbtime = -1;
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("lbtesttime"))) {
                lbtime = Integer.parseInt(row.getParam("lbtesttime").getValue());
            }
            int lttime = -1;
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("lttesttime"))) {
                lttime = Integer.parseInt(row.getParam("lttesttime").getValue());
            }
            int cctime = -1;
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("ccperiod"))) {
                cctime = Integer.parseInt(row.getParam("ccperiod").getValue());
            }
            oammopo = new TEEtherOAMMPMOPO();
            oammopo.setServiceID(serviceid);
            oammopo.setServiceType(servicetype);
            oammopo.setPortID((long)TEEthServiceOAMUtil.convertPortIDNE2E2E(portid));
            oammopo.setPortType(porttype);
            oammopo.setVlanID(vlanid);
            oammopo.setMPType(mptype);
            oammopo.setMPLevel((short)mplevel);
            oammopo.setMPID(TEEthServiceOAMUtil.convertMpIDNe2DB(mpid.replaceAll("-", "")));
            oammopo.setMPDir(mpdir);
            oammopo.setCCStatus((short)ccstatus);
            oammopo.setLBTime(lbtime);
            oammopo.setLTTime(lttime);
            oammopo.setCCTime(cctime);
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("mdid"))) {
                oammopo.setMDIndex(Integer.parseInt(row.getParam("mdid").getValue()));
            } else {
                oammopo.setMDIndex(-1);
            }
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("maid"))) {
                oammopo.setMAIndex(Integer.parseInt(row.getParam("maid").getValue()));
            } else {
                oammopo.setMAIndex(-1);
            }
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("aisStatus"))) {
                oammopo.setAisStatus(Integer.parseInt(row.getParam("aisStatus").getValue()));
            } else {
                oammopo.setAisStatus(-1);
            }
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("aisPeriod"))) {
                oammopo.setAisPeriod(Long.parseLong(row.getParam("aisPeriod").getValue()));
            } else {
                oammopo.setAisPeriod(-1L);
            }
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("clientLevel"))) {
                oammopo.setAisLevel(Integer.parseInt(row.getParam("clientLevel").getValue()));
            } else {
                oammopo.setAisLevel(-1);
            }
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("ccMac"))) {
                oammopo.setCCDMac(row.getParam("ccMac").getValue());
            }
        }
        return oammopo;
    }

    public static QFAsnMPInfo convertRowParams2AsnMP(int neid, int slotid, RowParams row) {
        QFAsnMPInfo asnMpInfo = null;
        if (row.getRowErrorsCount() == 0) {
            asnMpInfo = new QFAsnMPInfo();
            asnMpInfo.pairID = 0;
            asnMpInfo.neID = neid;
            asnMpInfo.slotID = slotid;
            asnMpInfo.serviceID = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("serviceid")).intValue();
            asnMpInfo.servicetype = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("servicetype")).intValue();
            asnMpInfo.portID = TEEthServiceOAMUtil.convertPortIDNE2E2E(TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("port")).intValue());
            asnMpInfo.portType = TEEthServiceOAMUtil.getPortType(asnMpInfo.portID);
            asnMpInfo.vlanID = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("vlanid")).intValue();
            asnMpInfo.mptype = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("type")).intValue();
            asnMpInfo.mplevel = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("level")).intValue();
            asnMpInfo.mpdir = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("direction")).intValue();
            asnMpInfo.issuportLT = 1;
            asnMpInfo.issuportPFMtest = 1;
            asnMpInfo.issuportPing = 1;
            asnMpInfo.issuportTboard = 0;
            asnMpInfo.mpID = TEEthServiceOAMUtil.convertMpIDNe2E2E(row.getParam("mpid").getValue());
            asnMpInfo.snkmpID = TEEthServiceOAMUtil.convertMpIDDB2E2E("0,0,0");
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("ccstatus"))) {
                asnMpInfo.ccStatus = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("ccstatus")).intValue();
            }
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("lbtesttime"))) {
                asnMpInfo.lbTime = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("lbtesttime")).intValue();
            }
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("lttesttime"))) {
                asnMpInfo.ltTime = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("lttesttime")).intValue();
            }
            if (TEEthServiceOAMDBHandler.isValid(row.getParam("ccperiod"))) {
                asnMpInfo.ccTime = TEEthServiceOAMUtil.convertParam2BigInt(row.getParam("ccperiod")).intValue();
            }
        }
        return asnMpInfo;
    }

    private static QFAsnMPInfo convertOAMMPMO2Asn(int neid, int slotid, TEEtherOAMMPMOPO mpMOPO) {
        QFAsnMPInfo asnMpInfo = new QFAsnMPInfo();
        asnMpInfo.pairID = 0;
        asnMpInfo.neID = neid;
        asnMpInfo.slotID = slotid;
        asnMpInfo.serviceID = mpMOPO.getServiceID();
        asnMpInfo.servicetype = mpMOPO.getServiceType();
        asnMpInfo.portID = (int)mpMOPO.getPortID();
        asnMpInfo.portType = mpMOPO.getPortType();
        asnMpInfo.vlanID = mpMOPO.getVlanID();
        asnMpInfo.mptype = mpMOPO.getMPType();
        asnMpInfo.mplevel = mpMOPO.getMPLevel();
        asnMpInfo.mpdir = mpMOPO.getMPDir();
        asnMpInfo.mpID = TEEthServiceOAMUtil.convertMpIDDB2E2E(mpMOPO.getMPID());
        asnMpInfo.snkmpID = TEEthServiceOAMUtil.convertMpIDDB2E2E("0,0,0");
        asnMpInfo.ccStatus = mpMOPO.getCCStatus();
        asnMpInfo.lbTime = mpMOPO.getLBTime();
        asnMpInfo.ltTime = mpMOPO.getLTTime();
        asnMpInfo.ccTime = mpMOPO.getCCTime();
        asnMpInfo.issuportLT = 1;
        asnMpInfo.issuportPFMtest = 1;
        asnMpInfo.issuportPing = 1;
        asnMpInfo.issuportTboard = 0;
        return asnMpInfo;
    }

    private static boolean isValid(Param param) {
        return param != null && param.getValue() != null && !"".equals(param.getValue());
    }
}

