/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ipoam.QAsnEtherStartPingReq;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EOAMStartPingHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnEtherStartPingReq begin.");
        QAsnEtherStartPingReq req = (QAsnEtherStartPingReq)qReq;
        QAsnSingleReturn rsp = (QAsnSingleReturn)qRsp;
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(req.neID, req.slotID);
        if (null != errInfo) {
            rsp.isSuccess = false;
            rsp.retCode = errInfo.errCode;
            return 0;
        }
        Datainterface inputData = this.createPingInputData(req);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(req.neID, 2106042, inputData);
        int result = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (result == 0) {
            rsp.isSuccess = true;
        } else {
            rsp.isSuccess = false;
            rsp.retCode = TEEthServiceOAMUtil.getFirstErrorCodeFromOutput(outputData);
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnEtherStartPingReq end. result->" + result);
        return 0;
    }

    protected Datainterface createPingInputData(QAsnEtherStartPingReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(req.neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(req.slotID));
        rowparams.addParam(param);
        param = new Param("frameLength", String.valueOf(req.frameLen));
        rowparams.addParam(param);
        param = new Param("timeout", String.valueOf(req.timeOut));
        rowparams.addParam(param);
        param = new Param("pingTimes", String.valueOf(req.attempt));
        rowparams.addParam(param);
        param = new Param("mpID", TEEthServiceOAMUtil.convertMpIDE2E2NeWithSplit(req.srcMPID));
        rowparams.addParam(param);
        param = new Param("mpIP", IPAddressUtil.convertIPLongToStr((long)req.srcMPIP));
        rowparams.addParam(param);
        param = new Param("destMPIP", IPAddressUtil.convertIPLongToStr((long)req.snkMPIP));
        rowparams.addParam(param);
        param = new Param("pingChangeFlag", "true");
        rowparams.addParam(param);
        param = new Param("ipChangeFlag", "true");
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

