/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_ipoam.QAsnLTTestInfo;
import com.huawei.network.qasn.m_q_ipoam.QAsnSetLBTestReq;
import com.huawei.network.qasn.m_q_ipoam.QAsnSetLTTestRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EOAMSetLTTestHandler
extends TEWNEMgrHandler {
    private static final String TEST_RESULT_SUCCESS = "0";
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnSetLTTestReq begin.");
        QAsnSetLBTestReq req = (QAsnSetLBTestReq)qReq;
        QAsnSetLTTestRsp rsp = (QAsnSetLTTestRsp)qRsp;
        rsp.neID = req.neID;
        rsp.slotID = req.slotID;
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(req.neID, req.slotID);
        if (null != errInfo) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = errInfo.errCode;
            return 0;
        }
        Datainterface inputData = this.createLTTextInputData(req);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(req.neID, 2105660, inputData);
        int result = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (result == 0) {
            QAsnLTTestInfo lttestinfo = null;
            RowParams rowParams = null;
            String testresult = "";
            int length = outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < length; ++i) {
                rowParams = outputData.getBussinessParams().getRowParams(i);
                if (rowParams.getRowErrorsCount() != 0) continue;
                String srcmp = rowParams.getParam("srcmp").getValue();
                String snkmp = rowParams.getParam("snkmp").getValue();
                String responsemp = rowParams.getParam("responsemp").getValue();
                int responsemptype = Integer.parseInt(rowParams.getParam("responsemptype").getValue());
                int hopcount = Integer.parseInt(rowParams.getParam("hopcount").getValue());
                testresult = rowParams.getParam("testresult").getValue();
                lttestinfo = new QAsnLTTestInfo();
                lttestinfo.srcmpID = TEEthServiceOAMUtil.convertMpIDNeWithSplit2E2E(srcmp);
                lttestinfo.snkmpID = TEEthServiceOAMUtil.convertMpIDNeWithSplit2E2E(snkmp);
                lttestinfo.rspmpID = TEEthServiceOAMUtil.convertMpIDNeWithSplit2E2E(responsemp);
                lttestinfo.rspmpType = responsemptype;
                lttestinfo.hopNum = hopcount;
                lttestinfo.testresult.isSuccess = testresult.equals(TEST_RESULT_SUCCESS);
                rsp.lttestinfoList.add((Object)lttestinfo);
            }
            rsp.result.isSuccess = true;
        } else {
            rsp.result.isSuccess = false;
            rsp.result.retCode = TEEthServiceOAMUtil.getFirstErrorCodeFromOutput(outputData);
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnSetLTTestReq end. result->" + result);
        return 0;
    }

    protected Datainterface createLTTextInputData(QAsnSetLBTestReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(req.neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(req.slotID));
        rowparams.addParam(param);
        param = new Param("srcmp", TEEthServiceOAMUtil.convertMpIDE2E2Ne(req.srcmpID));
        rowparams.addParam(param);
        param = new Param("snkmp", TEEthServiceOAMUtil.convertMpIDE2E2Ne(req.snkmpID));
        rowparams.addParam(param);
        param = new Param("mode", "NULL");
        rowparams.addParam(param);
        param = new Param("outtime", TEST_RESULT_SUCCESS);
        rowparams.addParam(param);
        param = new Param("isLogFlag", TEST_RESULT_SUCCESS);
        rowparams.addParam(param);
        return inputData;
    }
}

