/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_ipoam.QAsnEthermpID;
import com.huawei.network.qasn.m_q_ipoam.QAsnSetLBTestReq;
import com.huawei.network.qasn.m_q_ipoam.QAsnSetLBTestRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EOAMSetLBTestHandler
extends TEWNEMgrHandler {
    private static final String TEST_RESULT_SUCCESS = "0";
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnSetLBTestReq begin.");
        QAsnSetLBTestReq req = (QAsnSetLBTestReq)qReq;
        QAsnSetLBTestRsp rsp = (QAsnSetLBTestRsp)qRsp;
        rsp.neID = req.neID;
        rsp.slotID = req.slotID;
        rsp.snkmpID = (QAsnEthermpID)req.snkmpID.clone();
        rsp.srcmpID = (QAsnEthermpID)req.srcmpID.clone();
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(req.neID, req.slotID);
        if (null != errInfo) {
            rsp.testresult.isSuccess = false;
            rsp.testresult.retCode = errInfo.errCode;
            return 0;
        }
        Datainterface inputData = this.createLBTextInputData(req);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(req.neID, 2105659, inputData);
        int result = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (result == 0) {
            RowParams rowParams;
            String testresult = "";
            if (outputData.getBussinessParams().getRowParamsCount() > 0 && (rowParams = outputData.getBussinessParams().getRowParams(0)).getRowErrorsCount() == 0) {
                String srcmp = rowParams.getParam("srcmp").getValue();
                String snkmp = rowParams.getParam("snkmp").getValue();
                testresult = rowParams.getParam("testresult").getValue();
                rsp.srcmpID = TEEthServiceOAMUtil.convertMpIDNeWithSplit2E2E(srcmp);
                rsp.snkmpID = TEEthServiceOAMUtil.convertMpIDNeWithSplit2E2E(snkmp);
                rsp.testresult.isSuccess = testresult.equals(TEST_RESULT_SUCCESS);
            }
        } else {
            rsp.testresult.isSuccess = false;
            rsp.testresult.retCode = TEEthServiceOAMUtil.getFirstErrorCodeFromOutput(outputData);
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnSetLBTestReq end. result->" + result);
        return 0;
    }

    protected Datainterface createLBTextInputData(QAsnSetLBTestReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(req.neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(req.slotID));
        rowparams.addParam(param);
        param = new Param("byMac", TEST_RESULT_SUCCESS);
        rowparams.addParam(param);
        param = new Param("srcmp", TEEthServiceOAMUtil.convertMpIDE2E2Ne(req.srcmpID));
        rowparams.addParam(param);
        param = new Param("snkmp", TEEthServiceOAMUtil.convertMpIDE2E2Ne(req.snkmpID));
        rowparams.addParam(param);
        param = new Param("outtime", TEST_RESULT_SUCCESS);
        rowparams.addParam(param);
        param = new Param("isLogFlag", TEST_RESULT_SUCCESS);
        rowparams.addParam(param);
        return inputData;
    }
}

