/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ipoam.QAsnSetMPReq;
import com.huawei.network.qasn.m_q_ipoam.QAsnSetMPRsp;
import com.huawei.network.qasn.m_q_ipoam.QFAsnMPInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import java.util.ArrayList;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EOAMSetCCStatusHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnSetMPReq(CCStatus) begin.");
        QAsnSetMPReq req = (QAsnSetMPReq)qReq;
        QAsnSetMPRsp rsp = (QAsnSetMPRsp)qRsp;
        rsp.result = new QAsnSingleReturn();
        QFAsnMPInfo asnMPInfo = null;
        int result = 0;
        ArrayList<Integer> errorCodes = new ArrayList<Integer>();
        int len = req.mpinfoList.size();
        for (int i = 0; i < len; ++i) {
            asnMPInfo = (QFAsnMPInfo)req.mpinfoList.get(i);
            QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(asnMPInfo.neID, asnMPInfo.slotID);
            if (errInfo != null) {
                errorCodes.add(errInfo.errCode);
                continue;
            }
            result = this.setCCStatusTONE(asnMPInfo);
            if (result == 0) continue;
            E2ELOGGER.info("handleRequestImpl: handle QAsnSetMPReq(CCStatus) fail.result->" + result);
            errorCodes.add(result);
        }
        if (errorCodes.isEmpty()) {
            rsp.result.isSuccess = true;
        } else if (errorCodes.size() != req.mpinfoList.size()) {
            rsp.result.isSuccess = true;
            rsp.result.retCode = 1090600984;
        } else {
            rsp.result.isSuccess = false;
            rsp.result.retCode = 1090646033;
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnSetMPReq(CCStatus) end.");
        return 0;
    }

    protected int setCCStatusTONE(QFAsnMPInfo asnMPInfo) {
        if (asnMPInfo.ccStatus == null || asnMPInfo.ccStatus == -1) {
            return 1091133469;
        }
        Datainterface inputData = this.createPerformInputData(asnMPInfo);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(asnMPInfo.neID, 2105657, inputData);
        return Integer.parseInt(outputData.getErrorMessage().getErrorcode());
    }

    protected Datainterface createPerformInputData(QFAsnMPInfo asnMPInfo) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(asnMPInfo.neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(asnMPInfo.slotID));
        rowparams.addParam(param);
        param = new Param("mpid", TEEthServiceOAMUtil.convertMpIDE2E2Ne(asnMPInfo.mpID));
        rowparams.addParam(param);
        param = new Param("ccstatus", String.valueOf(asnMPInfo.ccStatus));
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

