/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_ipoam.QAsnEtherQueryPingReq;
import com.huawei.network.qasn.m_q_ipoam.QAsnEtherQueryPingRsp;
import com.huawei.network.qasn.m_q_ipoam.QAsnEthermpID;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EOAMQueryPingHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        BussinessParams outputBussi;
        E2ELOGGER.info("handleRequestImpl: handle QAsnEtherQueryPingReq begin.");
        QAsnEtherQueryPingReq req = (QAsnEtherQueryPingReq)qReq;
        QAsnEtherQueryPingRsp rsp = (QAsnEtherQueryPingRsp)qRsp;
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(req.neID, req.slotID);
        if (null != errInfo) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = errInfo.errCode;
            return 0;
        }
        Datainterface inputData = this.createPerformInputData(req);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(req.neID, 2106041, inputData);
        int result = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if ((result == 0 || result == 1) && (outputBussi = outputData.getBussinessParams()).getRowParamsCount() > 0) {
            int frameLen = Integer.parseInt(outputBussi.getRowParams(0).getParam("frameLength").getValue());
            int timeout = Integer.parseInt(outputBussi.getRowParams(0).getParam("timeout").getValue());
            String mpID = outputBussi.getRowParams(0).getParam("mpID").getValue();
            rsp.srcMPID = TEEthServiceOAMUtil.convertMpIDNe2E2E(mpID);
            rsp.frameLen = frameLen;
            rsp.timeOut = timeout;
            String mpIP = outputBussi.getRowParams(0).getParam("mpIP").getValue();
            rsp.srcMPIP = mpIP != null && !mpIP.equals("") ? (int)Long.parseLong(mpIP, 16) : -1;
            rsp.result.isSuccess = true;
        }
        if (result != 0) {
            rsp.frameLen = -1;
            rsp.timeOut = -1;
            rsp.srcMPID = (QAsnEthermpID)req.srcMPID.clone();
            rsp.srcMPIP = -1;
            rsp.result.isSuccess = false;
            rsp.result.retCode = TEEthServiceOAMUtil.getFirstErrorCodeFromOutput(outputData);
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnEtherQueryPingReq end. result->" + result);
        return 0;
    }

    protected Datainterface createPerformInputData(QAsnEtherQueryPingReq req) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(req.neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(req.slotID));
        rowparams.addParam(param);
        param = new Param("mpID", TEEthServiceOAMUtil.convertMpIDE2E2Ne(req.srcMPID));
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

