/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ipoam.QAsnEthermpID;
import com.huawei.network.qasn.m_q_ipoam.QAsnQueryMPReq;
import com.huawei.network.qasn.m_q_ipoam.QAsnQueryMPRsp;
import com.huawei.network.qasn.m_q_ipoam.QFAsnMPInfo;
import com.huawei.network.qasn.m_q_ipoam.QFAsnMPInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMDBHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TENESlotObject;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEPortInfo;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEthOAMMPContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherOAMMPMOPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EOAMQueryMPHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();
    private static final int QUERY_FROM_NEMGR = 0;
    private static final int QUERY_FROM_NET = 1;

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnQueryMPReq begin.");
        QAsnQueryMPReq req = (QAsnQueryMPReq)qReq;
        QAsnQueryMPRsp rsp = (QAsnQueryMPRsp)qRsp;
        rsp.result = new QAsnSingleReturn();
        rsp.mpinfoList.clear();
        if (req.mpinfoList.isEmpty()) {
            E2ELOGGER.error("handleRequestImpl: QAsnQueryMPReq.mpinfoList is empty! ");
            return 0;
        }
        List<TENESlotObject> queryObjectList = this.getQueryNeSlot(req);
        TENESlotObject neslot = null;
        if (req.isfromnet == 0) {
            rsp.result.isSuccess = true;
            int len = queryObjectList.size();
            for (int i = 0; i < len; ++i) {
                neslot = queryObjectList.get(i);
                QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neslot.getNeID(), neslot.getSlotID());
                if (errInfo != null) {
                    rsp.result.retCode = errInfo.errCode;
                    rsp.result.isSuccess = false;
                    break;
                }
                Datainterface inputData = TEEthServiceOAMUtil.createQueryOAMMPInputData(neslot.getNeID(), neslot.getSlotID());
                Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neslot.getNeID(), 2105654, inputData);
                int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
                if (0 != errorCode) {
                    String tipStr = "handleRequestImpl: Query EthServiceOAMMP from ne fail! ";
                    tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neslot.getNeID(), neslot.getSlotID(), errorCode);
                    E2ELOGGER.error(tipStr);
                    rsp.result.retCode = TEEthServiceOAMUtil.getFirstErrorCodeFromOutput(outputData);
                    rsp.result.isSuccess = false;
                    continue;
                }
                rsp.mpinfoList.addAll((Collection)this.getMPInfoListFromOutput(neslot, outputData, rsp));
            }
        } else if (req.isfromnet == 1) {
            TEEthOAMMPContainer oamMpContainer = null;
            int len = queryObjectList.size();
            for (int i = 0; i < len; ++i) {
                neslot = queryObjectList.get(i);
                oamMpContainer = TEEthServiceOAMUtil.getContainer(neslot.getNeID(), neslot.getSlotID());
                if (oamMpContainer == null) {
                    E2ELOGGER.info("handleRequestImpl: oamMpContainer is null.");
                    continue;
                }
                rsp.mpinfoList.addAll((Collection)this.getMPInfoListFromDBContainer(neslot, oamMpContainer.getOAMMPList(), rsp));
            }
            rsp.result.isSuccess = true;
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnQueryMPReq end.");
        return 0;
    }

    private List<TENESlotObject> getQueryNeSlot(QAsnQueryMPReq req) {
        ArrayList<TENESlotObject> queryObjectList = new ArrayList<TENESlotObject>();
        QFAsnMPInfo asnMpInfo = null;
        TEPortInfo portInfo = null;
        int len = req.mpinfoList.size();
        for (int i = 0; i < len; ++i) {
            asnMpInfo = (QFAsnMPInfo)req.mpinfoList.get(i);
            portInfo = new TEPortInfo(asnMpInfo.portID, asnMpInfo.portType, asnMpInfo.vlanID, asnMpInfo.serviceID);
            TENESlotObject neslot = new TENESlotObject(asnMpInfo.neID, asnMpInfo.slotID);
            int index = queryObjectList.indexOf(neslot);
            if (index < 0) {
                queryObjectList.add(neslot);
            } else {
                neslot = (TENESlotObject)queryObjectList.get(index);
            }
            if (this.isValidMPID(asnMpInfo.mpID)) {
                neslot.getMpIDList().add((QAsnEthermpID)asnMpInfo.mpID.clone());
            }
            if (asnMpInfo.portID <= 0) continue;
            neslot.getPortList().add(portInfo);
        }
        return queryObjectList;
    }

    private boolean isValidMPID(QAsnEthermpID mpid) {
        if (mpid.size() >= 3) {
            int iMpID = Integer.parseInt(String.valueOf(mpid.get(0)));
            iMpID += Integer.parseInt(String.valueOf(mpid.get(1)));
            return (iMpID += Integer.parseInt(String.valueOf(mpid.get(2)))) > 0;
        }
        return false;
    }

    private QFAsnMPInfoList getMPInfoListFromDBContainer(TENESlotObject neslot, Set<TEEtherOAMMPMOPO> mpList, QAsnQueryMPRsp rsp) {
        QFAsnMPInfoList list = new QFAsnMPInfoList();
        if (!mpList.isEmpty()) {
            QFAsnMPInfo asnMpInfo = null;
            TEPortInfo portInfo = null;
            Iterator<TEEtherOAMMPMOPO> iterator = mpList.iterator();
            while (iterator.hasNext()) {
                asnMpInfo = TEE2EOAMQueryMPHandler.ethOAMMPOneInfoEms2Asn(neslot.getNeID(), neslot.getSlotID(), iterator.next());
                if (null == asnMpInfo) continue;
                portInfo = new TEPortInfo(asnMpInfo.portID, asnMpInfo.portType, asnMpInfo.vlanID, asnMpInfo.serviceID);
                if (!neslot.getPortList().isEmpty() && !neslot.getPortList().contains(portInfo) || !neslot.getMpIDList().isEmpty() && !neslot.getMpIDList().contains(asnMpInfo.mpID)) continue;
                if (asnMpInfo.issuportLT == 1) {
                    rsp.issuportLT = 1;
                    rsp.issuportPFMtest = 1;
                    rsp.issuportPing = 1;
                    rsp.issuportTboard = 0;
                }
                list.add((Object)asnMpInfo);
            }
        }
        return list;
    }

    public static QFAsnMPInfo ethOAMMPOneInfoEms2Asn(int neID, int slotID, TEEtherOAMMPMOPO ethmp) {
        QFAsnMPInfo asnmp = new QFAsnMPInfo();
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null != board) {
            boolean bSupport = TEEthServiceOAMUtil.isBoardSupportEthServiceOAM(board.getBoardType());
            asnmp.issuportLT = TEEthServiceOAMUtil.getSupport(bSupport).intValue();
            asnmp.issuportPFMtest = TEEthServiceOAMUtil.getSupport(bSupport).intValue();
            asnmp.issuportPing = TEEthServiceOAMUtil.getSupport(bSupport).intValue();
            asnmp.issuportTboard = 0;
        }
        asnmp.mpID = TEEthServiceOAMUtil.convertMpIDDB2E2E(ethmp.getMPID());
        asnmp.neID = neID;
        asnmp.slotID = slotID;
        asnmp.portType = ethmp.getPortType();
        asnmp.portID = (int)ethmp.getPortID();
        asnmp.vlanID = ethmp.getVlanID() == 65535 ? -1 : ethmp.getVlanID();
        asnmp.serviceID = ethmp.getServiceID();
        asnmp.servicetype = ethmp.getServiceType();
        asnmp.snkmpID = TEEthServiceOAMUtil.convertMpIDDB2E2E(ethmp.getSnkMPID());
        asnmp.mptype = ethmp.getMPType();
        asnmp.mplevel = ethmp.getMPLevel();
        asnmp.mpdir = ethmp.getMPDir();
        asnmp.ccStatus = ethmp.getCCStatus();
        asnmp.lbTime = ethmp.getLBTime();
        asnmp.ltTime = ethmp.getLTTime();
        asnmp.ccTime = ethmp.getCCTime();
        asnmp.pairID = 0;
        asnmp.mpinfoerr.baseinforesult.isSuccess = true;
        asnmp.mpinfoerr.ccStatusresult.isSuccess = true;
        asnmp.mpinfoerr.cctimeresult.isSuccess = true;
        asnmp.mpinfoerr.lbtimeresult.isSuccess = true;
        asnmp.mpinfoerr.lttimeresult.isSuccess = true;
        return asnmp;
    }

    private QFAsnMPInfoList getMPInfoListFromOutput(TENESlotObject neslot, Datainterface outputData, QAsnQueryMPRsp rsp) {
        QFAsnMPInfoList list = new QFAsnMPInfoList();
        TEPortInfo portInfo = null;
        if (outputData.getBussinessParams().getRowParamsCount() > 0) {
            TEEtherOAMMPMOPO mpMO = null;
            QFAsnMPInfo asnMpInfo = null;
            int len = outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                mpMO = TEEthServiceOAMDBHandler.getEthServiceOAMMPMOPO(outputData.getBussinessParams().getRowParams(i));
                if (null == mpMO) continue;
                portInfo = new TEPortInfo(Long.valueOf(mpMO.getPortID()).intValue(), mpMO.getPortType(), mpMO.getVlanID(), mpMO.getServiceID());
                if (!neslot.getPortList().isEmpty() && !neslot.getPortList().contains(portInfo) || !neslot.getMpIDList().isEmpty() && !neslot.getMpIDList().contains(TEEthServiceOAMUtil.convertMpIDDB2E2E(mpMO.getMPID())) || null == (asnMpInfo = TEE2EOAMQueryMPHandler.ethOAMMPOneInfoEms2Asn(neslot.getNeID(), neslot.getSlotID(), mpMO))) continue;
                if (asnMpInfo.issuportLT == 1) {
                    rsp.issuportLT = 1;
                    rsp.issuportPFMtest = 1;
                    rsp.issuportPing = 1;
                    rsp.issuportTboard = 0;
                }
                list.add((Object)asnMpInfo);
            }
        }
        return list;
    }
}

