/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ipoam.QAsnGetNodeInfoReq;
import com.huawei.network.qasn.m_q_ipoam.QAsnGetNodeInfoRsp;
import com.huawei.network.qasn.m_q_ipoam.QAsnNENodeInfo;
import com.huawei.network.qasn.m_q_ipoam.QAsnNENodeInfoList;
import com.huawei.network.qasn.m_q_ipoam.QAsnNodeInfo;
import com.huawei.network.qasn.m_q_ipoam.QAsnNodeInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TENESlotObject;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEPortInfo;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EOAMGetNodeInfoHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct pReq, FStruct pRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnGetNodeInfoReq begin.");
        QAsnGetNodeInfoReq req = (QAsnGetNodeInfoReq)pReq;
        QAsnGetNodeInfoRsp rsp = (QAsnGetNodeInfoRsp)pRsp;
        rsp.nenodeInfoList = new QAsnNENodeInfoList();
        rsp.result = new QAsnSingleReturn();
        List<TENESlotObject> queryObjectList = this.getQueryNeSlot(req);
        TENESlotObject neSlot = null;
        int result = 0;
        int len = queryObjectList.size();
        for (int i = 0; i < len; ++i) {
            neSlot = queryObjectList.get(i);
            result = this.getSupportInfo(neSlot, rsp);
            if (result == 0) continue;
            E2ELOGGER.info("handleRequestImpl: getSupportInfo fail.result->" + result);
            rsp.result.isSuccess = false;
            rsp.result.retCode = result;
            break;
        }
        rsp.usedMPIDList = TEEthServiceOAMUtil.getUsedMPIDList();
        E2ELOGGER.info("handleRequestImpl: handle QAsnGetNodeInfoReq end.");
        return 0;
    }

    private List<TENESlotObject> getQueryNeSlot(QAsnGetNodeInfoReq req) {
        ArrayList<TENESlotObject> queryObjectList = new ArrayList<TENESlotObject>();
        QAsnNENodeInfo neNodeInfo = null;
        TENESlotObject neslot = null;
        TEPortInfo portInfo = null;
        QAsnNodeInfo nodeInfo = null;
        int len = req.nenodeInfoList.size();
        for (int i = 0; i < len; ++i) {
            neNodeInfo = (QAsnNENodeInfo)req.nenodeInfoList.get(i);
            neslot = new TENESlotObject(neNodeInfo.neID, neNodeInfo.slotID);
            int index = queryObjectList.indexOf(neslot);
            if (index < 0) {
                queryObjectList.add(neslot);
            } else {
                neslot = (TENESlotObject)queryObjectList.get(index);
            }
            int vlanID = -1;
            int serviceID = -1;
            int lenPort = neNodeInfo.nodeInfoList.size();
            for (int j = 0; j < lenPort; ++j) {
                nodeInfo = (QAsnNodeInfo)neNodeInfo.nodeInfoList.get(j);
                if (nodeInfo.vlanID != null) {
                    vlanID = nodeInfo.vlanID;
                }
                if (nodeInfo.serviceID != -1) {
                    serviceID = nodeInfo.serviceID;
                }
                if (nodeInfo.vbID != null && nodeInfo.vbID != -1) {
                    serviceID = nodeInfo.vbID;
                }
                portInfo = new TEPortInfo(nodeInfo.portID, nodeInfo.portType, vlanID, serviceID);
                neslot.getPortList().add(portInfo);
            }
        }
        return queryObjectList;
    }

    private int getSupportInfo(TENESlotObject neSlot, QAsnGetNodeInfoRsp rsp) {
        rsp.result = new QAsnSingleReturn();
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neSlot.getNeID());
        if (0 != retCode) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = retCode;
            String tipStr = "getNodeInfo fail! ";
            tipStr = tipStr + String.format("[neID:%d,slotID:%d, retCode:%d]", neSlot.getNeID(), neSlot.getSlotID(), retCode);
            E2ELOGGER.error(tipStr);
            return retCode;
        }
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neSlot.getNeID(), neSlot.getSlotID());
        if (board == null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = 1090646021;
            return 1090646021;
        }
        boolean bSupport = TEEthServiceOAMUtil.isBoardSupportEthServiceOAM(board.getBoardType());
        if (bSupport) {
            rsp.issuportLT = 1;
            rsp.issuportPFMtest = 1;
            rsp.issuportPing = 1;
            rsp.issuportTboard = 0;
        }
        QAsnNENodeInfo nenode = new QAsnNENodeInfo();
        rsp.nenodeInfoList.add((Object)nenode);
        nenode.neID = neSlot.getNeID();
        nenode.slotID = neSlot.getSlotID();
        nenode.issuportLT = TEEthServiceOAMUtil.getSupport(bSupport).intValue();
        nenode.issuportPing = TEEthServiceOAMUtil.getSupport(bSupport).intValue();
        nenode.issuportPFMtest = TEEthServiceOAMUtil.getSupport(bSupport).intValue();
        nenode.issuportTboard = 0;
        nenode.nodeInfoList = this.getResourceNodeInfo(neSlot, rsp.result);
        nenode.result.isSuccess = true;
        rsp.result.isSuccess = true;
        return 0;
    }

    protected QAsnNodeInfoList getResourceNodeInfo(TENESlotObject neslot, QAsnSingleReturn sreturn) {
        QAsnNodeInfoList nodeInfolist = new QAsnNodeInfoList();
        Datainterface inputData = this.createPerformInputData(neslot);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neslot.getNeID(), 2105652, inputData);
        if (outputData != null) {
            BussinessParams bussiness = outputData.getBussinessParams();
            RowParams rowparams = null;
            int portid = 0;
            Param vlan = null;
            int len = bussiness.getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                rowparams = bussiness.getRowParams(i);
                portid = Integer.parseInt(rowparams.getParam("port").getValue());
                vlan = rowparams.getParam("vlanid");
                this.constactVlanID(nodeInfolist, vlan.getValue(), portid, neslot);
                int lenVlan = vlan.getOptionCount();
                for (int j = 0; j < lenVlan; ++j) {
                    this.constactVlanID(nodeInfolist, vlan.getOption(j).getValue(), portid, neslot);
                }
            }
        }
        return nodeInfolist;
    }

    private void constactVlanID(QAsnNodeInfoList nodeInfolist, String vlanid, int portid, TENESlotObject neSlot) {
        String[] vlanids = vlanid.split("-");
        if (vlanids.length >= 2) {
            QAsnNodeInfo node = new QAsnNodeInfo();
            node.portID = TEEthServiceOAMUtil.convertPortIDNE2E2E(portid);
            node.portType = TEEthServiceOAMUtil.getPortType(portid);
            int vlan = Integer.parseInt(vlanids[1]);
            node.vlanID = vlan;
            if (vlan == 65535) {
                node.vlanID = -1;
            }
            node.serviceID = Integer.parseInt(vlanids[0]);
            node.serviceType = 1;
            node.pairID = -1;
            node.dir = -1;
            node.vbID = -1;
            node.result.isSuccess = true;
            node.result.retCode = 0;
            TEPortInfo port = new TEPortInfo(node.portID, node.portType, node.vlanID, node.serviceID);
            if (neSlot.getPortList().isEmpty() || neSlot.getPortList().contains(port)) {
                nodeInfolist.add((Object)node);
            }
        }
    }

    protected Datainterface createPerformInputData(TENESlotObject neSlot) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neSlot.getNeID()));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(neSlot.getSlotID()));
        rowparams.addParam(param);
        param = new Param("slotID", String.valueOf(neSlot.getSlotID()));
        rowparams.addParam(param);
        param = new Param("linkID", "0");
        rowparams.addParam(param);
        param = new Param("linkid", "0");
        rowparams.addParam(param);
        param = new Param("vbid", "0");
        rowparams.addParam(param);
        param = new Param("vlanid", "-1");
        rowparams.addParam(param);
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return inputData;
    }
}

