/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_ipoam.QFAsnCreateMPReq;
import com.huawei.network.qasn.m_q_ipoam.QFAsnCreateMPRsp;
import com.huawei.network.qasn.m_q_ipoam.QFAsnMPInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EOAMFCreateMPHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QFAsnCreateMPReq begin.");
        QFAsnCreateMPReq req = (QFAsnCreateMPReq)qReq;
        QFAsnCreateMPRsp rsp = (QFAsnCreateMPRsp)qRsp;
        rsp.mpinfo = TEEthServiceOAMUtil.cloneMPInfo(req.mpInfo);
        int neID = req.mpInfo.neID;
        int slotID = req.mpInfo.slotID;
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neID, slotID);
        if (errInfo != null) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = errInfo.errCode;
            return 0;
        }
        Datainterface inputData = this.createPerformInputData(req.mpInfo);
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(req.mpInfo.neID, 2105653, inputData);
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (errorCode != 0) {
            rsp.result.isSuccess = false;
            rsp.result.retCode = TEEthServiceOAMUtil.getFirstErrorCodeFromOutput(outputData);
        } else {
            rsp.result.isSuccess = true;
        }
        E2ELOGGER.info("handleRequestImpl: handle QFAsnCreateMPReq end.result->" + errorCode);
        return 0;
    }

    protected Datainterface createPerformInputData(QFAsnMPInfo asnMPInfo) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        Param param1 = new Param("neid", String.valueOf(asnMPInfo.neID));
        rowparams.addParam(param1);
        param1 = new Param("slotid", String.valueOf(asnMPInfo.slotID));
        rowparams.addParam(param1);
        param1 = new Param("mpid", TEEthServiceOAMUtil.convertMpIDE2E2Ne(asnMPInfo.mpID));
        rowparams.addParam(param1);
        param1 = new Param("mdid", "0");
        rowparams.addParam(param1);
        param1 = new Param("mdName", "NULL");
        rowparams.addParam(param1);
        param1 = new Param("maid", "0");
        rowparams.addParam(param1);
        param1 = new Param("maName", "NULL");
        rowparams.addParam(param1);
        int port = TEEthServiceOAMUtil.convertPortIDE2E2NE(asnMPInfo.portID, asnMPInfo.portType);
        param1 = new Param("port", String.valueOf(port));
        rowparams.addParam(param1);
        param1 = new Param("servicetype", String.valueOf(1));
        rowparams.addParam(param1);
        if (asnMPInfo.vlanID == -1) {
            asnMPInfo.vlanID = 65535;
        }
        param1 = new Param("vlanid", String.valueOf(asnMPInfo.vlanID));
        rowparams.addParam(param1);
        param1 = new Param("serviceid", String.valueOf(asnMPInfo.serviceID));
        rowparams.addParam(param1);
        param1 = new Param("type", String.valueOf(asnMPInfo.mptype));
        rowparams.addParam(param1);
        param1 = new Param("direction", String.valueOf(asnMPInfo.mpdir));
        rowparams.addParam(param1);
        param1 = new Param("level", String.valueOf(asnMPInfo.mplevel));
        rowparams.addParam(param1);
        if (asnMPInfo.mptype == 1) {
            if (asnMPInfo.ccStatus != null && asnMPInfo.ccStatus != -1) {
                param1 = new Param("ccstatus", asnMPInfo.ccStatus.toString());
                rowparams.addParam(param1);
            }
            if (asnMPInfo.lbTime != null && asnMPInfo.lbTime != -1) {
                param1 = new Param("lbtesttime", asnMPInfo.lbTime.toString());
                rowparams.addParam(param1);
            }
            if (asnMPInfo.ltTime != null && asnMPInfo.ltTime != -1) {
                param1 = new Param("lttesttime", asnMPInfo.ltTime.toString());
                rowparams.addParam(param1);
            }
            if (asnMPInfo.ccTime != null && asnMPInfo.ccTime != -1) {
                param1 = new Param("ccperiod", asnMPInfo.ccTime.toString());
                rowparams.addParam(param1);
            }
        }
        param1 = new Param("isLogFlag", "0");
        rowparams.addParam(param1);
        bussiness.addRowParams(rowparams);
        return inputData;
    }
}

