/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipoam.QAsnCreateMPInfo;
import com.huawei.network.qasn.m_q_ipoam.QAsnCreateMPReq;
import com.huawei.network.qasn.m_q_ipoam.QAsnCreateMPRsp;
import com.huawei.network.qasn.m_q_ipoam.QFAsnMPInfo;
import com.huawei.network.qasn.m_q_ipoam.QFAsnMPInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EOAMCreateMPHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnCreateMPReq begin.");
        QAsnCreateMPReq req = (QAsnCreateMPReq)qReq;
        QAsnCreateMPRsp rsp = (QAsnCreateMPRsp)qRsp;
        rsp.result.errList = new QAsnErrInfoList();
        int neID = req.neID;
        int slotID = req.slotID;
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neID, slotID);
        if (errInfo != null) {
            rsp.result.errList.add((Object)errInfo);
            return 0;
        }
        QAsnCreateMPInfo asnMPInfo = new QAsnCreateMPInfo();
        RowParams rowParams = new RowParams();
        List<Object> mpIDList = new ArrayList();
        if (req.mpList.size() > 0) {
            mpIDList = TEEthServiceOAMUtil.getAutoAssignMPID(req.mpList.size());
        }
        if (req.taskFlag != null && req.taskFlag.length > 0 && "1".equals(new String(req.taskFlag))) {
            rsp.mpInfoList = new QFAsnMPInfoList();
        }
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        Datainterface outputData = new Datainterface();
        int errorCode = 0;
        int len = req.mpList.size();
        for (int i = 0; i < len; ++i) {
            bussiness = new BussinessParams();
            inputData.setBussinessParams(bussiness);
            asnMPInfo = (QAsnCreateMPInfo)req.mpList.get(i);
            rowParams = this.createPerformInputData(asnMPInfo, (String)mpIDList.get(i));
            bussiness.addRowParams(rowParams);
            outputData = TEEthServiceOAMUtil.performSubFunc(asnMPInfo.neID, 2105653, inputData);
            errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode != 0) {
                int[] objs = new int[]{neID};
                errInfo = TEEthServiceOAMUtil.getQAsnErrInfo(objs, TEEthServiceOAMUtil.getFirstErrorCodeFromOutput(outputData));
                rsp.result.errList.add((Object)errInfo);
                continue;
            }
            if (rsp.mpInfoList == null) continue;
            rsp.mpInfoList.add((Object)this.convertCreate2AsnMPInfo(asnMPInfo, (String)mpIDList.get(i)));
        }
        rsp.result.result = rsp.result.errList.isEmpty() ? 0 : (rsp.result.errList.size() == req.mpList.size() ? 1090646033 : 1090600984);
        E2ELOGGER.info("handleRequestImpl: handle QAsnCreateMPReq end.");
        return 0;
    }

    protected QFAsnMPInfo convertCreate2AsnMPInfo(QAsnCreateMPInfo asnMPInfo, String mpID) {
        QFAsnMPInfo mpInfoResult = new QFAsnMPInfo();
        mpInfoResult.pairID = 0;
        mpInfoResult.mpdir = asnMPInfo.mpdir;
        mpInfoResult.mpID = TEEthServiceOAMUtil.convertMpIDNe2E2E(mpID);
        mpInfoResult.mplevel = asnMPInfo.mplevel;
        mpInfoResult.mptype = asnMPInfo.mptype;
        mpInfoResult.neID = asnMPInfo.neID;
        mpInfoResult.pairID = asnMPInfo.pairID;
        mpInfoResult.slotID = asnMPInfo.slotID;
        mpInfoResult.portID = asnMPInfo.portID;
        mpInfoResult.portType = asnMPInfo.portType;
        mpInfoResult.serviceID = asnMPInfo.serviceID;
        mpInfoResult.servicetype = asnMPInfo.serviceType;
        mpInfoResult.snkmpID = TEEthServiceOAMUtil.convertMpIDDB2E2E("0");
        mpInfoResult.vlanID = asnMPInfo.vlanID;
        mpInfoResult.issuportLT = 1;
        mpInfoResult.issuportPFMtest = 1;
        mpInfoResult.issuportPing = 1;
        mpInfoResult.issuportTboard = 0;
        mpInfoResult.ccStatus = asnMPInfo.ccstatus;
        mpInfoResult.lbTime = asnMPInfo.lbtime;
        mpInfoResult.ltTime = asnMPInfo.lctime;
        mpInfoResult.ccTime = asnMPInfo.cctime;
        return mpInfoResult;
    }

    protected RowParams createPerformInputData(QAsnCreateMPInfo asnMPInfo, String mpID) {
        RowParams rowparams = new RowParams();
        Param param = new Param("neid", String.valueOf(asnMPInfo.neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(asnMPInfo.slotID));
        rowparams.addParam(param);
        param = new Param("mpid", mpID);
        rowparams.addParam(param);
        param = new Param("mdid", "0");
        rowparams.addParam(param);
        param = new Param("mdName", "NULL");
        rowparams.addParam(param);
        param = new Param("maid", "0");
        rowparams.addParam(param);
        param = new Param("maName", "NULL");
        rowparams.addParam(param);
        int port = TEEthServiceOAMUtil.convertPortIDE2E2NE(asnMPInfo.portID, asnMPInfo.portType);
        param = new Param("port", String.valueOf(port));
        rowparams.addParam(param);
        param = new Param("servicetype", String.valueOf(1));
        rowparams.addParam(param);
        if (asnMPInfo.vlanID == -1) {
            asnMPInfo.vlanID = 65535;
        }
        param = new Param("vlanid", String.valueOf(asnMPInfo.vlanID));
        rowparams.addParam(param);
        param = new Param("serviceid", String.valueOf(asnMPInfo.serviceID));
        rowparams.addParam(param);
        param = new Param("type", String.valueOf(asnMPInfo.mptype));
        rowparams.addParam(param);
        param = new Param("direction", String.valueOf(asnMPInfo.mpdir));
        rowparams.addParam(param);
        param = new Param("level", String.valueOf(asnMPInfo.mplevel));
        rowparams.addParam(param);
        if (asnMPInfo.mptype == 1) {
            if (asnMPInfo.ccstatus != -1) {
                param = new Param("ccstatus", String.valueOf(asnMPInfo.ccstatus));
                rowparams.addParam(param);
            }
            if (asnMPInfo.lbtime != -1) {
                param = new Param("lbtesttime", String.valueOf(asnMPInfo.lbtime));
                rowparams.addParam(param);
            }
            if (asnMPInfo.lctime != -1) {
                param = new Param("lttesttime", String.valueOf(asnMPInfo.lctime));
                rowparams.addParam(param);
            }
            if (asnMPInfo.cctime != -1) {
                param = new Param("ccperiod", String.valueOf(asnMPInfo.cctime));
                rowparams.addParam(param);
            }
        }
        param = new Param("isLogFlag", "0");
        rowparams.addParam(param);
        return rowparams;
    }
}

