/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ip_8021ag_model.QAsnEthOamPort;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnConfigEthPortReq;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnConfigEthPortRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.fdn.FDNUtil;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEConfigEthPortHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnConfigEthPortReq begin.");
        QAsnConfigEthPortReq req = (QAsnConfigEthPortReq)qReq;
        QAsnConfigEthPortRsp rsp = (QAsnConfigEthPortRsp)qRsp;
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        int neid = ((QAsnEthOamPort)req.oamPortList.get((int)0)).portIndex.neID;
        String fdnStr = TEEthServiceOAMUtil.getStr(((QAsnEthOamPort)req.oamPortList.get((int)0)).portIndex.strFDN);
        int shelfID = FDNUtil.getFrameID((String)fdnStr);
        int slotID = FDNUtil.getSlotID((String)fdnStr);
        slotID = TEBoardUtil.neToSlotIDNM((int)shelfID, (int)slotID);
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotID);
        if (errInfo != null) {
            rsp.oReturn.result = errInfo.errCode;
            return 0;
        }
        int len = req.oamPortList.size();
        for (int i = 0; i < len; ++i) {
            QAsnEthOamPort oamPort = (QAsnEthOamPort)req.oamPortList.get(i);
            rsp.oamPortList.add((Object)oamPort);
            bussiness.addRowParams(this.convertAsn2RowParams(oamPort));
        }
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neid, 999978, inputData);
        bussiness = outputData.getBussinessParams();
        QAsnErrInfoList errInfoList = new QAsnErrInfoList();
        int len2 = bussiness.getRowParamsCount();
        for (int i = 0; i < len2; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() <= 0) continue;
            errInfoList.add((Object)TEEthServiceOAMUtil.convertErrorRow2AsnErrInfo(row.getRowErrors(0)));
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        rsp.oReturn.result = 0 == errorCode ? 0 : (1 == errorCode ? 1090600984 : 1090646033);
        if (!errInfoList.isEmpty()) {
            rsp.oReturn.errList = errInfoList;
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnConfigEthPortReq end.");
        return 0;
    }

    private RowParams convertAsn2RowParams(QAsnEthOamPort oamPort) {
        String fdnStr = TEEthServiceOAMUtil.getStr(oamPort.portIndex.strFDN);
        int neid = oamPort.portIndex.neID;
        int shelfID = FDNUtil.getFrameID((String)fdnStr);
        int slotID = FDNUtil.getSlotID((String)fdnStr);
        int portID = FDNUtil.getPortID((String)fdnStr);
        slotID = TEBoardUtil.neToSlotIDNM((int)shelfID, (int)slotID);
        RowParams row = new RowParams();
        row.addParam("neid", String.valueOf(neid));
        row.addParam("slotid", String.valueOf(slotID));
        row.addParam("port", String.valueOf(portID));
        if (oamPort.oamEnabled >= 0) {
            row.addParam("oamenable", TEEthServiceOAMUtil.convertPMEnableNBI2NE(BigInteger.valueOf(oamPort.oamEnabled)).toString());
        }
        if (oamPort.alarmEnabled >= 0) {
            row.addParam("eventsupport", TEEthServiceOAMUtil.convertPMEnableNBI2NE(BigInteger.valueOf(oamPort.alarmEnabled)).toString());
        }
        if (oamPort.oamWorkMode >= 0) {
            row.addParam("oamworktype", TEEthServiceOAMUtil.convertPMModeNBI2NE(BigInteger.valueOf(oamPort.oamWorkMode)).toString());
        }
        if (oamPort.remoteLBEnabled >= 0) {
            row.addParam("remoteresponse", TEEthServiceOAMUtil.convertPMEnableNBI2NE(BigInteger.valueOf(oamPort.remoteLBEnabled)).toString());
        }
        if (oamPort.poTriggerIfDownStatus != null && oamPort.poTriggerIfDownStatus >= 0) {
            row.addParam("portBlock", TEEthServiceOAMUtil.convertPMEnableNBI2NE(BigInteger.valueOf(oamPort.poTriggerIfDownStatus.intValue())).toString());
        }
        if (oamPort.poLoopDetectStatus != null && oamPort.poLoopDetectStatus >= 0) {
            row.addParam("portEnable", TEEthServiceOAMUtil.convertPMEnableNBI2NE(BigInteger.valueOf(oamPort.poLoopDetectStatus.intValue())).toString());
        }
        return row;
    }
}

