/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ip_8021ag_model.QAsnEthOamInfo;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnConfigEthOAMReq;
import com.huawei.network.qasn.m_q_ip_8021ag_op.QAsnConfigEthOAMRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.fdn.FDNUtil;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEConfigEthOAMHandler
extends TEWNEMgrHandler {
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        E2ELOGGER.info("handleRequestImpl: handle QAsnConfigEthOAMReq begin.");
        QAsnConfigEthOAMReq req = (QAsnConfigEthOAMReq)qReq;
        QAsnConfigEthOAMRsp rsp = (QAsnConfigEthOAMRsp)qRsp;
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        int neid = ((QAsnEthOamInfo)req.oamInfoList.get((int)0)).portIndex.neID;
        String fdnStr = TEEthServiceOAMUtil.getStr(((QAsnEthOamInfo)req.oamInfoList.get((int)0)).portIndex.strFDN);
        int shelfID = FDNUtil.getFrameID((String)fdnStr);
        int slotID = FDNUtil.getSlotID((String)fdnStr);
        slotID = TEBoardUtil.neToSlotIDNM((int)shelfID, (int)slotID);
        QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neid, slotID);
        if (errInfo != null) {
            rsp.oReturn.result = errInfo.errCode;
            return 0;
        }
        int len = req.oamInfoList.size();
        for (int i = 0; i < len; ++i) {
            QAsnEthOamInfo oamInfo = (QAsnEthOamInfo)req.oamInfoList.get(i);
            rsp.oamInfoList.add((Object)oamInfo);
            RowParams row = this.convertAsn2RowParams(oamInfo);
            if (row == null) continue;
            bussiness.addRowParams(row);
        }
        if (bussiness.getRowParamsCount() == 0) {
            rsp.oReturn.result = 0;
            E2ELOGGER.info("handleRequestImpl: handle QAsnConfigEthOAMReq end.");
            return 0;
        }
        Datainterface outputData = TEEthServiceOAMUtil.performSubFunc(neid, 2143035, inputData);
        bussiness = outputData.getBussinessParams();
        QAsnErrInfoList errInfoList = new QAsnErrInfoList();
        int len2 = bussiness.getRowParamsCount();
        for (int i = 0; i < len2; ++i) {
            RowParams row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() <= 0) continue;
            errInfoList.add((Object)TEEthServiceOAMUtil.convertErrorRow2AsnErrInfo(row.getRowErrors(0)));
        }
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        rsp.oReturn.result = 0 == errorCode ? 0 : (1 == errorCode ? 1090600984 : 1090646033);
        if (!errInfoList.isEmpty()) {
            rsp.oReturn.errList = errInfoList;
        }
        E2ELOGGER.info("handleRequestImpl: handle QAsnConfigEthOAMReq end.");
        return 0;
    }

    private RowParams convertAsn2RowParams(QAsnEthOamInfo oamInfo) {
        int neid = oamInfo.portIndex.neID;
        String fdnStr = TEEthServiceOAMUtil.getStr(oamInfo.portIndex.strFDN);
        int shelfID = FDNUtil.getFrameID((String)fdnStr);
        int slotID = FDNUtil.getSlotID((String)fdnStr);
        int portID = FDNUtil.getPortID((String)fdnStr);
        slotID = TEBoardUtil.neToSlotIDNM((int)shelfID, (int)slotID);
        RowParams row = new RowParams();
        row.addParam("neid", String.valueOf(neid));
        row.addParam("slotid", String.valueOf(slotID));
        row.addParam("port", String.valueOf(portID));
        if (oamInfo.errorFrameMonitorWindow >= 0 && oamInfo.errorFrameMonitorThreshold >= 0) {
            row.addParam("errormonitor", String.valueOf(oamInfo.errorFrameMonitorWindow));
            row.addParam("errormonitorrange", String.valueOf(oamInfo.errorFrameMonitorThreshold));
        }
        if (oamInfo.errorFrameSecondWindow >= 0 && oamInfo.errorFrameSecondThreshold >= 0) {
            row.addParam("errormonitorsecond", String.valueOf(oamInfo.errorFrameSecondWindow));
            row.addParam("errormonitorsecondrange", String.valueOf(oamInfo.errorFrameSecondThreshold));
        }
        if (oamInfo.errorFramePeriodWindow >= 0 && oamInfo.errorFramePeriodThreshold >= 0) {
            row.addParam("errormonitorperiod", String.valueOf(oamInfo.errorFramePeriodWindow));
            row.addParam("errormonitorperiodrange", String.valueOf(oamInfo.errorFramePeriodThreshold));
        }
        if (row.getParamCount() <= 3) {
            return null;
        }
        return row;
    }
}

