/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_common.QAsnPortIndexList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipbase.QAsnGetTrunkBindReq;
import com.huawei.network.qasn.m_q_ipbase.QAsnGetTrunkBindRsp;
import com.huawei.network.qasn.m_q_ipbase.QAsnTrunkBind;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetTrunkBindHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static final int IL_SAN_GE = 32769;

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        if (null == qReq || null == qRsp) {
            e2eLogger.error("qReq or qRsp is null!");
            return 0;
        }
        String FUNC_NAME = "TEGetTrunkBindHandler.handleRequestImpl";
        TEEthE2ELog.logFuncBegin("TEGetTrunkBindHandler.handleRequestImpl");
        QAsnGetTrunkBindReq req = (QAsnGetTrunkBindReq)qReq;
        QAsnGetTrunkBindRsp rsp = (QAsnGetTrunkBindRsp)qRsp;
        QAsnPortIndexList portIndexList = req.portIndexlist;
        rsp.result.errList = new QAsnErrInfoList();
        if (portIndexList.isEmpty()) {
            TEEthE2ELog.logFuncEnd("TEGetTrunkBindHandler.handleRequestImpl");
            return 0;
        }
        int neID = -1;
        int slotID = -1;
        TENE ne = null;
        TEBoard board = null;
        QAsnPortIndex portIndex = null;
        boolean isAllSuccess = true;
        boolean isAllFail = true;
        int len = portIndexList.size();
        for (int i = 0; i < len; ++i) {
            String tipStr;
            portIndex = (QAsnPortIndex)portIndexList.get(i);
            neID = portIndex.neID;
            slotID = TEBoardUtil.neToSlotIDNM((int)TEBoardUtil.convertShelfID((Integer)portIndex.shelfID), (int)portIndex.slotID);
            ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                tipStr = "handleRequestImpl: Get trunk bind fail! The ne is not exist! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                this.fillErrorToRsp(rsp, neID, slotID, 1090596385);
                isAllSuccess = false;
                continue;
            }
            board = ne.getBoard(slotID);
            if (null == board) {
                tipStr = "handleRequestImpl: Get trunk bind fail! The board is not exist! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                this.fillErrorToRsp(rsp, neID, slotID, 1090646021);
                isAllSuccess = false;
                continue;
            }
            if (!TEEthXCUtil.isEthBoard(board.getBoardType())) {
                tipStr = "handleRequestImpl: Get trunk bind fail! The board is not eth board! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                continue;
            }
            if (0 == this.getTrunkBind(portIndex, rsp)) {
                isAllFail = false;
                continue;
            }
            isAllSuccess = false;
        }
        this.constructGlobalErrCode(rsp, isAllSuccess, isAllFail);
        TEEthE2ELog.logFuncEnd("TEGetTrunkBindHandler.handleRequestImpl");
        return 0;
    }

    private void fillErrorToRsp(QAsnGetTrunkBindRsp rsp, int neID, int slotID, int errorCode) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.errCode = errorCode;
        errInfo.objID = new QAsnTinyIntList();
        errInfo.objID.add((Object)neID);
        errInfo.objID.add((Object)slotID);
        rsp.result.errList.add((Object)errInfo);
    }

    private void constructGlobalErrCode(QAsnGetTrunkBindRsp rsp, boolean isAllSuccess, boolean isAllFail) {
        rsp.result.result = isAllSuccess ? 0 : (isAllFail ? 1090650122 : 1090650121);
    }

    private int getTrunkBind(QAsnPortIndex portIndex, QAsnGetTrunkBindRsp rsp) {
        int retCode = 0;
        int cnemgrSlotID = TEBoardUtil.neToSlotIDNM((int)TEBoardUtil.convertShelfID((Integer)portIndex.shelfID), (int)portIndex.slotID);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(portIndex.neID, cnemgrSlotID);
        ArrayList vcPortList = TEConfigurationDataMgr.getInstance().getETHVCTrunkPort(portIndex.neID, boardType);
        int len = vcPortList.size();
        for (int i = 0; i < len; ++i) {
            this.getTrunkBindPort(boardType, this.constructPortIndex(portIndex, (Integer)vcPortList.get(i)), rsp);
        }
        return retCode;
    }

    private QAsnPortIndex constructPortIndex(QAsnPortIndex portIndex, int portID) {
        QAsnPortIndex newPortIndex = new QAsnPortIndex();
        newPortIndex.oneID = portIndex.oneID;
        newPortIndex.neID = portIndex.neID;
        newPortIndex.shelfID = portIndex.shelfID;
        newPortIndex.slotID = portIndex.slotID;
        newPortIndex.subSlotID = portIndex.subSlotID;
        newPortIndex.portID = portID;
        return newPortIndex;
    }

    private int getTrunkBindPort(int boardType, QAsnPortIndex vctrunkPortIndex, QAsnGetTrunkBindRsp rsp) {
        int retCode = 0;
        int vctrunkPortID = vctrunkPortIndex.portID;
        int portID = TEQueryPortForDataMgr.getAbstractPortID((int)vctrunkPortIndex.neID, (int)(vctrunkPortID % 32768 + 100));
        int wdmPortID = TEQueryPortForDataMgr.getAbstractPortID((int)vctrunkPortIndex.neID, (int)portID);
        QAsnTrunkBind trunkBind = new QAsnTrunkBind();
        trunkBind.portIndex = this.constructPortIndex(vctrunkPortIndex, wdmPortID);
        trunkBind.trunkPortIndex = vctrunkPortIndex;
        trunkBind.boardType = boardType;
        trunkBind.level = 32769;
        trunkBind.isActive = 1;
        rsp.trunkBindList.add((Object)trunkBind);
        return retCode;
    }

    protected boolean isLogReq() {
        return false;
    }

    protected boolean isLogRsp() {
        return false;
    }
}

