/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCIndex;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnGetEthXCReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnGetEthXCRsp;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEGetAllEthXCHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECheckEmpty;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TEGetEthXCHandler
extends TEGetAllEthXCHandler {
    @Override
    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        QAsnGetEthXCReq req = (QAsnGetEthXCReq)qReq;
        QAsnGetEthXCRsp rsp = (QAsnGetEthXCRsp)qRsp;
        String FUNC_NAME = "QAsnGetEthXCReq.handleRequestImpl";
        if (TEEthE2ECheckEmpty.isListEmpty((List<Object>)req.xcIndexList, "QAsnGetEthXCReq.handleRequestImpl", "req.xcInfoList")) {
            TEEthE2ELog.logFuncEnd("QAsnGetEthXCReq.handleRequestImpl");
            return 0;
        }
        rsp.result.errList = new QAsnErrInfoList();
        int length = req.xcIndexList.size();
        for (int i = 0; i < length; ++i) {
            QAsnEthXCIndex ethxc = (QAsnEthXCIndex)req.xcIndexList.get(i);
            int neID = ethxc.neID;
            int slotID = ethxc.slotID;
            QAsnErrInfo errInfo = TEEthServiceOAMUtil.qInterfaceErrorCheck(neID, slotID);
            if (errInfo != null) {
                rsp.result.errList.add((Object)errInfo);
                continue;
            }
            QAsnEthXCInfoList ethXCInfoList = this.getEVPLFromDB(neID, slotID);
            QAsnEthXCInfo ethxcInfo = this.getQAsnEthXCInfo(ethXCInfoList, ethxc.xcID);
            if (ethxcInfo != null) {
                QAsnEthXCInfo coupleEthxcInfo = this.findConpleEthXC(ethXCInfoList, ethxcInfo);
                ethXCInfoList.clear();
                ethXCInfoList.add((Object)ethxcInfo);
                if (coupleEthxcInfo != null) {
                    ethXCInfoList.add((Object)coupleEthxcInfo);
                }
                rsp.xcInfoList.addAll((Collection)ethXCInfoList);
            }
            ethXCInfoList = TEE2EVBUtil.getVBLinkFromDB(neID, slotID);
            for (int j = ethXCInfoList.size() - 1; j >= 0; --j) {
                QAsnEthXCInfo ethxcinfo = (QAsnEthXCInfo)ethXCInfoList.get(j);
                if (ethxcinfo.xcIndex.xcID == ethxc.xcID) continue;
                ethXCInfoList.remove(j);
            }
            rsp.xcInfoList.addAll((Collection)ethXCInfoList);
        }
        rsp.result.result = rsp.result.errList.isEmpty() ? 0 : (rsp.xcInfoList.isEmpty() ? 1090650122 : 1090650121);
        TEEthE2ELog.logFuncEnd("QAsnGetEthXCReq.handleRequestImpl");
        return 0;
    }

    private QAsnEthXCInfo getQAsnEthXCInfo(QAsnEthXCInfoList ethXCInfoList, int xcID) {
        QAsnEthXCInfo qasnInfo = null;
        for (int j = ethXCInfoList.size() - 1; j >= 0; --j) {
            QAsnEthXCInfo ethxcinfo = (QAsnEthXCInfo)ethXCInfoList.get(j);
            if (ethxcinfo.xcIndex.xcID != xcID) continue;
            qasnInfo = (QAsnEthXCInfo)ethXCInfoList.get(j);
            break;
        }
        return qasnInfo;
    }

    private QAsnEthXCInfo findConpleEthXC(QAsnEthXCInfoList ethXCInfoList, QAsnEthXCInfo xcInfo) {
        QAsnEthXCInfo qasnInfo = null;
        for (int j = ethXCInfoList.size() - 1; j >= 0; --j) {
            QAsnEthXCInfo ethxcinfo = (QAsnEthXCInfo)ethXCInfoList.get(j);
            if (!this.isCoupleEvpl(ethxcinfo, xcInfo)) continue;
            qasnInfo = ethxcinfo;
            break;
        }
        return qasnInfo;
    }

    protected boolean isCoupleEvpl(QAsnEthXCInfo evpl1, QAsnEthXCInfo evpl2) {
        int srcPort1 = TEEthXCUtil.getWebLCTPortID(evpl1.xcAttr.srcEndTP.portID, evpl1.xcAttr.srcEndTP.portType);
        int snkPort1 = TEEthXCUtil.getWebLCTPortID(evpl1.xcAttr.snkEndTP.portID, evpl1.xcAttr.snkEndTP.portType);
        int srcPort2 = TEEthXCUtil.getWebLCTPortID(evpl2.xcAttr.srcEndTP.portID, evpl2.xcAttr.srcEndTP.portType);
        int snkPort2 = TEEthXCUtil.getWebLCTPortID(evpl2.xcAttr.snkEndTP.portID, evpl2.xcAttr.snkEndTP.portType);
        if (evpl1.xcIndex.neID != evpl2.xcIndex.neID || evpl1.xcIndex.slotID != evpl2.xcIndex.slotID || evpl1.xcAttr.isActive != evpl2.xcAttr.isActive || srcPort1 != snkPort2 || snkPort1 != srcPort2) {
            return false;
        }
        return evpl2.xcAttr.srcEndTP.vlanID == evpl1.xcAttr.snkEndTP.vlanID && evpl2.xcAttr.snkEndTP.vlanID == evpl1.xcAttr.srcEndTP.vlanID && evpl1.xcAttr.srcEndTP.svlanID == evpl2.xcAttr.snkEndTP.svlanID && evpl1.xcAttr.snkEndTP.svlanID == evpl2.xcAttr.srcEndTP.svlanID;
    }
}

