/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_common.QAsnCPIndexList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipbase.QAsnGetCPSupportInfo;
import com.huawei.network.qasn.m_q_ipbase.QAsnGetCPSupportReq;
import com.huawei.network.qasn.m_q_ipbase.QAsnGetCPSupportRsp;
import com.huawei.network.qasn.m_q_ipbase.QSupportAttrInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCParseCPSPCfgFile;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetCPSupportHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    protected static final String ATTR_SERVICETYPE = "W32PORT_ATTR_ST_SERVICETYPE";
    protected static final String ATTR_SERVICETYPE_2 = "W32PORT_ATTR_ST_SERVICETYPE_2";

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        String FUNC_NAME = "TEGetCPSupportHandler.handleRequestImpl";
        TEEthE2ELog.logFuncBegin("TEGetCPSupportHandler.handleRequestImpl");
        QAsnGetCPSupportReq req = (QAsnGetCPSupportReq)qReq;
        QAsnGetCPSupportRsp rsp = (QAsnGetCPSupportRsp)qRsp;
        QAsnCPIndexList cpIndexList = req.cpIndexlist;
        rsp.errorInfo.errList = new QAsnErrInfoList();
        if (cpIndexList.isEmpty()) {
            e2eLogger.info("handleRequestImpl: The request cp index is empty!");
            return 0;
        }
        int neID = -1;
        int slotID = -1;
        TENE ne = null;
        TEBoard board = null;
        QAsnCPIndex cpIndex = null;
        boolean isAllSuccess = true;
        boolean isAllFail = true;
        int len = cpIndexList.size();
        for (int i = 0; i < len; ++i) {
            String tipStr;
            cpIndex = (QAsnCPIndex)cpIndexList.get(i);
            neID = cpIndex.neID;
            slotID = cpIndex.slotID;
            if (cpIndex.shelfID != null) {
                slotID = TEBoardUtil.neToSlotIDNM((int)cpIndex.shelfID, (int)cpIndex.slotID);
            }
            if (null == (ne = TENEListMgr.getInstance().getNE(neID))) {
                tipStr = "handleRequestImpl: Get cp support fail! The ne is not exist! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                this.fillErrorToRsp(rsp, neID, slotID, 1090596385);
                isAllSuccess = false;
                continue;
            }
            board = ne.getBoard(slotID);
            if (null == board) {
                tipStr = "handleRequestImpl: Get cp support fail! The ne is not exist! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                this.fillErrorToRsp(rsp, neID, slotID, 1090646021);
                isAllSuccess = false;
                continue;
            }
            if (0 == this.getCPSupport(cpIndex, rsp)) {
                isAllFail = false;
                continue;
            }
            isAllSuccess = false;
        }
        this.constructGlobalErrCode(rsp, isAllSuccess, isAllFail);
        TEEthE2ELog.logFuncEnd("TEGetCPSupportHandler.handleRequestImpl");
        return 0;
    }

    private void fillErrorToRsp(QAsnGetCPSupportRsp rsp, int neID, int slotID, int errorCode) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.errCode = errorCode;
        errInfo.objID = new QAsnTinyIntList();
        errInfo.objID.add((Object)neID);
        errInfo.objID.add((Object)slotID);
        rsp.errorInfo.errList.add((Object)errInfo);
    }

    private int getCPSupport(QAsnCPIndex cpIndex, QAsnGetCPSupportRsp rsp) {
        int retCode = 0;
        int slotID = cpIndex.slotID;
        if (cpIndex.shelfID != null) {
            slotID = TEBoardUtil.neToSlotIDNM((int)cpIndex.shelfID, (int)cpIndex.slotID);
        }
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(cpIndex.neID, slotID);
        Map<Integer, Integer> attrSPInfoMap = TEEthXCParseCPSPCfgFile.getInstance().getAttrMap(boardType);
        QAsnGetCPSupportInfo cpSPInfo = this.constructSPInfo(cpIndex, attrSPInfoMap);
        if (!cpSPInfo.supportAttrList.isEmpty()) {
            rsp.cpsupportInfo.add((Object)cpSPInfo);
        } else {
            String tipStr = "getCPSupport: Get cp support. supportAttrList is empty! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, boardType:%d]", cpIndex.neID, slotID, boardType);
            e2eLogger.info(tipStr);
        }
        return retCode;
    }

    private QAsnGetCPSupportInfo constructSPInfo(QAsnCPIndex cpIndex, Map<Integer, Integer> attrSPInfoMap) {
        QAsnGetCPSupportInfo cpSPInfo = new QAsnGetCPSupportInfo();
        cpSPInfo.cpIndex = cpIndex;
        Iterator<Map.Entry<Integer, Integer>> iter = attrSPInfoMap.entrySet().iterator();
        Map.Entry<Integer, Integer> entry = null;
        while (iter.hasNext()) {
            entry = iter.next();
            cpSPInfo.supportAttrList.add((Object)this.contructSPAttrInfo(entry.getKey(), entry.getValue()));
        }
        cpSPInfo.supportAttrList.add((Object)this.addAnyAttrInfo(cpIndex));
        return cpSPInfo;
    }

    private QSupportAttrInfo addAnyAttrInfo(QAsnCPIndex cpIndex) {
        int neID = cpIndex.neID;
        int slotID = cpIndex.slotID;
        if (cpIndex.shelfID != null) {
            slotID = TEBoardUtil.neToSlotIDNM((int)cpIndex.shelfID, (int)cpIndex.slotID);
        }
        int isSupportAny = this.isSupportAnyAttr(neID, slotID);
        QSupportAttrInfo attrInfo = new QSupportAttrInfo();
        attrInfo.attrID = 15;
        attrInfo.supportValue = isSupportAny;
        attrInfo.sdhLevel = -1;
        return attrInfo;
    }

    private int isSupportAnyAttr(int neID, int slotID) {
        String[] serviceTypeAttr;
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        int BDTYPE_TN11TQX = 1197;
        ArrayList<Integer> specialBoard = new ArrayList<Integer>();
        specialBoard.add(1572);
        specialBoard.add(1600);
        specialBoard.add(1568);
        specialBoard.add(1197);
        specialBoard.add(1196);
        specialBoard.add(1087);
        if (specialBoard.contains(boardType)) {
            return 1;
        }
        for (String attr : serviceTypeAttr = new String[]{ATTR_SERVICETYPE, ATTR_SERVICETYPE_2}) {
            if (!TEGenCfgDataMgr.isBoardSupportAttr((int)neID, (int)boardType, (String)attr)) continue;
            return 1;
        }
        return 0;
    }

    private QSupportAttrInfo contructSPAttrInfo(Integer key, Integer value) {
        QSupportAttrInfo attrInfo = new QSupportAttrInfo();
        attrInfo.attrID = key;
        attrInfo.supportValue = value;
        attrInfo.sdhLevel = -1;
        return attrInfo;
    }

    private void constructGlobalErrCode(QAsnGetCPSupportRsp rsp, boolean isAllSuccess, boolean isAllFail) {
        rsp.errorInfo.result = isAllSuccess ? 0 : (isAllFail ? 1090650122 : 1090650121);
    }

    protected boolean isLogReq() {
        return false;
    }

    protected boolean isLogRsp() {
        return false;
    }
}

