/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnGetAllEthXCReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnGetAllEthXCRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECheckEmpty;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.po.embeddednemgrmo.TENEMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetAllEthXCHandler
extends TEWNEMgrHandler {
    protected static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        if (null == qReq || null == qRsp) {
            e2eLogger.error("qReq or qRsp is null!");
            return 0;
        }
        String FUNC_NAME = "TEGetAllEthXCHandler.handleRequestImpl";
        TEEthE2ELog.logFuncBegin("TEGetAllEthXCHandler.handleRequestImpl");
        QAsnGetAllEthXCReq req = (QAsnGetAllEthXCReq)qReq;
        QAsnGetAllEthXCRsp rsp = (QAsnGetAllEthXCRsp)qRsp;
        if (TEEthE2ECheckEmpty.isListEmpty((List<Object>)req.cpIndexList, "TEGetAllEthXCHandler.handleRequestImpl", "req.xcInfoList")) {
            TEEthE2ELog.logFuncEnd("TEGetAllEthXCHandler.handleRequestImpl");
            return 0;
        }
        QAsnCPIndex index = null;
        int neID = -1;
        int slotID = -1;
        TENE ne = null;
        TEBoard board = null;
        QAsnErrInfo errInfo = null;
        rsp.result.errList = new QAsnErrInfoList();
        int length = req.cpIndexList.size();
        for (int i = 0; i < length; ++i) {
            String tipStr;
            index = (QAsnCPIndex)req.cpIndexList.get(i);
            neID = index.neID;
            ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                tipStr = "handleRequestImpl: The ne is not exist! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                errInfo = new QAsnErrInfo();
                errInfo.errCode = 1090596385;
                errInfo.objID = new QAsnTinyIntList();
                errInfo.objID.add((Object)neID);
                rsp.result.errList.add((Object)errInfo);
                continue;
            }
            slotID = index.slotID;
            if (index.shelfID != null) {
                slotID = TEBoardUtil.neToSlotIDNM((int)index.shelfID, (int)index.slotID);
            }
            if (null == (board = ne.getBoard(slotID))) {
                tipStr = "handleRequestImpl: The board is not exist! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                errInfo = new QAsnErrInfo();
                errInfo.errCode = 1090646021;
                errInfo.objID = new QAsnTinyIntList();
                errInfo.objID.add((Object)neID);
                errInfo.objID.add((Object)slotID);
                rsp.result.errList.add((Object)errInfo);
                continue;
            }
            QAsnEthXCInfoList ethXCInfoList = this.getEVPLFromDB(neID, slotID);
            ethXCInfoList = TEEthXCUtil.coupleEVPL(ethXCInfoList);
            rsp.xcList.addAll((Collection)ethXCInfoList);
            rsp.xcList.addAll((Collection)TEE2EVBUtil.getVBLinkFromDB(neID, slotID));
        }
        this.constructGlobalErrCode(rsp, neID);
        TEEthE2ELog.logFuncEnd("TEGetAllEthXCHandler.handleRequestImpl");
        return 0;
    }

    protected QAsnEthXCInfoList getEVPLFromDB(int neID, int slotID) {
        QAsnEthXCInfoList infoList = new QAsnEthXCInfoList();
        TEEtherEVPLContainer container = null;
        TEEtherEVPLMOPO evplMO2 = null;
        QAsnEthXCInfo asnEVPLMO = null;
        List<TEEtherEVPLMOPO> evplMOList = null;
        Iterator<TEEtherEVPLMOPO> iter = null;
        container = TEEthXCUtil.getContainer(neID, slotID);
        if (null == container) {
            String tipStr = "getEVPLFromDB: The container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            return infoList;
        }
        evplMOList = TEEthXCUtil.getSortedEVPLMOList(neID, slotID, container.getEVPLList());
        for (TEEtherEVPLMOPO evplMO2 : evplMOList) {
            asnEVPLMO = TEEthXCUtil.mo2AsnEthXC(neID, slotID, evplMO2);
            infoList.add((Object)asnEVPLMO);
        }
        return infoList;
    }

    private void constructGlobalErrCode(QAsnGetAllEthXCRsp rsp, int neID) {
        if (rsp.result.errList.isEmpty()) {
            rsp.result.result = 0;
        } else if (rsp.xcList.isEmpty()) {
            rsp.result.result = 1090650122;
            this.checkPreNE(rsp, neID);
        } else {
            rsp.result.result = 1090650121;
        }
    }

    private void checkPreNE(QAsnGetAllEthXCRsp rsp, int neID) {
        try {
            if (neID <= 0) {
                e2eLogger.error("neid is invalid! ");
                return;
            }
            TEDaoOperationResult drb = null;
            try {
                drb = TECommonDaoService.findNE_NonLock((int[])new int[]{neID});
            }
            catch (Exception e) {
                e2eLogger.error("get ne mo failed!" + neID, (Throwable)e);
            }
            if (null == drb || 0 != drb.getResult()) {
                e2eLogger.error("get ne mo failed!" + neID);
                return;
            }
            List cmgrNEList = drb.getData();
            if (cmgrNEList.isEmpty()) {
                e2eLogger.error("get ne mo data is null!" + neID);
                return;
            }
            TENEMOPO nepo = (TENEMOPO)cmgrNEList.get(0);
            if (nepo.isPreConfig()) {
                rsp.result.result = 0;
            }
        }
        catch (Exception e) {
            e2eLogger.error("check ne failed!" + neID);
        }
    }

    protected boolean isLogReq() {
        return true;
    }

    protected boolean isLogRsp() {
        return TEEthXCUtil.isLogOnDebug();
    }
}

