/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_common.QAsnCPIndexList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCAttr;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCIndex;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCTP;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPLMgmtSuper;
import com.huawei.nglct.nemgr.ip.ngwdm.service_v2r6c01.TEEVPLMgmt;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLinkMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.cache.TETimeStatMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;

public final class TEEthXCUtil {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEEthXCUtil() {
    }

    public static TEEtherEVPLContainer getContainer(int neID, int slotID) {
        String FUNC_NAME = "TEEthXCUtil.getContainer";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.getContainer");
        TETimeStatMgr timer = new TETimeStatMgr(TETimeStatMgr.FLAG_LOG);
        timer.startStat("get container time2:");
        TEEtherEVPLContainer container = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotID}, TEEtherEVPLContainer.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotID}, TEEtherEVPLContainer.class);
            if (null == dbResult) {
                String tipStr = "getContainer: Get evpl container fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                TEEthE2ELog.logFuncEnd("TEEthXCUtil.getContainer");
                return container;
            }
        }
        catch (Exception e) {
            String tipStr = "getContainer: Get evpl container fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr, (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.getContainer");
            return container;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                container = (TEEtherEVPLContainer)data.get(0);
            }
        } else {
            String tipStr = "getContainer: Get evpl container fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
            e2eLogger.error(tipStr);
        }
        timer.stopStat(TELogFactory.getE2ELogger());
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.getContainer");
        return container;
    }

    public static QAsnEthXCInfo mo2AsnEthXC(int neID, int slotID, TEEtherEVPLMOPO evplMO) {
        QAsnEthXCInfo asnEVPLMO = new QAsnEthXCInfo();
        short linkType = evplMO.getServiceType();
        int srcCVlan = evplMO.getSrcVlanID();
        int snkCVlan = evplMO.getSnkVlanID();
        byte e2eServiceType = TEEthXCUtil.getE2EServiceType(linkType, srcCVlan, snkCVlan);
        QAsnEthXCIndex index = asnEVPLMO.xcIndex;
        QAsnEthXCAttr xcAttr = asnEVPLMO.xcAttr;
        QAsnEthXCTP srcEndTP = xcAttr.srcEndTP;
        QAsnEthXCTP snkEndTP = xcAttr.snkEndTP;
        index.neID = neID;
        index.slotID = slotID;
        index.xcID = evplMO.getIDNE();
        index.xcType = e2eServiceType;
        index.linkType = evplMO.getServiceType();
        xcAttr.vbID = -1;
        xcAttr.serialID = -1;
        xcAttr.direction = evplMO.getDirection();
        xcAttr.isActive = evplMO.getActivateState();
        xcAttr.ringDir = evplMO.getRPRRingDir();
        xcAttr.snkNodeNo = evplMO.getRPRdstNodeID();
        int srcPortID = (int)evplMO.getSrcPortID();
        srcEndTP.portID = TEEthXCUtil.getE2EPortID(srcPortID);
        srcEndTP.portType = TEEthXCUtil.getE2EPortType(srcPortID);
        srcEndTP.vlanID = TEEthXCUtil.getE2EVlanID(evplMO.getSrcVlanID());
        srcEndTP.svlanID = TEEthXCUtil.getE2EVlanID(evplMO.getSrcSVlanID());
        srcEndTP.tunnelLabel = -1;
        srcEndTP.vcLabel = -1;
        int snkPortID = (int)evplMO.getSnkPortID();
        snkEndTP.portID = TEEthXCUtil.getE2EPortID(snkPortID);
        snkEndTP.portType = TEEthXCUtil.getE2EPortType(snkPortID);
        snkEndTP.vlanID = TEEthXCUtil.getE2EVlanID(evplMO.getSnkVlanID());
        snkEndTP.svlanID = TEEthXCUtil.getE2EVlanID(evplMO.getSnkSVlanID());
        snkEndTP.tunnelLabel = -1;
        snkEndTP.vcLabel = -1;
        return asnEVPLMO;
    }

    public static QAsnEthXCInfoList poEthXC2AsnEthXC(int neID, int slotID, List<TEEtherEVPLMOPO> evplMOList) {
        QAsnEthXCInfoList xcInfoList = new QAsnEthXCInfoList();
        if (null == evplMOList) {
            return xcInfoList;
        }
        QAsnEthXCInfo asnEVPLMO = null;
        for (TEEtherEVPLMOPO evplMO : evplMOList) {
            asnEVPLMO = TEEthXCUtil.mo2AsnEthXC(neID, slotID, evplMO);
            xcInfoList.add((Object)asnEVPLMO);
        }
        return xcInfoList;
    }

    private static int getE2EVlanID(int webVlan) {
        int e2eVlan = webVlan;
        if (65535 == webVlan) {
            e2eVlan = -1;
        }
        return e2eVlan;
    }

    public static int getWebLCTVlanID(int e2eVlan) {
        int webVlan = e2eVlan;
        if (-1 == e2eVlan) {
            webVlan = 65535;
        }
        return webVlan;
    }

    public static TEEtherEVPLMOPO asn2moEthXC(QAsnEthXCInfo ethXCInfo) {
        TEEtherEVPLMOPO evplPO = new TEEtherEVPLMOPO();
        int e2eSrcPortID = ethXCInfo.xcAttr.srcEndTP.portID;
        int e2eSnkPortID = ethXCInfo.xcAttr.snkEndTP.portID;
        int e2eSrcPortType = ethXCInfo.xcAttr.srcEndTP.portType;
        int e2eSnkPortType = ethXCInfo.xcAttr.snkEndTP.portType;
        int weblctSrcPortID = TEEthXCUtil.getWebLCTPortID(e2eSrcPortID, e2eSrcPortType);
        int weblctSnkPortID = TEEthXCUtil.getWebLCTPortID(e2eSnkPortID, e2eSnkPortType);
        int xcType = ethXCInfo.xcIndex.xcType;
        int linkType = ethXCInfo.xcIndex.linkType;
        int serviceType = TEEthXCUtil.getMOSerivceType(xcType, linkType);
        evplPO.setIDNE(ethXCInfo.xcIndex.xcID);
        evplPO.setDirection((short)0);
        evplPO.setServiceType((short)serviceType);
        evplPO.setSrcPortID((long)weblctSrcPortID);
        evplPO.setSrcPortType((short)e2eSrcPortType);
        evplPO.setSrcVlanID(TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.srcEndTP.vlanID));
        evplPO.setSrcSVlanID(TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.srcEndTP.svlanID));
        evplPO.setSrcTunnelLabel((long)ethXCInfo.xcAttr.srcEndTP.tunnelLabel);
        evplPO.setSrcVCLabel((long)ethXCInfo.xcAttr.srcEndTP.vcLabel);
        evplPO.setSnkPortID((long)weblctSnkPortID);
        evplPO.setSnkPortType((short)e2eSnkPortType);
        evplPO.setSnkVlanID(TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.snkEndTP.vlanID));
        evplPO.setSnkSVlanID(TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.snkEndTP.svlanID));
        evplPO.setSnkTunnelLabel((long)ethXCInfo.xcAttr.snkEndTP.tunnelLabel);
        evplPO.setSnkVCLabel((long)ethXCInfo.xcAttr.snkEndTP.vcLabel);
        evplPO.setPktPRI(0);
        evplPO.setSVlanPRI(0);
        evplPO.setForwardPRI(-1);
        evplPO.setActivateState((short)ethXCInfo.xcAttr.isActive);
        evplPO.setRPRdstNodeID((short)-1);
        evplPO.setRPRFwdPRI((short)-1);
        evplPO.setRPRRingDir((short)-1);
        evplPO.setLinkOAM(-1);
        return evplPO;
    }

    private static int getMOSerivceType(int xcType, int linkType) {
        int moServiceType = xcType;
        if (4 == xcType) {
            moServiceType = linkType;
        }
        return moServiceType;
    }

    public static int getWebLCTPortID(int portID, int portType) {
        int newPortID = portID;
        if (1 == portType) {
            newPortID += 32768;
        } else if (3 == portType) {
            newPortID += 28672;
        }
        return newPortID;
    }

    public static int saveContainerToDB(int neID, int slotID, TEEtherEVPLContainer container) {
        String tipStr;
        String FUNC_NAME = "TEEthXCUtil.saveContainerToDB";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.saveContainerToDB");
        if (null == container) {
            String tipStr2 = "saveContainerToDB: The container is null! ";
            tipStr2 = tipStr2 + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.info(tipStr2);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.saveContainerToDB");
            return 0;
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID, slotID}, (Object)container) : TECommonDaoService.update_NonLock((int[])new int[]{neID, slotID}, (Object)container);
            if (null == dbResult) {
                String tipStr3 = "saveContainerToDB: Save query evpl result fail! The dbResult is null! ";
                tipStr3 = tipStr3 + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr3);
                TEEthE2ELog.logFuncEnd("TEEthXCUtil.saveContainerToDB");
                return 1092743443;
            }
            tipStr = "saveContainerToDB: Save evpl result. ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, dbResult.result:%d]", neID, slotID, dbResult.getResult());
            e2eLogger.info(tipStr);
        }
        catch (Exception e) {
            TELogFactory.getE2ELogger().error("saveContainerToDB: Save evpl result fail!", (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.saveContainerToDB");
            return 2;
        }
        int retCode = dbResult.getResult();
        tipStr = "saveContainerToDB: Save evpl result. ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
        e2eLogger.error(tipStr);
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.saveContainerToDB");
        return retCode;
    }

    public static Set<Integer> connectSBIForNE(QAsnEthXCInfoList xcInfoList, QAsnErrInfoList errInfoList) {
        String FUNC_NAME = "TEEthXCUtil.connectSBIForNE";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.connectSBIForNE");
        HashSet<Integer> neIDSet = new HashSet<Integer>();
        QAsnEthXCInfo ethXCInfo = null;
        int len = xcInfoList.size();
        for (int i = 0; i < len; ++i) {
            ethXCInfo = (QAsnEthXCInfo)xcInfoList.get(i);
            neIDSet.add(ethXCInfo.xcIndex.neID);
        }
        Set<Integer> normarNESet = TEEthXCUtil.connectSBIForNEImpl(errInfoList, neIDSet);
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.connectSBIForNE");
        return normarNESet;
    }

    public static Set<Integer> connectSBIForNE(QAsnCPIndexList cpIndexList, QAsnErrInfoList errInfoList) {
        HashSet<Integer> neIDSet = new HashSet<Integer>();
        QAsnCPIndex cpIndex = null;
        int len = cpIndexList.size();
        for (int i = 0; i < len; ++i) {
            cpIndex = (QAsnCPIndex)cpIndexList.get(i);
            neIDSet.add(cpIndex.neID);
        }
        return TEEthXCUtil.connectSBIForNEImpl(errInfoList, neIDSet);
    }

    public static Set<Integer> connectSBIForNEImpl(QAsnErrInfoList errInfoList, Set<Integer> neIDSet) {
        HashSet<Integer> normalNEIDSet = new HashSet<Integer>();
        int neID2 = -1;
        int result = -1;
        for (int neID2 : neIDSet) {
            result = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID2);
            if (0 != result) {
                QAsnErrInfo errInfo = new QAsnErrInfo();
                errInfo.errCode = result;
                errInfo.objID = new QAsnTinyIntList();
                errInfo.objID.add((Object)neID2);
                errInfoList.add((Object)errInfo);
                TELogFactory.getE2ELogger().error("connectSBIForNEImpl: Connect to ne failed! neID->" + neID2);
                continue;
            }
            normalNEIDSet.add(neID2);
        }
        return normalNEIDSet;
    }

    public static byte getE2EServiceType(int neLinkType, int srcVlan, int snkVlan) {
        int serviceType = 0;
        serviceType = 0 == neLinkType ? 0 : (1 == neLinkType ? 1 : 4);
        return (byte)serviceType;
    }

    public static SubFunc createSubFunc(int neID, int sfid) {
        String FUNC_NAME = "TEEthXCUtil.createSubFunc";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.createSubFunc");
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e) {
            TELogFactory.getE2ELogger().error("createSubFunc: Get SubFunc fail!", (Throwable)e);
        }
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.createSubFunc");
        return subFunc;
    }

    public static int delEvplFromContainer(TEEtherEVPLContainer container, int linkID) {
        int retCode = 0;
        Set evplMOSet = null;
        Iterator evplMOIter = null;
        TEEtherEVPLMOPO evplMO = null;
        evplMOSet = container.getEVPLList();
        evplMOIter = evplMOSet.iterator();
        boolean isDel = false;
        while (evplMOIter.hasNext()) {
            evplMO = (TEEtherEVPLMOPO)evplMOIter.next();
            if (!TEEthXCUtil.isEVPLToFind(linkID, evplMO)) continue;
            evplMOIter.remove();
            isDel = true;
        }
        if (!isDel) {
            retCode = 1090598186;
        }
        return retCode;
    }

    public static TEEtherEVPLMOPO getEvplFromContainer(TEEtherEVPLContainer container, int linkID) {
        Set evplMOSet = null;
        Iterator evplMOIter = null;
        TEEtherEVPLMOPO evplMO2 = null;
        evplMOSet = container.getEVPLList();
        for (TEEtherEVPLMOPO evplMO2 : evplMOSet) {
            if (!TEEthXCUtil.isEVPLToFind(linkID, evplMO2)) continue;
            return evplMO2;
        }
        return null;
    }

    public static boolean unActiveEvplInContainer(TEEtherEVPLContainer container, int linkID) {
        Set evplMOSet = null;
        Iterator evplMOIter = null;
        TEEtherEVPLMOPO evplMO2 = null;
        evplMOSet = container.getEVPLList();
        for (TEEtherEVPLMOPO evplMO2 : evplMOSet) {
            if (!TEEthXCUtil.isEVPLToFind(linkID, evplMO2)) continue;
            evplMO2.setActivateState((short)0);
            return true;
        }
        return false;
    }

    public static boolean isEVPLToFind(int linkID, TEEtherEVPLMOPO evplMO) {
        return evplMO.getIDNE() == linkID;
    }

    public static int getQinqType(int neID, int slotID, TEEtherEVPLMOPO etherEVPL) {
        boolean bCheck;
        int CLIENT_INVALID_VALUE = -1;
        int qinqType = -1;
        int srcCVlan = etherEVPL.getSrcVlanID();
        int srcSVlan = etherEVPL.getSrcSVlanID();
        int snkCVlan = etherEVPL.getSnkVlanID();
        int snkSVlan = etherEVPL.getSnkSVlanID();
        if ((srcCVlan & 0xFFFF) == 65534) {
            qinqType = 111;
            return qinqType;
        }
        boolean bl = bCheck = snkSVlan != -1 && snkCVlan != -1 && srcSVlan == -1 && srcCVlan == -1;
        if (bCheck) {
            qinqType = 101;
        }
        boolean bl2 = bCheck = snkSVlan != -1 && snkCVlan == -1 && srcSVlan == -1 && srcCVlan == -1;
        if (bCheck) {
            qinqType = 100;
        }
        boolean bl3 = bCheck = snkSVlan != -1 && snkCVlan != -1 && srcSVlan == -1 && srcCVlan != -1 && snkCVlan == srcCVlan;
        if (bCheck) {
            qinqType = 102;
        }
        boolean bl4 = bCheck = snkSVlan != -1 && snkCVlan != -1 && srcSVlan == -1 && srcCVlan != -1 && snkCVlan != srcCVlan;
        if (bCheck) {
            qinqType = 103;
        }
        boolean bl5 = bCheck = snkSVlan == -1 && snkCVlan == -1 && srcSVlan != -1 && srcCVlan == -1;
        if (bCheck) {
            qinqType = 110;
        }
        boolean bl6 = bCheck = snkSVlan == -1 && snkCVlan != -1 && srcSVlan != -1 && srcCVlan != -1 && snkCVlan == srcCVlan;
        if (bCheck) {
            qinqType = 114;
        }
        boolean bl7 = bCheck = snkSVlan == -1 && snkCVlan != -1 && srcSVlan != -1 && srcCVlan != -1 && snkCVlan != srcCVlan;
        if (bCheck) {
            qinqType = 113;
        }
        boolean bl8 = bCheck = snkSVlan == -1 && snkCVlan == -1 && srcSVlan != -1 && srcCVlan != -1;
        if (bCheck) {
            qinqType = 112;
        }
        short srcValue = etherEVPL.getSrcPortType();
        short snkValue = etherEVPL.getSnkPortType();
        if (5 == snkValue && 5 == srcValue) {
            boolean bl9 = bCheck = -1 == srcSVlan && -1 == srcCVlan && -1 == snkSVlan && -1 == etherEVPL.getSnkVlanID();
            if (bCheck) {
                qinqType = 142;
            }
            boolean bl10 = bCheck = -1 == srcSVlan && -1 != srcCVlan && -1 == snkSVlan && -1 == etherEVPL.getSnkVlanID();
            if (bCheck) {
                qinqType = 143;
            }
            boolean bl11 = bCheck = -1 == srcSVlan && -1 != srcCVlan && -1 == snkSVlan && -1 != snkCVlan && srcCVlan != snkCVlan;
            if (bCheck) {
                qinqType = 141;
            }
            boolean bl12 = bCheck = -1 == srcSVlan && -1 != srcCVlan && -1 == snkSVlan && -1 != snkCVlan && srcCVlan == snkCVlan;
            if (bCheck) {
                qinqType = 140;
            }
        }
        if (6 == snkValue && 6 == srcValue) {
            boolean bl13 = bCheck = -1 == srcSVlan && -1 == srcCVlan && -1 == snkSVlan && -1 == snkCVlan;
            if (bCheck) {
                qinqType = 131;
            }
            boolean bl14 = bCheck = -1 != srcSVlan && -1 == srcCVlan && -1 != snkSVlan && -1 == snkCVlan && srcSVlan == snkSVlan;
            if (bCheck) {
                qinqType = 130;
            }
            boolean bl15 = bCheck = -1 != srcSVlan && -1 == srcCVlan && -1 != snkSVlan && -1 == snkCVlan && srcSVlan != snkSVlan;
            if (bCheck) {
                qinqType = 120;
            }
            boolean bl16 = bCheck = -1 != srcSVlan && -1 != srcCVlan && -1 != snkSVlan && -1 != snkCVlan && srcSVlan != snkSVlan && srcCVlan != snkCVlan;
            if (bCheck) {
                qinqType = 123;
            }
            boolean bl17 = bCheck = -1 != srcSVlan && -1 != srcCVlan && -1 != snkSVlan && -1 != snkCVlan && srcSVlan != snkSVlan && srcCVlan == snkCVlan;
            if (bCheck) {
                qinqType = 122;
            }
            boolean bl18 = bCheck = -1 != srcSVlan && -1 != srcCVlan && -1 != snkSVlan && -1 != snkCVlan && srcSVlan == snkSVlan && srcCVlan == snkCVlan;
            if (bCheck) {
                qinqType = 132;
            }
            boolean bl19 = bCheck = -1 != srcSVlan && -1 != srcCVlan && -1 != snkSVlan && -1 != snkCVlan && srcSVlan == snkSVlan && srcCVlan != snkCVlan;
            if (bCheck) {
                qinqType = 121;
            }
        }
        return qinqType;
    }

    public static TEEtherEVPLMOPO constructEVPLMO(int neID, int linkType, Operation oper) {
        TEEtherEVPLMOPO evplPO = new TEEtherEVPLMOPO();
        Input input = oper.getInput();
        int linkID = Integer.parseInt(input.getPartValue("linkID"));
        short direction = 0;
        int srcPort = Integer.parseInt(input.getPartValue("srcPort"));
        int srcCVlan = 65535;
        String paramValue = input.getPartValue("srcCVlan");
        if (null != paramValue) {
            srcCVlan = Integer.parseInt(paramValue);
        }
        int srcSVlan = 65535;
        paramValue = input.getPartValue("srcSVlan");
        if (null != paramValue) {
            srcSVlan = Integer.parseInt(paramValue);
        }
        int snkPort = Integer.parseInt(input.getPartValue("snkPort"));
        int snkCVlan = 65535;
        paramValue = input.getPartValue("snkCVlan");
        if (null != paramValue) {
            snkCVlan = Integer.parseInt(paramValue);
        }
        int snkSVlan = 65535;
        paramValue = input.getPartValue("snkSVlan");
        if (null != paramValue) {
            snkSVlan = Integer.parseInt(paramValue);
        }
        int cVlanPri = -1;
        paramValue = input.getPartValue("cVlanPri");
        if (null != paramValue) {
            cVlanPri = Integer.parseInt(paramValue);
        }
        int sVlanPri = -1;
        paramValue = input.getPartValue("sVlanPri");
        if (null != paramValue) {
            sVlanPri = Integer.parseInt(paramValue);
        }
        short serviceType = (short)linkType;
        short srcPortType = (short)TEEthXCUtil.getE2EPortType(srcPort);
        short snkPortType = (short)TEEthXCUtil.getE2EPortType(snkPort);
        evplPO.setIDNE(linkID);
        evplPO.setDirection(direction);
        evplPO.setServiceType(serviceType);
        evplPO.setSrcPortID((long)srcPort);
        evplPO.setSrcPortType(srcPortType);
        evplPO.setSrcVlanID(srcCVlan);
        evplPO.setSrcSVlanID(srcSVlan);
        evplPO.setSrcTunnelLabel(-1L);
        evplPO.setSrcVCLabel(-1L);
        evplPO.setSnkPortID((long)snkPort);
        evplPO.setSnkPortType(snkPortType);
        evplPO.setSnkVlanID(snkCVlan);
        evplPO.setSnkSVlanID(snkSVlan);
        evplPO.setSnkTunnelLabel(-1L);
        evplPO.setSnkVCLabel(-1L);
        evplPO.setPktPRI(cVlanPri);
        evplPO.setSVlanPRI(sVlanPri);
        evplPO.setForwardPRI(-1);
        evplPO.setActivateState((short)1);
        evplPO.setRPRdstNodeID((short)-1);
        evplPO.setRPRFwdPRI((short)-1);
        evplPO.setRPRRingDir((short)-1);
        evplPO.setLinkOAM(-1);
        return evplPO;
    }

    public static QAsnEthXCInfo mo2asnEthXC(int neID, int slotID, TEEtherBridgeMOPO vbMO, TEEtherVBLinkMOPO vbLinkMO) {
        int snkPortID;
        QAsnEthXCInfo asnEVPLMO = new QAsnEthXCInfo();
        int xcType = -1;
        xcType = 3 == vbMO.getBridgeType() ? 6 : 5;
        QAsnEthXCIndex index = asnEVPLMO.xcIndex;
        QAsnEthXCAttr xcAttr = asnEVPLMO.xcAttr;
        QAsnEthXCTP srcEndTP = xcAttr.srcEndTP;
        QAsnEthXCTP snkEndTP = xcAttr.snkEndTP;
        index.neID = neID;
        index.slotID = slotID;
        index.xcID = vbLinkMO.getIDOnNE();
        index.xcType = xcType;
        index.linkType = xcType;
        xcAttr.vbID = vbMO.getVBID();
        xcAttr.serialID = -1;
        xcAttr.direction = vbLinkMO.getDir();
        xcAttr.isActive = vbLinkMO.getActiveState();
        xcAttr.ringDir = vbLinkMO.getRPRRingDir();
        xcAttr.snkNodeNo = vbLinkMO.getRPRdstNodeID();
        int phyPortID = vbLinkMO.getPhyPortID();
        srcEndTP.portID = TEEthXCUtil.getE2EPortID(phyPortID);
        srcEndTP.portType = TEEthXCUtil.getE2EPortType(phyPortID);
        srcEndTP.vlanID = TEEthXCUtil.getE2EVlanID(vbLinkMO.getCVLanID());
        srcEndTP.svlanID = TEEthXCUtil.getE2EVlanID(vbLinkMO.getSVLanID());
        srcEndTP.tunnelLabel = -1;
        srcEndTP.vcLabel = -1;
        snkEndTP.portID = snkPortID = TEEthXCUtil.getE2EPortID(vbLinkMO.getVBPortID());
        snkEndTP.portType = 3;
        snkEndTP.vlanID = -1;
        snkEndTP.svlanID = -1;
        snkEndTP.tunnelLabel = -1;
        snkEndTP.vcLabel = -1;
        return asnEVPLMO;
    }

    public static int getEVPLFromNESaveDB(int neID, int slotID, Set<Integer> linkIDSet) {
        String FUNC_NAME = "TEEthXCUtil.getEVPLFromNESaveDB";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.getEVPLFromNESaveDB");
        int errCode = -1;
        int cmdID = 2108702;
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, cmdID);
        TENEMgrInterface evplMgmt = TEEthXCUtil.getEVPLMgmtBeanSaveDB(neID, cmdID);
        if (null == subFunc) {
            String tipStr = "getEVPLFromNESaveDB: Get SubFunc fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLFromNESaveDB");
            return 1090646019;
        }
        Datainterface inputData = TEEthXCUtil.createQueryEVPLInput(neID, slotID);
        Datainterface outputData = null;
        try {
            outputData = evplMgmt.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        }
        catch (Exception e) {
            String tipStr = "getEVPLFromNESaveDB: TEEVPLMgmt run fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            tipStr = tipStr + inputData.toString();
            e2eLogger.error(tipStr, (Throwable)e);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLFromNESaveDB");
            return 1090646019;
        }
        if (null == outputData) {
            String tipStr = "getEVPLFromNESaveDB: Query evpl from ne fail! The outputData is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errCode);
            tipStr = tipStr + inputData.toString();
            e2eLogger.error(tipStr);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLFromNESaveDB");
            return 1090646019;
        }
        errCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errCode) {
            String tipStr = "getEVPLFromNESaveDB: Query evpl from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errCode);
            tipStr = tipStr + inputData.toString();
            e2eLogger.error(tipStr);
            TEE2EVBUtil.printRowError(outputData);
        } else {
            BussinessParams bussiness = outputData.getBussinessParams();
            if (null == bussiness) {
                String tipStr = "getEVPLFromNESaveDB: Query evpl from ne fail! The bussiness is null! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errCode);
                tipStr = tipStr + inputData.toString();
                e2eLogger.error(tipStr);
                TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLFromNESaveDB");
                return 1090646019;
            }
            RowParams[] rowParamsArr = bussiness.getRowParams();
            if (0 == rowParamsArr.length) {
                String tipStr = "getEVPLFromNESaveDB: Query evpl from ne fail! The rowParamsArr is null! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errCode);
                tipStr = tipStr + inputData.toString();
                e2eLogger.error(tipStr);
                TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLFromNESaveDB");
                return 1090646019;
            }
            Param param = null;
            String paramStr = null;
            int linkID = -1;
            int direction = -1;
            for (RowParams rowParams : rowParamsArr) {
                if (rowParams.getRowErrorsCount() > 0) continue;
                param = rowParams.getParam("upLinkID");
                if (null != param && null != (paramStr = param.getValue()) && !paramStr.isEmpty()) {
                    linkID = Integer.parseInt(paramStr);
                    linkIDSet.add(linkID);
                }
                if (1 != (direction = Integer.parseInt(paramStr = rowParams.getParam("direction").getValue())) || null == (param = rowParams.getParam("downLinkID")) || null == (paramStr = param.getValue()) || paramStr.isEmpty()) continue;
                linkID = Integer.parseInt(paramStr);
                linkIDSet.add(linkID);
            }
        }
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLFromNESaveDB");
        return errCode;
    }

    private static TENEMgrInterface getEVPLMgmtBeanSaveDB(int neID, int sfid) {
        TEEVPLMgmtSuper bean = null;
        int codeVersion = TEEthXCUtil.getEVPLCodeVersion(neID, sfid);
        bean = 1 == codeVersion ? new TEEVPLMgmt(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isSaveEVPLToDB() {
                return true;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPLMgmt(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isSaveEVPLToDB() {
                return true;
            }
        };
        return bean;
    }

    private static Datainterface createQueryEVPLInput(int neID, int slotID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neID", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotID", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("linkID", String.valueOf(0));
        rowparams.addParam(param);
        param = new Param("vlansncpID", String.valueOf(0));
        rowparams.addParam(param);
        return inputData;
    }

    public static boolean isEthBoard(int boardType) {
        ArrayList<Integer> ethBoardTypeList = new ArrayList<Integer>();
        ethBoardTypeList.add(2110);
        ethBoardTypeList.add(2109);
        ethBoardTypeList.add(1067);
        ethBoardTypeList.add(2272);
        ethBoardTypeList.add(3005);
        ethBoardTypeList.add(2292);
        ethBoardTypeList.add(1095);
        ethBoardTypeList.add(927);
        return ethBoardTypeList.contains(boardType);
    }

    public static boolean isBoardSupportVB(int boardType) {
        return TEEthXCUtil.isEthBoard(boardType);
    }

    public static boolean isBoardSupportEVPL(int boardType) {
        return TEEthXCUtil.isEthBoard(boardType);
    }

    public static int getEVPLCodeVersion(int neID, int cmdID) {
        String FUNC_NAME = "TEEthXCUtil.getEVPLCodeVersion";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.getEVPLCodeVersion");
        int version = 0;
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, cmdID);
        if (null == subFunc) {
            e2eLogger.error(String.format("getEVPLCodeVersion: subFunc is null! [neID:%d, slotID:%d]", neID, cmdID));
            return version;
        }
        String classMapping = subFunc.getClassMapping();
        if (null == classMapping) {
            e2eLogger.error(String.format("getEVPLCodeVersion: classMapping is null! [neID:%d, slotID:%d]", neID, cmdID));
            return version;
        }
        version = -1 != classMapping.indexOf(".service.") ? 0 : (-1 != classMapping.indexOf(".service_v2r6c01.") ? 1 : (-1 != classMapping.indexOf(".service_v2r8c01.") ? 2 : 0));
        e2eLogger.info("evpl code version->" + version);
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLCodeVersion");
        return version;
    }

    public static List<TEEtherEVPLMOPO> getEVPLMOFromDB(QAsnEthXCInfo ethXCInfo, List<QAsnEthXCInfo> unDirXCInfoList, TEEtherEVPLContainer container) {
        String FUNC_NAME = "TEEthXCUtil.getEVPLMOFromDB";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.getEVPLMOFromDB");
        ArrayList<TEEtherEVPLMOPO> evplMOList = new ArrayList<TEEtherEVPLMOPO>();
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        if (null == container) {
            String tipStr = "getEVPLMOFromDB: The container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.info(tipStr);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLMOFromDB");
            return evplMOList;
        }
        TEEtherEVPLMOPO evplMOPO2 = null;
        List<QAsnEthXCInfo> asnInfoList = TEEthXCUtil.getSingleDirAsnInfoList(ethXCInfo);
        int moServiceType = -1;
        QAsnEthXCInfo newAsnInfo = null;
        Iterator<QAsnEthXCInfo> iter = asnInfoList.iterator();
        block0: while (iter.hasNext()) {
            newAsnInfo = iter.next();
            Set evplMOSet = container.getEVPLList();
            for (TEEtherEVPLMOPO evplMOPO2 : evplMOSet) {
                if (!TEEthXCUtil.isMOEqualsAsn(evplMOPO2, newAsnInfo)) continue;
                evplMOList.add(evplMOPO2);
                newAsnInfo.xcIndex.xcID = evplMOPO2.getIDNE();
                moServiceType = evplMOPO2.getServiceType();
                newAsnInfo.xcIndex.xcType = TEEthXCUtil.getAsnXcType(moServiceType);
                newAsnInfo.xcIndex.linkType = moServiceType;
                unDirXCInfoList.add(newAsnInfo);
                iter.remove();
                continue block0;
            }
        }
        if (!asnInfoList.isEmpty()) {
            e2eLogger.info("getEVPLMOFromDB: those xc info is not exist in db!");
            for (QAsnEthXCInfo asnInfo : asnInfoList) {
                e2eLogger.info(TEAsn1Util.getAsn1String((Object)asnInfo));
            }
        }
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLMOFromDB");
        return evplMOList;
    }

    private static int getAsnXcType(int moServiceType) {
        int asnXcType;
        switch (moServiceType) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                asnXcType = 4;
                break;
            }
            default: {
                asnXcType = moServiceType;
            }
        }
        return asnXcType;
    }

    public static int getEVPLMOFromDB(int neID, int slotID, List<TEEtherEVPLMOPO> getSuccMOList) {
        String FUNC_NAME = "TEEthXCUtil.getEVPLMOFromDB";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.getEVPLMOFromDB");
        TEEtherEVPLContainer container = TEEthXCUtil.getContainer(neID, slotID);
        if (null == container) {
            String tipStr = "getEVPLMOFromDB: The container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLMOFromDB");
            return 1090646019;
        }
        getSuccMOList.addAll(container.getEVPLList());
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.getEVPLMOFromDB");
        return 0;
    }

    public static int activeEVPLFromDB(QAsnEthXCInfo ethXCInfo, short activeFlag, TEEtherEVPLContainer container) {
        String FUNC_NAME = "TEEthXCUtil.activeEVPLFromDB";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.activeEVPLFromDB");
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        if (null == container) {
            String tipStr = "activeEVPLFromDB: The container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.activeEVPLFromDB");
            return 2;
        }
        ArrayList<TEEtherEVPLMOPO> activedEVPLMOList = new ArrayList<TEEtherEVPLMOPO>();
        TEEtherEVPLMOPO evplMOPO2 = null;
        List<QAsnEthXCInfo> asnInfoList = TEEthXCUtil.getSingleDirAsnInfoList(ethXCInfo);
        for (QAsnEthXCInfo newAsnInfo : asnInfoList) {
            Set evplMOSet = container.getEVPLList();
            for (TEEtherEVPLMOPO evplMOPO2 : evplMOSet) {
                if (!TEEthXCUtil.isMOEqualsAsn(evplMOPO2, newAsnInfo)) continue;
                evplMOPO2.setActivateState(activeFlag);
                activedEVPLMOList.add(evplMOPO2);
            }
        }
        if (activedEVPLMOList.isEmpty()) {
            String tipStr = "activeEVPLFromDB: Save active evpl result fail! activedEVPLMOList is empty! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
            e2eLogger.error(tipStr);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.activeEVPLFromDB");
            return 1090598186;
        }
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.activeEVPLFromDB");
        return retCode;
    }

    public static int removeEVPLFromDB(QAsnEthXCInfo ethXCInfo, TEEtherEVPLContainer container) {
        String FUNC_NAME = "TEEthXCUtil.removeEVPLFromDB";
        TEEthE2ELog.logFuncBegin("TEEthXCUtil.removeEVPLFromDB");
        ArrayList<TEEtherEVPLMOPO> evplMOList = new ArrayList<TEEtherEVPLMOPO>();
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        if (null == container) {
            String tipStr = "removeEVPLFromDB: The container is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.removeEVPLFromDB");
            return 1090646019;
        }
        TEEtherEVPLMOPO evplMOPO2 = null;
        List<QAsnEthXCInfo> asnInfoList = TEEthXCUtil.getSingleDirAsnInfoList(ethXCInfo);
        for (QAsnEthXCInfo newAsnInfo : asnInfoList) {
            Set evplMOSet = container.getEVPLList();
            for (TEEtherEVPLMOPO evplMOPO2 : evplMOSet) {
                if (!TEEthXCUtil.isMOEqualsAsn(evplMOPO2, newAsnInfo)) continue;
                evplMOList.add(evplMOPO2);
            }
        }
        container.getEVPLList().removeAll(evplMOList);
        int retCode = TEEthXCUtil.saveContainerToDB(neID, slotID, container);
        if (0 != retCode) {
            String tipStr = "removeEVPLFromDB: Save remove evpl result fail.! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
            e2eLogger.error(tipStr);
            TEEthE2ELog.logFuncEnd("TEEthXCUtil.removeEVPLFromDB");
            return retCode;
        }
        TEEthE2ELog.logFuncEnd("TEEthXCUtil.removeEVPLFromDB");
        return retCode;
    }

    public static List<QAsnEthXCInfo> getSingleDirAsnInfoList(QAsnEthXCInfo ethXCInfo) {
        QAsnEthXCInfo asnInfo = null;
        ArrayList<QAsnEthXCInfo> asnInfoList = new ArrayList<QAsnEthXCInfo>();
        if (1 == ethXCInfo.xcAttr.direction) {
            asnInfo = TEEthXCUtil.cloneQAsnEthXCInfo(ethXCInfo);
            asnInfo.xcAttr.direction = 0;
            asnInfoList.add(asnInfo);
            asnInfo = TEEthXCUtil.cloneQAsnEthXCInfo(ethXCInfo);
            asnInfo.xcAttr.direction = 0;
            QAsnEthXCTP tempCtp = asnInfo.xcAttr.srcEndTP;
            asnInfo.xcAttr.srcEndTP = asnInfo.xcAttr.snkEndTP;
            asnInfo.xcAttr.snkEndTP = tempCtp;
            asnInfo.xcIndex.linkType = TEEthXCUtil.getReverseLinkType(asnInfo.xcIndex.linkType);
            asnInfoList.add(asnInfo);
        } else {
            asnInfo = TEEthXCUtil.cloneQAsnEthXCInfo(ethXCInfo);
            asnInfo.xcAttr.direction = 0;
            asnInfoList.add(asnInfo);
        }
        return asnInfoList;
    }

    public static int getReverseLinkType(int positiveLinkType) {
        int reverseLinkType = positiveLinkType;
        if (6 == positiveLinkType) {
            reverseLinkType = 8;
        } else if (7 == positiveLinkType) {
            reverseLinkType = 9;
        }
        return reverseLinkType;
    }

    private static boolean isMOEqualsAsn(TEEtherEVPLMOPO evplMO, QAsnEthXCInfo ethXCInfo) {
        int moSrcPortID = (int)evplMO.getSrcPortID();
        short moSrcPortType = evplMO.getSrcPortType();
        int moSrcVlanID = evplMO.getSrcVlanID();
        int moSrcSVlanID = evplMO.getSrcSVlanID();
        int moSnkPortID = (int)evplMO.getSnkPortID();
        short moSnkPortType = evplMO.getSnkPortType();
        int moSnkVlanID = evplMO.getSnkVlanID();
        int moSnkSVlanID = evplMO.getSnkSVlanID();
        ArrayList<Integer> moAttrList = new ArrayList<Integer>();
        moAttrList.add(moSrcPortID);
        moAttrList.add(Integer.valueOf(moSrcPortType));
        moAttrList.add(moSrcVlanID);
        moAttrList.add(moSrcSVlanID);
        moAttrList.add(moSnkPortID);
        moAttrList.add(Integer.valueOf(moSnkPortType));
        moAttrList.add(moSnkVlanID);
        moAttrList.add(moSnkSVlanID);
        TEEtherEVPLMOPO asnEvplMO = TEEthXCUtil.asn2moEthXC(ethXCInfo);
        int asnSrcPortID = (int)asnEvplMO.getSrcPortID();
        short asnSrcPortType = asnEvplMO.getSrcPortType();
        int asnSrcVlanID = asnEvplMO.getSrcVlanID();
        int asnSrcSVlanID = asnEvplMO.getSrcSVlanID();
        int asnSnkPortID = (int)asnEvplMO.getSnkPortID();
        short asnSnkPortType = asnEvplMO.getSnkPortType();
        int asnSnkVlanID = asnEvplMO.getSnkVlanID();
        int asnSnkSVlanID = asnEvplMO.getSnkSVlanID();
        ArrayList<Integer> asnAttrList = new ArrayList<Integer>();
        asnAttrList.add(asnSrcPortID);
        asnAttrList.add(Integer.valueOf(asnSrcPortType));
        asnAttrList.add(asnSrcVlanID);
        asnAttrList.add(asnSrcSVlanID);
        asnAttrList.add(asnSnkPortID);
        asnAttrList.add(Integer.valueOf(asnSnkPortType));
        asnAttrList.add(asnSnkVlanID);
        asnAttrList.add(asnSnkSVlanID);
        int len = moAttrList.size();
        for (int i = 0; i < len; ++i) {
            if (((Integer)moAttrList.get(i)).intValue() == ((Integer)asnAttrList.get(i)).intValue()) continue;
            return false;
        }
        return true;
    }

    public static QAsnEthXCInfo cloneQAsnEthXCInfo(QAsnEthXCInfo orgin) {
        QAsnEthXCInfo newInfo = new QAsnEthXCInfo();
        QAsnEthXCIndex index = newInfo.xcIndex;
        QAsnEthXCAttr xcAttr = newInfo.xcAttr;
        QAsnEthXCTP srcEndTP = xcAttr.srcEndTP;
        QAsnEthXCTP snkEndTP = xcAttr.snkEndTP;
        index.neID = orgin.xcIndex.neID;
        index.slotID = orgin.xcIndex.slotID;
        index.xcID = orgin.xcIndex.xcID;
        index.xcType = orgin.xcIndex.xcType;
        index.linkType = orgin.xcIndex.linkType;
        xcAttr.vbID = orgin.xcAttr.vbID;
        xcAttr.serialID = orgin.xcAttr.serialID;
        xcAttr.direction = orgin.xcAttr.direction;
        xcAttr.isActive = orgin.xcAttr.isActive;
        xcAttr.ringDir = orgin.xcAttr.ringDir;
        xcAttr.snkNodeNo = orgin.xcAttr.snkNodeNo;
        srcEndTP.portID = orgin.xcAttr.srcEndTP.portID;
        srcEndTP.portType = orgin.xcAttr.srcEndTP.portType;
        srcEndTP.vlanID = orgin.xcAttr.srcEndTP.vlanID;
        srcEndTP.svlanID = orgin.xcAttr.srcEndTP.svlanID;
        srcEndTP.tunnelLabel = orgin.xcAttr.srcEndTP.tunnelLabel;
        srcEndTP.vcLabel = orgin.xcAttr.srcEndTP.vcLabel;
        snkEndTP.portID = orgin.xcAttr.snkEndTP.portID;
        snkEndTP.portType = orgin.xcAttr.snkEndTP.portType;
        snkEndTP.vlanID = orgin.xcAttr.snkEndTP.vlanID;
        snkEndTP.svlanID = orgin.xcAttr.snkEndTP.svlanID;
        snkEndTP.tunnelLabel = orgin.xcAttr.snkEndTP.tunnelLabel;
        snkEndTP.vcLabel = orgin.xcAttr.snkEndTP.vcLabel;
        return newInfo;
    }

    public static QAsnEthXCInfoList coupleEVPL(QAsnEthXCInfoList ethXCInfoList) {
        return ethXCInfoList;
    }

    public static void fillErrorToRsp(int neID, int slotID, Datainterface outputData, QAsnErrInfoList rspErrInfoList) {
        BussinessParams bussiness = outputData.getBussinessParams();
        if (null == bussiness) {
            String tipStr = "fillErrorToRsp: bussiness is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            return;
        }
        RowParams[] rowParamsArr = bussiness.getRowParams();
        if (0 == rowParamsArr.length) {
            String tipStr = "fillErrorToRsp: rowParamsArr is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            return;
        }
        String errorCodeStr = null;
        for (RowParams rowParams : rowParamsArr) {
            int len = rowParams.getRowErrorsCount();
            for (int i = 0; i < len; ++i) {
                RowErrors[] rowErrorsArr = rowParams.getRowErrors();
                if (null == rowErrorsArr) continue;
                for (RowErrors rowErrors : rowErrorsArr) {
                    errorCodeStr = rowErrors.getErrorMessage().getErrorcode();
                    if (null == errorCodeStr || errorCodeStr.isEmpty()) continue;
                    QAsnErrInfo errInfo = new QAsnErrInfo();
                    errInfo.errCode = Integer.parseInt(errorCodeStr);
                    errInfo.objID = new QAsnTinyIntList();
                    errInfo.objID.add((Object)neID);
                    errInfo.objID.add((Object)slotID);
                    rspErrInfoList.add((Object)errInfo);
                    String tipStr = String.format("[neID:%d, slotID:%d, errCode:%s]", neID, slotID, errorCodeStr);
                    e2eLogger.error(tipStr);
                }
            }
        }
    }

    public static int getE2EPortType(int portid) {
        int portType = 0;
        if (portid > 32768) {
            portType = 1;
            return portType;
        }
        if (portid > 28672) {
            portType = 3;
            return portType;
        }
        return portType;
    }

    public static int getE2EPortID(int portid) {
        int newPortID = portid;
        if (portid > 32768) {
            newPortID = portid - 32768;
            return newPortID;
        }
        if (portid > 28672) {
            newPortID = portid - 28672;
            return newPortID;
        }
        return newPortID;
    }

    public static void fillEmptyInfo(QAsnEthXCInfo asnEVPLMO) {
        QAsnEthXCIndex index = asnEVPLMO.xcIndex;
        QAsnEthXCAttr xcAttr = asnEVPLMO.xcAttr;
        QAsnEthXCTP srcEndTP = xcAttr.srcEndTP;
        QAsnEthXCTP snkEndTP = xcAttr.snkEndTP;
        index.xcType = -1;
        index.linkType = -1;
        xcAttr.vbID = -1;
        xcAttr.serialID = -1;
        xcAttr.direction = -1;
        xcAttr.isActive = -1;
        xcAttr.ringDir = -1;
        xcAttr.snkNodeNo = -1;
        srcEndTP.portID = -1;
        srcEndTP.portType = -1;
        srcEndTP.vlanID = -1;
        srcEndTP.svlanID = -1;
        srcEndTP.tunnelLabel = -1;
        srcEndTP.vcLabel = -1;
        snkEndTP.portID = -1;
        snkEndTP.portType = -1;
        snkEndTP.vlanID = -1;
        snkEndTP.svlanID = -1;
        snkEndTP.tunnelLabel = -1;
        snkEndTP.vcLabel = -1;
    }

    public static boolean isVBLink(QAsnEthXCInfo ethXCInfo) {
        int xcType = ethXCInfo.xcIndex.xcType;
        if (xcType == -1) {
            xcType = ethXCInfo.xcAttr.snkEndTP.tunnelLabel == -1 && ethXCInfo.xcAttr.srcEndTP.tunnelLabel == -1 ? 5 : 6;
            ethXCInfo.xcIndex.xcType = xcType;
        }
        return 5 == xcType || 6 == xcType;
    }

    public static List<TEEtherEVPLMOPO> getSortedEVPLMOList(int neID, int slotID, Collection<TEEtherEVPLMOPO> evplMOSet) {
        ArrayList<TEEtherEVPLMOPO> molist = new ArrayList<TEEtherEVPLMOPO>();
        TreeMap<Integer, TEEtherEVPLMOPO> moMap = new TreeMap<Integer, TEEtherEVPLMOPO>();
        TEEtherEVPLMOPO mo2 = null;
        for (TEEtherEVPLMOPO mo2 : evplMOSet) {
            moMap.put(mo2.getIDNE(), mo2);
        }
        molist.addAll(moMap.values());
        return molist;
    }

    public static boolean isLogOnDebug() {
        return false;
    }
}

