/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEEthXCParseCPSPCfgFile {
    private static final StringBuffer fileNameBuffer = new StringBuffer("nemgr").append(File.separator).append("ip").append(File.separator).append("ngwdm").append(File.separator).append("conf").append(File.separator).append("ethlanservice").append(File.separator).append("eth_cp_support.xml");
    private static TEEthXCParseCPSPCfgFile instance = null;
    private Map<Integer, Node> cpNodeMap = new HashMap<Integer, Node>();

    public TEEthXCParseCPSPCfgFile() {
        this.parseXMLFile();
    }

    public static synchronized TEEthXCParseCPSPCfgFile getInstance() {
        if (null == instance) {
            return new TEEthXCParseCPSPCfgFile();
        }
        return instance;
    }

    private void parseXMLFile() {
        String filePath = new StringBuffer(TEResourceManager.getPath()).append(fileNameBuffer).toString();
        try {
            Document doc = TEParseXMLFile.parseFile((String)filePath);
            if (null == doc) {
                TELogFactory.getNormalLogger().info("Parse eth support file fail! filePath->" + filePath);
                return;
            }
            Element root = doc.getDocumentElement();
            NodeList children = root.getChildNodes();
            Node node = null;
            int boardType = -1;
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                node = children.item(i);
                if (!(node instanceof Element)) continue;
                boardType = Integer.parseInt(node.getAttributes().getNamedItem("cp_type").getNodeValue());
                this.cpNodeMap.put(boardType, node);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse eth support file fail!", (Throwable)e);
        }
    }

    public Map<Integer, Integer> getAttrMap(int boardType) {
        Map<Integer, Integer> attrMap = new HashMap<Integer, Integer>();
        Node node = this.cpNodeMap.get(boardType);
        if (null != node) {
            this.addNodeInfoToMap(node, attrMap);
        } else {
            attrMap = this.getNullAttrSPMap();
        }
        return attrMap;
    }

    private void addNodeInfoToMap(Node node, Map<Integer, Integer> attrMap) {
        NodeList attrNodeList = node.getChildNodes();
        Node attrNode = null;
        String attrName = null;
        String attrValue = null;
        int attrID = -1;
        int len = attrNodeList.getLength();
        for (int i = 0; i < len; ++i) {
            attrNode = attrNodeList.item(i);
            if (!(attrNode instanceof Element)) continue;
            attrName = attrNode.getNodeName();
            attrValue = attrNode.getAttributes().getNamedItem("value").getNodeValue();
            attrValue = this.handleSpecialValue(attrName, attrValue);
            attrID = this.parseAttrID(attrName);
            attrMap.put(attrID, Integer.parseInt(attrValue));
        }
    }

    private String handleSpecialValue(String attrName, String value) {
        String newValue = value;
        if ("ATTR_VB_MODE".equals(attrName)) {
            newValue = String.valueOf(Integer.parseInt(value, 2));
        }
        return newValue;
    }

    private int parseAttrID(String attrName) {
        HashMap<String, Integer> attrSPInfoMap = new HashMap<String, Integer>();
        attrSPInfoMap.put("ATTR_USER", 1);
        attrSPInfoMap.put("ATTR_VB", 2);
        attrSPInfoMap.put("ATTR_STATIC_ROUTER", 3);
        attrSPInfoMap.put("ATTR_MPLS", 4);
        attrSPInfoMap.put("ATTR_QINQ", 5);
        attrSPInfoMap.put("ATTR_EVPL", 6);
        attrSPInfoMap.put("ATTR_OLD_SERVICE", 7);
        attrSPInfoMap.put("ATTR_RPR_RING", 8);
        attrSPInfoMap.put("ATTR_STATIC_SERVICE", 9);
        attrSPInfoMap.put("ATTR_VLAN_FILTER", 10);
        attrSPInfoMap.put("ATTR_RPR", 11);
        attrSPInfoMap.put("ATTR_OAM", 12);
        attrSPInfoMap.put("ATTR_ETH_AVAIL", 13);
        attrSPInfoMap.put("ATTR_VB_MODE", 14);
        return (Integer)attrSPInfoMap.get(attrName);
    }

    public Map<Integer, Integer> getNullAttrSPMap() {
        HashMap<Integer, Integer> attrSPInfoMap = new HashMap<Integer, Integer>();
        attrSPInfoMap.put(1, 0);
        attrSPInfoMap.put(2, 0);
        attrSPInfoMap.put(3, 0);
        attrSPInfoMap.put(4, 0);
        attrSPInfoMap.put(5, 0);
        attrSPInfoMap.put(6, 0);
        attrSPInfoMap.put(7, 0);
        attrSPInfoMap.put(8, 0);
        attrSPInfoMap.put(9, 0);
        attrSPInfoMap.put(10, 0);
        attrSPInfoMap.put(11, 0);
        attrSPInfoMap.put(12, 0);
        attrSPInfoMap.put(13, 0);
        attrSPInfoMap.put(14, 0);
        return attrSPInfoMap;
    }
}

