/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnDelEthXCReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnDelEthXCRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCNoticeMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECheckEmpty;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECheckXC;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECreateError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2EGlobalErrCode;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELogEVPL;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink.TEE2EDelVBLink;
import com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPLMgmtSuper;
import com.huawei.nglct.nemgr.ip.ngwdm.service_v2r6c01.TEEVPLMgmt;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEDelEthXCHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        if (null == qReq || null == qRsp) {
            e2eLogger.error("qReq or qRsp is null!");
            return 0;
        }
        String FUNC_NAME = "TEDelEthXCHandler.handleRequestImpl";
        TEEthE2ELog.logFuncBegin("TEDelEthXCHandler.handleRequestImpl");
        QAsnDelEthXCReq req = (QAsnDelEthXCReq)qReq;
        QAsnDelEthXCRsp rsp = (QAsnDelEthXCRsp)qRsp;
        if (TEEthE2ECheckEmpty.isListEmpty((List<Object>)req.xcInfoList, "TEDelEthXCHandler.handleRequestImpl", "req.xcInfoList")) {
            TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.handleRequestImpl");
            return 0;
        }
        rsp.result.errList = new QAsnErrInfoList();
        Set<Integer> normalNEIDSet = TEEthXCUtil.connectSBIForNE(req.xcInfoList, rsp.result.errList);
        QAsnEthXCInfoList notifyInfoList = new QAsnEthXCInfoList();
        boolean isAllSuccess = true;
        boolean isAllFail = true;
        QAsnEthXCInfo asnXC = null;
        QAsnErrInfoList tempErrInfoList = null;
        int len = req.xcInfoList.size();
        for (int i = 0; i < len; ++i) {
            asnXC = (QAsnEthXCInfo)req.xcInfoList.get(i);
            if (!TEEthE2ECheckXC.isXCValid(asnXC, normalNEIDSet, rsp.result, "TEDelEthXCHandler.handleRequestImpl")) {
                isAllSuccess = false;
                continue;
            }
            tempErrInfoList = new QAsnErrInfoList();
            int retCode = TEDelEthXCHandler.delEthXC(asnXC, tempErrInfoList);
            this.addSerialID(asnXC.xcAttr.serialID, tempErrInfoList);
            rsp.result.errList.addAll((Collection)tempErrInfoList);
            if (0 == retCode) {
                notifyInfoList.add((Object)asnXC);
                TEEthServiceOAMUtil.deleteElineOAM(asnXC.xcIndex.neID, asnXC.xcIndex.slotID, asnXC.xcIndex.xcID);
                isAllFail = false;
                continue;
            }
            e2eLogger.error(TEEthE2ELogEVPL.getLog4Ego("TEDelEthXCHandler.handleRequestImpl", "delete eth xc fail!", asnXC));
            isAllSuccess = false;
        }
        if (!notifyInfoList.isEmpty()) {
            TEEthXCNoticeMgr.sendDelNtf(notifyInfoList);
        }
        TEEthE2EGlobalErrCode.setGlobalErrCode(rsp.result, isAllSuccess, isAllFail);
        TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.handleRequestImpl");
        return 0;
    }

    private void addSerialID(int serialID, QAsnErrInfoList tempErrInfoList) {
        QAsnErrInfo asnErrInfo = null;
        QAsnTinyIntList objIDList = null;
        int len = tempErrInfoList.size();
        for (int i = 0; i < len; ++i) {
            asnErrInfo = (QAsnErrInfo)tempErrInfoList.get(i);
            objIDList = new QAsnTinyIntList();
            objIDList.add((Object)serialID);
            int lenj = asnErrInfo.objID.size();
            for (int j = 0; j < lenj; ++j) {
                objIDList.add(asnErrInfo.objID.get(j));
            }
            asnErrInfo.objID = objIDList;
        }
    }

    private static int delEthXC(QAsnEthXCInfo asnXC, QAsnErrInfoList asnErrList) {
        if (TEEthXCUtil.isVBLink(asnXC)) {
            ArrayList<QAsnEthXCInfo> delSuccXCList = new ArrayList<QAsnEthXCInfo>();
            return TEE2EDelVBLink.delVBLink(asnXC, asnErrList, delSuccXCList);
        }
        return TEDelEthXCHandler.delEVPL(asnXC, asnErrList);
    }

    private static int delEVPL(QAsnEthXCInfo asnEVPL, QAsnErrInfoList rspErrInfoList) {
        ArrayList<Integer> delLinkIDList;
        String FUNC_NAME = "TEDelEthXCHandler.delEVPL";
        TEEthE2ELog.logFuncBegin("TEDelEthXCHandler.delEVPL");
        int retCode = 0;
        int neID = asnEVPL.xcIndex.neID;
        int slotID = asnEVPL.xcIndex.slotID;
        TEEtherEVPLContainer container = TEEthXCUtil.getContainer(neID, slotID);
        retCode = TEEthE2ECheckXC.checkXCStatus("TEDelEthXCHandler.delEVPL", asnEVPL, container);
        if (0 != retCode) {
            rspErrInfoList.addAll(TEEthE2ECreateError.createQAsnErrInfo(retCode, asnEVPL));
            TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEVPL");
            return retCode;
        }
        int isActive = asnEVPL.xcAttr.isActive;
        if (1 == isActive && 0 != (retCode = TEDelEthXCHandler.delEvplFromNENoDB(neID, asnEVPL, rspErrInfoList, delLinkIDList = new ArrayList<Integer>(), container))) {
            TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEVPL");
            return retCode;
        }
        retCode = TEEthXCUtil.removeEVPLFromDB(asnEVPL, container);
        if (0 != retCode) {
            rspErrInfoList.addAll(TEEthE2ECreateError.createQAsnErrInfo(retCode, asnEVPL));
            TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEVPL");
            return retCode;
        }
        TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEVPL");
        return retCode;
    }

    public static int delEvplFromNENoDB(int neID, QAsnEthXCInfo xcInfo, QAsnErrInfoList rspErrInfoList, List<Integer> delLinkIDList, TEEtherEVPLContainer container) {
        if (null == xcInfo) {
            e2eLogger.error("xcInfo is null!");
            return 1090646019;
        }
        if (null == rspErrInfoList) {
            e2eLogger.error("rspErrInfoList is null!");
            return 1090646019;
        }
        if (null == delLinkIDList) {
            e2eLogger.error("delLinkIDList is null!");
            return 1090646019;
        }
        String FUNC_NAME = "TEDelEthXCHandler.delEvplFromNENoDB";
        TEEthE2ELog.logFuncBegin("TEDelEthXCHandler.delEvplFromNENoDB");
        int retCode = 0;
        int slotID = xcInfo.xcIndex.slotID;
        int sfid = TEDelEthXCHandler.getDelEVPLCmd();
        TENEMgrInterface bean = TEDelEthXCHandler.getDelEVPLBeanNoDB(neID, sfid);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, sfid);
        if (null == subFunc) {
            TEEthE2ELogEVPL.logSubFuncNullError(xcInfo, "TEDelEthXCHandler.delEvplFromNENoDB");
            TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEvplFromNENoDB");
            return 1090646019;
        }
        ArrayList<QAsnEthXCInfo> unDirXCInfoList = new ArrayList<QAsnEthXCInfo>();
        List<TEEtherEVPLMOPO> evplPOList = TEEthXCUtil.getEVPLMOFromDB(xcInfo, unDirXCInfoList, container);
        if (evplPOList.isEmpty()) {
            TEEthE2ELogEVPL.logLinkNullInDBError(xcInfo, "TEDelEthXCHandler.delEvplFromNENoDB");
            rspErrInfoList.addAll(TEEthE2ECreateError.createQAsnErrInfo(1090598186, xcInfo));
            TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEvplFromNENoDB");
            return 1090598186;
        }
        for (TEEtherEVPLMOPO moEVPL : evplPOList) {
            delLinkIDList.add(moEVPL.getIDNE());
        }
        Datainterface inputData = TEDelEthXCHandler.createDataInterface(sfid, xcInfo, evplPOList);
        Datainterface outputData = null;
        try {
            outputData = bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        }
        catch (Exception e) {
            TEEthE2ELogEVPL.logExceptionError(xcInfo, "TEDelEthXCHandler.delEvplFromNENoDB", e);
            TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEvplFromNENoDB");
            return 1090646019;
        }
        if (null == outputData) {
            TEEthE2ELogEVPL.logOutputDataError(xcInfo, "TEDelEthXCHandler.delEvplFromNENoDB", inputData);
            TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEvplFromNENoDB");
            return 1090646019;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TEEthE2ELogEVPL.logDelFromNEFailError(xcInfo, "TEDelEthXCHandler.delEvplFromNENoDB", inputData);
            TEE2EVBUtil.printRowError(outputData);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, rspErrInfoList);
            TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEvplFromNENoDB");
            return retCode;
        }
        TEEthE2ELog.logFuncEnd("TEDelEthXCHandler.delEvplFromNENoDB");
        return retCode;
    }

    private static TENEMgrInterface getDelEVPLBeanNoDB(int neID, int sfid) {
        TEEVPLMgmtSuper bean = null;
        int codeVersion = TEEthXCUtil.getEVPLCodeVersion(neID, sfid);
        bean = 1 == codeVersion ? new TEEVPLMgmt(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isDelEVPLFromDB() {
                return false;
            }

            @Override
            protected boolean isSaveEVPLToDB() {
                return false;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.service.TEEVPLMgmt(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isDelEVPLFromDB() {
                return false;
            }

            @Override
            protected boolean isSaveEVPLToDB() {
                return false;
            }
        };
        return bean;
    }

    private static int getDelEVPLCmd() {
        return 2108700;
    }

    private static Datainterface createDataInterface(int sfid, QAsnEthXCInfo ethXCInfo, List<TEEtherEVPLMOPO> evplPOList) {
        Datainterface inputData = new Datainterface();
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = null;
        int len = evplPOList.size();
        for (int i = 0; i < len; ++i) {
            rowparams = new RowParams();
            Param param = new Param("neID", String.valueOf(neID));
            rowparams.addParam(param);
            param = new Param("slotID", String.valueOf(slotID));
            rowparams.addParam(param);
            param = new Param("linkID", String.valueOf(evplPOList.get(i).getIDNE()));
            rowparams.addParam(param);
            param = new Param("isactive", String.valueOf(evplPOList.get(i).getActivateState()));
            rowparams.addParam(param);
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }

    protected boolean isLogReq() {
        return TEEthXCUtil.isLogOnDebug();
    }

    protected boolean isLogRsp() {
        return true;
    }
}

