/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_ipservice.QAsnCreateEthXCReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnCreateEthXCRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TECreateEthXCEVPL;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCNESlotKey;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCNoticeMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECheckEmpty;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECheckXC;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECreateError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELog;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vblink.TEE2ECreateVBLink;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TELinkIDGenerator;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class TECreateEthXCHandler
extends TEWNEMgrHandler {
    public static final byte HAS_SUCCESS = 1;
    public static final byte HAS_FAIL = 2;

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        String FUNC_NAME = "TECreateEthXCHandler.handleRequestImpl";
        TEEthE2ELog.logFuncBegin("TECreateEthXCHandler.handleRequestImpl");
        QAsnCreateEthXCReq req = (QAsnCreateEthXCReq)qReq;
        QAsnCreateEthXCRsp rsp = (QAsnCreateEthXCRsp)qRsp;
        if (TEEthE2ECheckEmpty.isListEmpty((List<Object>)req.xcInfoList, "TECreateEthXCHandler.handleRequestImpl", "req.xcInfoList")) {
            TEEthE2ELog.logFuncEnd("TECreateEthXCHandler.handleRequestImpl");
            return 0;
        }
        rsp.result.errList = new QAsnErrInfoList();
        Set<Integer> normalNEIDSet = TEEthXCUtil.connectSBIForNE(req.xcInfoList, rsp.result.errList);
        Map<TEEthXCNESlotKey, List<QAsnEthXCInfo>> asnXCMap = TECreateEthXCHandler.buildAsnXCMap(req.xcInfoList);
        HashMap<TEEthXCNESlotKey, List<QAsnEthXCInfo>> createNESuccEVPLMap = new HashMap<TEEthXCNESlotKey, List<QAsnEthXCInfo>>();
        HashMap<TEEthXCNESlotKey, TEEtherEVPLContainer> evplContainerMap = new HashMap<TEEthXCNESlotKey, TEEtherEVPLContainer>();
        TEEthXCNESlotKey key = null;
        List<QAsnEthXCInfo> asnXCList = null;
        Map.Entry<TEEthXCNESlotKey, List<QAsnEthXCInfo>> entry2 = null;
        Set<Map.Entry<TEEthXCNESlotKey, List<QAsnEthXCInfo>>> entrySet = asnXCMap.entrySet();
        for (Map.Entry<TEEthXCNESlotKey, List<QAsnEthXCInfo>> entry2 : entrySet) {
            key = entry2.getKey();
            asnXCList = entry2.getValue();
            if (null == asnXCList) continue;
            this.createAsnXCToNE(normalNEIDSet, rsp, createNESuccEVPLMap, evplContainerMap, key, asnXCList);
        }
        this.saveEVPLTODB(rsp, createNESuccEVPLMap, evplContainerMap);
        QAsnEthXCInfoList notifyInfoList = rsp.xcInfoList;
        if (!notifyInfoList.isEmpty()) {
            TEEthXCNoticeMgr.sendCreateNtf(notifyInfoList);
        }
        TECreateEthXCHandler.setGlobalErrCode(rsp);
        TEEthE2ELog.logFuncEnd("TECreateEthXCHandler.handleRequestImpl");
        return 0;
    }

    public static void setGlobalErrCode(QAsnCreateEthXCRsp rsp) {
        rsp.result.result = rsp.result.errList.isEmpty() ? 0 : (rsp.xcInfoList.isEmpty() ? 1090650122 : 1090650121);
    }

    private void createAsnXCToNE(Set<Integer> normalNEIDSet, QAsnCreateEthXCRsp rsp, Map<TEEthXCNESlotKey, List<QAsnEthXCInfo>> createNESuccEVPLMap, Map<TEEthXCNESlotKey, TEEtherEVPLContainer> evplContainerMap, TEEthXCNESlotKey key, List<QAsnEthXCInfo> asnXCList) {
        String FUNC_NAME = "TECreateEthXCHandler.createAsnXCToNE";
        if (null == asnXCList || asnXCList.isEmpty()) {
            return;
        }
        int neID = key.getNeID();
        int slotID = key.getSlotID();
        TELinkIDGenerator linkIDGenerator = new TELinkIDGenerator();
        linkIDGenerator.init(neID, slotID);
        for (QAsnEthXCInfo asnXC : asnXCList) {
            if (!TEEthE2ECheckXC.isXCValid(asnXC, normalNEIDSet, rsp.result, "TECreateEthXCHandler.createAsnXCToNE")) continue;
            ArrayList<QAsnEthXCInfo> createdXCList = new ArrayList<QAsnEthXCInfo>();
            if (TEEthXCUtil.isVBLink(asnXC)) {
                TEE2ECreateVBLink.createVBLink(asnXC, rsp.result.errList, createdXCList, linkIDGenerator);
            } else {
                TEEtherEVPLContainer container = linkIDGenerator.getEVPLContainer();
                evplContainerMap.put(key, container);
                TECreateEthXCEVPL.createEVPL(asnXC, rsp.result.errList, createdXCList, linkIDGenerator);
            }
            if (null == createdXCList || createdXCList.isEmpty()) continue;
            if (TEEthXCUtil.isVBLink(asnXC)) {
                rsp.xcInfoList.addAll(createdXCList);
                continue;
            }
            TECreateEthXCHandler.saveCreateNESuccEVPLToContainer(createNESuccEVPLMap, evplContainerMap, key, createdXCList);
        }
    }

    public static void saveCreateNESuccEVPLToContainer(Map<TEEthXCNESlotKey, List<QAsnEthXCInfo>> createNESuccEVPLMap, Map<TEEthXCNESlotKey, TEEtherEVPLContainer> evplContainerMap, TEEthXCNESlotKey key, List<QAsnEthXCInfo> createdXCList) {
        if (null == createdXCList || createdXCList.isEmpty()) {
            return;
        }
        if (null == createNESuccEVPLMap) {
            TELogFactory.getE2ELogger().error("createNESuccEVPLMap is null!");
            return;
        }
        if (null == evplContainerMap) {
            TELogFactory.getE2ELogger().error("evplContainerMap is null!");
            return;
        }
        TEEtherEVPLContainer container = evplContainerMap.get(key);
        if (null == container) {
            container = new TEEtherEVPLContainer();
            evplContainerMap.put(key, container);
        }
        for (QAsnEthXCInfo xcInfo : createdXCList) {
            TEEtherEVPLMOPO evplPO = TEEthXCUtil.asn2moEthXC(xcInfo);
            container.getEVPLList().add(evplPO);
        }
        List<QAsnEthXCInfo> createNESuccEvplList = createNESuccEVPLMap.get(key);
        if (null == createNESuccEvplList) {
            createNESuccEvplList = new ArrayList<QAsnEthXCInfo>();
            createNESuccEVPLMap.put(key, createNESuccEvplList);
        }
        createNESuccEvplList.addAll(createdXCList);
    }

    private void saveEVPLTODB(QAsnCreateEthXCRsp rsp, Map<TEEthXCNESlotKey, List<QAsnEthXCInfo>> createNESuccEVPLMap, Map<TEEthXCNESlotKey, TEEtherEVPLContainer> evplContainerMap) {
        if (evplContainerMap.isEmpty()) {
            return;
        }
        TEEthXCNESlotKey key = null;
        TEEtherEVPLContainer container = null;
        Map.Entry<TEEthXCNESlotKey, TEEtherEVPLContainer> entry = null;
        Set<Map.Entry<TEEthXCNESlotKey, TEEtherEVPLContainer>> entrySet = evplContainerMap.entrySet();
        Iterator<Map.Entry<TEEthXCNESlotKey, TEEtherEVPLContainer>> iter = entrySet.iterator();
        int neID = -1;
        int slotID = -1;
        int retCode = 0;
        List<QAsnEthXCInfo> tempXCList = null;
        while (iter.hasNext()) {
            entry = iter.next();
            key = entry.getKey();
            container = entry.getValue();
            if (null == container) continue;
            neID = key.getNeID();
            retCode = TEEthXCUtil.saveContainerToDB(neID, slotID = key.getSlotID(), container);
            if (0 == retCode) {
                tempXCList = createNESuccEVPLMap.get(key);
                if (null == tempXCList) continue;
                rsp.xcInfoList.addAll(tempXCList);
                continue;
            }
            rsp.result.errList.add((Object)TEEthE2ECreateError.createQAsnErrInfo(retCode, new int[]{neID, slotID}));
        }
    }

    public static Map<TEEthXCNESlotKey, List<QAsnEthXCInfo>> buildAsnXCMap(QAsnEthXCInfoList xcInfoList) {
        QAsnEthXCInfo asnXC = null;
        TEEthXCNESlotKey key = null;
        ArrayList<QAsnEthXCInfo> asnXCList = null;
        HashMap<TEEthXCNESlotKey, List<QAsnEthXCInfo>> asnXCMap = new HashMap<TEEthXCNESlotKey, List<QAsnEthXCInfo>>();
        int len = xcInfoList.size();
        for (int i = 0; i < len; ++i) {
            asnXC = (QAsnEthXCInfo)xcInfoList.get(i);
            if (null == asnXC || null == (key = TECreateEthXCHandler.buildNESlotKey(asnXC))) continue;
            asnXCList = (ArrayList<QAsnEthXCInfo>)asnXCMap.get(key);
            if (null == asnXCList) {
                asnXCList = new ArrayList<QAsnEthXCInfo>();
                asnXCMap.put(key, asnXCList);
            }
            asnXCList.add(asnXC);
        }
        return asnXCMap;
    }

    private static TEEthXCNESlotKey buildNESlotKey(QAsnEthXCInfo asnXC) {
        if (null == asnXC) {
            return null;
        }
        TEEthXCNESlotKey key = new TEEthXCNESlotKey();
        key.setNeID(asnXC.xcIndex.neID);
        key.setSlotID(asnXC.xcIndex.slotID);
        return key;
    }

    protected boolean isLogReq() {
        return TEEthXCUtil.isLogOnDebug();
    }

    protected boolean isLogRsp() {
        return TEEthXCUtil.isLogOnDebug();
    }
}

