/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnEthXCInfo;
import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ECreateError;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.service.db.TELinkIDGenerator;
import com.huawei.nglct.nemgr.ip.ngwdm.service_v2r6c01.TECreateEVPLBean;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherEVPLMOPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TECreateEthXCEVPL {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TECreateEthXCEVPL() {
    }

    public static int createEVPL(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrInfoList, List<QAsnEthXCInfo> newAsnXCInfoList, TELinkIDGenerator linkIDGenerator) {
        if (null == ethXCInfo) {
            e2eLogger.error("ethXCInfo is null!");
            return 1090646019;
        }
        if (null == rspErrInfoList) {
            e2eLogger.error("rspErrInfoList is null!");
            return 1090646019;
        }
        if (null == newAsnXCInfoList) {
            e2eLogger.error("newAsnXCInfoList is null!");
            return 1090646019;
        }
        e2eLogger.info("createEVPL: create evpl begin.");
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int result = 0;
        List<QAsnEthXCInfo> asnInfoList = TEEthXCUtil.getSingleDirAsnInfoList(ethXCInfo);
        for (QAsnEthXCInfo xcInfo : asnInfoList) {
            int retCode = 0;
            if (linkIDGenerator.getGeneratedLinkIDList().size() >= 65535) {
                result = 1090650122;
                rspErrInfoList.add((Object)TEEthE2ECreateError.createQAsnErrInfo(40005, new int[]{neID, slotID}));
                continue;
            }
            xcInfo.xcIndex.xcID = linkIDGenerator.generateLinkID();
            TEEtherEVPLContainer container = linkIDGenerator.getEVPLContainer();
            if (TECreateEthXCEVPL.isLinkExist(rspErrInfoList, neID, slotID, xcInfo, container)) {
                result = 1090650122;
                continue;
            }
            if (1 == xcInfo.xcAttr.isActive) {
                retCode = TECreateEthXCEVPL.createEVPLToNE(xcInfo, rspErrInfoList);
            }
            if (0 == retCode) {
                newAsnXCInfoList.add(xcInfo);
                continue;
            }
            result = 1090650122;
        }
        e2eLogger.info("createEVPL: create evpl end.");
        return result;
    }

    private static boolean isLinkExist(QAsnErrInfoList rspErrInfoList, int neID, int slotID, QAsnEthXCInfo xcInfo, TEEtherEVPLContainer container) {
        ArrayList<QAsnEthXCInfo> unDirXCInfoList = new ArrayList<QAsnEthXCInfo>();
        List<TEEtherEVPLMOPO> evplMOList = TEEthXCUtil.getEVPLMOFromDB(xcInfo, unDirXCInfoList, container);
        if (!evplMOList.isEmpty()) {
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = 1090598185;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            rspErrInfoList.add((Object)errInfo);
            return true;
        }
        return false;
    }

    private static int createEVPLToNE(QAsnEthXCInfo ethXCInfo, QAsnErrInfoList rspErrInfoList) {
        Datainterface inputData;
        SubFunc subFunc;
        int retCode = 0;
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int serviceType = ethXCInfo.xcIndex.xcType;
        int linkType = ethXCInfo.xcIndex.linkType;
        int direction = ethXCInfo.xcAttr.direction;
        int sfid = TECreateEthXCEVPL.getSfid(serviceType, linkType, direction);
        TENEMgrInterface bean = TECreateEthXCEVPL.getCreateEVPLBean(neID, sfid);
        Datainterface outputData = bean.performBussinessProcess(neID, subFunc = TEEthXCUtil.createSubFunc(neID, sfid), inputData = TECreateEthXCEVPL.createCreateInputData(ethXCInfo), null, null, null);
        if (null == outputData) {
            TECreateEthXCEVPL.logOutputDataNullError(neID, slotID, inputData);
            retCode = 1090646019;
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            rspErrInfoList.add((Object)errInfo);
            e2eLogger.info("createEVPLToNE: create evpl end.");
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            TECreateEthXCEVPL.logBeanOperError(retCode, neID, slotID, inputData);
            TEE2EVBUtil.printRowError(outputData);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, rspErrInfoList);
        }
        return retCode;
    }

    private static void logBeanOperError(int retCode, int neID, int slotID, Datainterface inputData) {
        String tipStr = "createEVPLToNE: create evpl to ne fail! ";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
        tipStr = tipStr + '\n' + inputData.toString();
        e2eLogger.error(tipStr);
    }

    private static void logOutputDataNullError(int neID, int slotID, Datainterface inputData) {
        String tipStr = "createEVPLToNE: create evpl to ne fail! outputData is null!";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
        tipStr = tipStr + '\n' + inputData.toString();
        e2eLogger.error(tipStr);
    }

    public static TENEMgrInterface getCreateEVPLBean(int neID, int sfid) {
        TECommonWriteLogBean bean = null;
        int codeVersion = TEEthXCUtil.getEVPLCodeVersion(neID, sfid);
        bean = 1 == codeVersion ? new TECreateEVPLBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isNeedSendCreateNtf() {
                return false;
            }

            @Override
            protected boolean isNeedSaveDBOnCreate() {
                return false;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.service.TECreateEVPLBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            protected boolean isNeedSendCreateNtf() {
                return false;
            }

            @Override
            protected boolean isNeedSaveDBOnCreate() {
                return false;
            }
        };
        return bean;
    }

    public static Datainterface createCreateInputData(QAsnEthXCInfo ethXCInfo) {
        if (null == ethXCInfo) {
            e2eLogger.error("ethXCInfo is null!");
            return new Datainterface();
        }
        int neID = ethXCInfo.xcIndex.neID;
        int slotID = ethXCInfo.xcIndex.slotID;
        int xcType = ethXCInfo.xcIndex.xcType;
        int linkType = ethXCInfo.xcIndex.linkType;
        int srcPort = ethXCInfo.xcAttr.srcEndTP.portID;
        int srcPortType = ethXCInfo.xcAttr.srcEndTP.portType;
        int srcCVlan = TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.srcEndTP.vlanID);
        int srcSVlan = TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.srcEndTP.svlanID);
        int snkPort = ethXCInfo.xcAttr.snkEndTP.portID;
        int snkPortType = ethXCInfo.xcAttr.snkEndTP.portType;
        int snkCVlan = TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.snkEndTP.vlanID);
        int snkSVlan = TEEthXCUtil.getWebLCTVlanID(ethXCInfo.xcAttr.snkEndTP.svlanID);
        srcPort = TEEthXCUtil.getWebLCTPortID(srcPort, srcPortType);
        snkPort = TEEthXCUtil.getWebLCTPortID(snkPort, snkPortType);
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotID", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("linkID", String.valueOf(ethXCInfo.xcIndex.xcID));
        rowparams.addParam(param);
        param = new Param("srcPort", String.valueOf(srcPort));
        rowparams.addParam(param);
        param = new Param("srcCVlan", String.valueOf(srcCVlan));
        rowparams.addParam(param);
        param = new Param("srcSVlan", String.valueOf(srcSVlan));
        rowparams.addParam(param);
        param = new Param("snkPort", String.valueOf(snkPort));
        rowparams.addParam(param);
        param = new Param("snkCVlan", String.valueOf(snkCVlan));
        rowparams.addParam(param);
        param = new Param("snkSVlan", String.valueOf(snkSVlan));
        rowparams.addParam(param);
        if (4 != xcType) {
            param = new Param("direction", "unilateralism");
            rowparams.addParam(param);
        }
        if (4 == xcType && 7 == linkType) {
            param = new Param("operateType", "AddDouble");
            rowparams.addParam(param);
        }
        if (4 == xcType && 9 == linkType) {
            param = new Param("operateType", "DeleteDouble");
            rowparams.addParam(param);
        }
        return inputData;
    }

    public static int getSfid(int serviceType, int linkType, int direction) {
        int sfid = 2108699;
        if (0 == serviceType) {
            sfid = 2108699;
        } else if (1 == serviceType) {
            sfid = 2108699;
        } else if (4 == serviceType) {
            switch (linkType) {
                case 6: {
                    sfid = 3091599;
                    break;
                }
                case 7: {
                    sfid = 3091599;
                    break;
                }
                case 8: {
                    sfid = 3091601;
                    break;
                }
                case 9: {
                    sfid = 3091601;
                    break;
                }
                case 10: {
                    sfid = 3091602;
                    break;
                }
                case 20: {
                    sfid = 2108699;
                    break;
                }
                default: {
                    sfid = -1;
                    e2eLogger.error("The linkType is error! linkType->" + linkType);
                    break;
                }
            }
        } else {
            e2eLogger.error(String.format("The serviceType is undefined!serviceType:%d", serviceType));
        }
        return sfid;
    }
}

